"use strict";
var $formAddValidate = $("#frmAddBranch");
var $formEditValidate = $("#frmEditBranch");
var dataTable = "";

var branch = {
  init: function () {
    $("#frmAddBranch").validate({
      rules: {
        add_name: {
          required: !0,
        },
        add_idcurrency: {
          required: !0,
        },
        add_subdomain: {
          required: !0,
        },
        add_agencycode: {
          required: !0,
        },
        add_type: {
          required: !0,
        },
      },
      invalidHandler: function (e, r) {
        $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop();
      },
      submitHandler: function (e) {},
    });
  },
  list: function () {
    // Setup - add a text input to each footer cell
    var i = 0;
    $("#dtClientsList tfoot th").each(function () {
      if (i != 6) {
        var title = $(this).text();
        $(this).html(
          '<input type="text" placeholder="' +
            title +
            '" style="width:100%;" />'
        );
      }
      i++;
    });

    dataTable = $("#dtClientsList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      ajax: {
        url: "../model/branch_model.php", // json datasource
        data: {
          action: "list",
        },
        type: "post",
        error: function () {},
      }, //"className": "text-center",
      columnDefs: [
        {
          targets: [-1],
          orderable: false,
        },
        {
          targets: [3, 4, 5],
          className: "text-center",
        },
      ],
      order: [[0, "asc"]],
      drawCallback: function (response) {
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
      },
    });
    // Apply the search
    dataTable.columns().every(function () {
      var that = this;
      $("input", this.footer()).on("keyup change", function () {
        if (that.search() !== this.value) {
          that.search(this.value).draw();
        }
      });
    });
  },
  edit: function (id) {
    branch.clear();
    var parametros = {
      action: "edit",
      id: id,
    };
    preloader("show");
    $.ajax({
      data: parametros,
      url: "../model/branch_model.php",
      type: "post",
      success: function (response) {
        if (response.code == "440") {
          loginTimeout(response.message);
          return;
        }
        console.log(response);
        var objs = JSON.parse(response);
        if (objs.code == "440") {
          loginTimeout(objs.message);
          return;
        }
        preloader("hide");
        var subdomain = objs[0].subdomain.split(".");
        console.log(objs[0].agency_code);
        $("#edit_id").val(objs[0].id);
        $("#edit_name").val(objs[0].c_name);
        $("#edit_idcurrency").val(objs[0].id_currency);
        $("#edit_id_parent").val(objs[0].parents);
        $("#edit_subdomain").val(subdomain[0]);
        $("#edit_agencycode").val(objs[0].codigo);
        $("#edit_commision").val(objs[0].commission);
        $("#edit_subdomain_a").val(objs[0].subdomain);
        $("#edit_type").val(objs[0].type);
        $("#edit_brach_admin").val(objs[0].username);
        $("#edit_pass_new_branch").val(objs[0].password);
        $("#edit_rpass_new_branch").val(objs[0].password);
        $("#modal_edit_branch").modal("show");
      },
    });
  },
  delete: function (id) {
    swal({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      type: "warning",
      showCancelButton: !0,
      confirmButtonText: "Yes, delete it!",
    }).then(function (e) {
      if (e.dismiss === "cancel") {
        swal("Cancelled", "Data is safe :)", "error");
      }
      if (e.value) {
        var parametros = {
          action: "delete",
          id: id,
        };
        $.post(
          "../model/branch_model.php",
          parametros,
          function (data) {
            if (data.code == "440") {
              loginTimeout(data.message);
              return;
            }
            if (data == 1) {
              swal("Deleted!", "Your record has been deleted.", "success");
              dataTable.draw();
            }
          },
          "json"
        );
      }
    });
  },
  events: function () {
    $("#modal_add_branch").on("shown.bs.modal", function () {
      $("#add_id_parent").select2({
        placeholder: "Select Broker...",
        dropdownParent: $("#modal_add_branch"),
        allowClear: true,
      });
    });

    ///johaan
    $("#brach_admin").focusout(function () {
      var id_parent = "";
      if ($("#id_parent").val() != "") {
        id_parent = $("#add_id_parent").val();
      }
      var Administrador = $("#brach_admin").val();
      $.post(
        "../model/branch_model.php",
        {
          action: "Administrador",
          Administrador: Administrador,
          id_parent: id_parent,
        },
        function (data) {
          if (data.res === "yes") {
            swal("NO, The User Already Exists ...!");
            $("#brach_admin").val("");
            $("#brach_admin").focus();
          }
        },
        "json"
      );
    });

    $("#add_branch").click(function () {
      branch.clear();
      $("#modal_add_branch").modal("show");
    });

    //johaan
    $("#branch_button_add").click(function () {
      if ($formAddValidate.valid()) {
        var id_parent = "";
        if ($("#id_parent").val() != "") {
          id_parent = $("#add_id_parent").val();
        }
        var pass_admin = $("#pass_new_branch").val();
        var rep_pass_admin = $("#rpass_new_branch").val();
        if (pass_admin !== rep_pass_admin) {
          swal("Please, The Keys Do Not Match");
          $("#rpass_new_branch").val("");
          $("#rpass_new_branch").focus();
        } else {
          var parametros = {
            action: "insert",
            name: $("#add_name").val(),
            id_currency: $("#add_idcurrency").val(),
            subdomain: $("#add_subdomain").val(),
            type: $("#add_type").val(),
            id_parent: id_parent,
            agency_code: $("#add_agencycode").val(),
            commission: $("#add_commision").val(),
            password: $("#pass_new_branch").val(), //johaan
            username: $("#brach_admin").val(),
          };
          preloader("show");
          $.post(
            "../model/branch_model.php",
            parametros,
            function (data) {
              console.log(data);
              if (data.code == "400") {
                swal("I'm sorry the branch or agency already exists");
              }
              if (data.code == "200") {
                $("#modal_add_branch").modal("hide");
                preloader("hide", "Recod Added....!", "success");
                $("#add_name").val("");
                $("#add_subdomain").val("");
                $("#add_type").val("");
                $("#add_idcurrency").val("");
                $("#add_agencycode").val("");
                dataTable.draw();
                setTimeout(function () {
                  if (data.code_email == 200) {
                    swal(
                      "Email Was Sent To The Web Administrator To Activate The New Client...!"
                    );
                  }
                }, 2000);
              }
            },
            "json"
          );
        }
      } else {
        $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop();
      }
    });

    $("#branch_button_edit").click(function () {
      if ($formEditValidate.valid()) {
        var id_parent = $("#edit_id_parent").val();
        var pass_admin = $("#edit_pass_new_branch").val();
        var rep_pass_admin = $("#edit_rpass_new_branch").val();
        if (pass_admin !== rep_pass_admin) {
          swal("Please, The Keys Do Not Match");
          $("#edit_rpass_new_branch").val("");
          $("#edit_rpass_new_branch").focus();
        } else {
          var parametros = {
            action: "update",
            id: $("#edit_id").val(),
            name: $("#edit_name").val(),
            id_currency: $("#edit_idcurrency").val(),
            subdomain: $("#edit_subdomain").val(),
            type: $("#edit_type").val(),
            id_parent: id_parent,
            agency_code: $("#edit_agencycode").val(),
            commission:
              $("#edit_commision").val() == "" ? 0 : $("#edit_commision").val(),
            password: $("#edit_pass_new_branch").val(), //johaan
            username: $("#edit_brach_admin").val(),
          };
          preloader("show");
          $.ajax({
            data: parametros,
            url: "../model/branch_model.php",
            type: "post",
            dataType: "json",
            success: function (response) {
              if (response.code == "440") {
                loginTimeout(response.message);
                return;
              }
              if (response.code == "200") {
                $("#modal_edit_branch").modal("hide");
                preloader("hide", response.message, "success");
                dataTable.draw();
              } else {
                preloader("hide", "Could Not Update The Record...!", "error");
              }
            },
            error: function (jqXHR, textStatus, errorThrown) {
              swal({
                title: "Error..!",
                type: "error",
              });
              console.log(jqXHR);
              console.log(textStatus);
              console.log(errorThrown);
            },
          });
        }
      } else {
        $("#msg_alert_2").removeClass("m--hide").show(), mUtil.scrollTop();
      }
    });
  },
  verSubdomain: function (form) {
    var subdomain = $("#" + form + "_subdomain").val();
    var subdomaina = $("#" + form + "_subdomain_a").val();
    var agencycode = $("#" + form + "_agencycode").val();
    var agenciyC = $("#" + form + "_agencycode_a").val();

    $("#branch_button_" + form).removeClass("disabled");
    $("#branch_button_" + form).removeClass("enabled");
    $("#" + form + "_veri").addClass("m--hide");
    $("#" + form + "_icon").removeClass("m--font-danger");
    $("#" + form + "_icon").removeClass("m--font-success");
    $("#" + form + "_icon").removeClass("la la-check");
    $("#" + form + "_icon").removeClass("la la-remove");
    var parametros = {
      action: "existSubdomain",
      subdomain: subdomain,
    };
    $.ajax({
      data: parametros,
      url: "../model/branch_model.php",
      type: "post",
      success: function (response) {
        if (response) {
          $("#" + form + "_veri").removeClass("m--hide");
          $("#" + form + "_icon").addClass("la la-remove");
          $("#" + form + "_icon").addClass("m--font-danger");
          $("#branch_button_" + form).addClass("disabled");
        } else {
          $("#" + form + "_veri").removeClass("m--hide");
          $("#" + form + "_icon").addClass("la la-check");
          $("#" + form + "_icon").addClass("m--font-success");
          $("#branch_button_" + form).addClass("enabled");
        }
      },
    });
  },
  verAgencyCode: function (form) {
    var subdomain = $("#" + form + "_subdomain").val();
    var subdomaina = $("#" + form + "_subdomain_a").val();
    var agencycode = $("#" + form + "_agencycode").val();
    var agenciyC = $("#" + form + "_agencycode_a").val();

    $("#" + form + "_veri_ag").addClass("m--hide");
    $("#" + form + "_icon2").removeClass("m--font-danger");
    $("#" + form + "_icon2").removeClass("m--font-success");
    $("#" + form + "_icon2").removeClass("la la-check");
    $("#" + form + "_icon2").removeClass("la la-remove");

    if (agencycode == "") {
      $("#" + form + "_veri_ag").addClass("m--hide");
      $("#" + form + "_icon2").addClass("la la-spinner");
      $("#" + form + "_icon2").addClass("m--font-warning");
      return false;
    }
    if (agencycode == agenciyC) {
      $("#" + form + "_veri_ag").removeClass("m--hide");
      $("#" + form + "_icon2").addClass("la la-refresh");
      $("#" + form + "_icon2").addClass("m--font-info");
      return false;
    }
    //alert(agencycode);
    var parametros = {
      action: "existAgencyCode",
      agencycode: agencycode,
    };
    $.ajax({
      data: parametros,
      url: "../model/branch_model.php",
      type: "post",
      success: function (response) {
        if (response) {
          $("#branch_button_add").attr("disabled", true);
          $("#branch_button_add").attr("eabled", false);
          $("#" + form + "_veri_ag").removeClass("m--hide");
          $("#" + form + "_icon2").addClass("la la-remove");
          $("#" + form + "_icon2").addClass("m--font-danger");
        } else {
          $("#" + form + "_veri_ag").removeClass("m--hide");
          $("#" + form + "_icon2").addClass("la la-check");
          $("#" + form + "_icon2").addClass("m--font-success");
          $("#branch_button_add").attr("eabled", true);
          $("#branch_button_add").attr("disabled", false);
        }
      },
    });
  },
  clear: function () {
    $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
    $("#subdomain_parent").val("");
    $("#add_name").val("");
    $("#add_subdomain").val("");
    $("#add_agencycode").val("");
    $("#edit_name").val("");
    $("#edit_agencycode").val("");
    $("#edit_subdomain").val("");
    $("#Administrador").val("");
    $("#pass_new_branch").val(""); //johaan
    $("rpass_new_branch").val("");
    $formAddValidate.validate().resetForm();
    $formEditValidate.validate().resetForm();
  }, //johaan
  verPass: function () {
    var tipo = document.getElementById("pass_new_branch");
    var tipo2 = document.getElementById("rpass_new_branch");

    if (tipo.type == "password") {
      tipo.type = "text";
      tipo2.type = "text";
    } else {
      tipo.type = "password";
      tipo2.type = "password";
    }
  },
  verPassEdit: function () {
    var tipo = document.getElementById("edit_pass_new_branch");
    var tipo2 = document.getElementById("edit_rpass_new_branch");

    if (tipo.type == "password") {
      tipo.type = "text";
      tipo2.type = "text";
    } else {
      tipo.type = "password";
      tipo2.type = "password";
    }
  },
  combo_strBroker: function () {
    $("#add_id_parent").html("");
    var list = $("#add_id_parent");
    var datos = {
      action: "combo_strBroker",
    };
    //preloader('show');
    $.post(
      "../model/branch_model.php",
      datos,
      function (response) {
        if (response.code == "440") {
          loginTimeout(response.message);
          return;
        }
        list.append(new Option("Select Broker...", ""));
        $.each(response.data, function (index, item) {
          list.append(new Option(item.name, item.id));
        });
      },
      "json"
    );
  },
};
jQuery(document).ready(function () {
  branch.list();
  branch.events();
  branch.combo_strBroker();
});
