var dataTable = '',
    dataTableTrigger = '',
    $condition = false,
    formTrigger = $('#formTrigger');

$(function() {  

    automation_list.init();
    automation_list.dt_automation_list();
    automation_list.events();
    automation_list.clear();

});

automation_list = {
    init: function() {

        formTrigger.validate({
            rules: {
                trigger_name: {
                    required: true
                },
                automation_trigger: {
                    required: true
                }
            }
        });

        $("#modalTrigger").on("shown.bs.modal", function() {
            $("#value_tags").select2({
                    multiple: true,
                    tags: true,
                    maximumSelectionLength: 1,
                });

        });

    },

    dt_trigger_list: function() {
        if ($.fn.DataTable.isDataTable("#dtTriggerList")) {
            $('#dtTriggerList').DataTable().clear().destroy();
        }
        dataTableTrigger = $('#dtTriggerList').DataTable({
            "processing": true,
            "serverSide": true,
            "searching": false,
            "lengthChange": false,
            "ajax": {
                url: "../model/automation_model.php", // json datasource
                data: {
                    method: "dtTriggerList",
                    id_automation: $('#id_automation').val()
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            'columnDefs': [
                {"sClass": "dpass",
                "aTargets": [0]
                }
            ],
            "order": [
                [1, "asc"]
            ]
        });
    },

    dt_automation_list: function() {
        dataTable = $('#dtAutomationList').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "../model/automation_model.php", // json datasource
                data: {
                    method: "dtAutomationList"
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            'columnDefs': [
                {"sClass": "dpass",
                "aTargets": [0]
                }
            ],
            "order": [
                [1, "asc"]
            ]
        });
    },

    delete_automation: function(id) {
        swal({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    method: 'deleteAutomation',
                    id: id
                };
                $.post('../model/automation_model.php', parametros, function(data) {
                    if (data == 1) {
                        swal("Deleted!", "Automation has been deleted.", "success");
                        dataTable.draw();
                    }
                });
            }
        });
    },    

    events: function() {

        $('#dtTriggerList tbody').on('click', '.btnDelete', function() {
            var data = dataTableTrigger.row($(this).parents('tr')).data();
            var id = data[0];
            swal({
                title: "You're going to delete a Trigger. Are you sure?",
                // text: "You're going to ....",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, delete it!"
            }).then(function (e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Trigger was not deleted!", "error");
                }
                if (e.value) {
                    var datos = {
                        method: 'deleteTrigger',
                        id: id
                    };
                    $.post("../model/automation_model.php", datos,
                        function (data) {
                            if (data.response === 'Trigger Deleted') {    
                                swal("Success", "Trigger Deleted...!!", "success");
                                automation_list.dt_trigger_list();
                                dataTable.draw();
                            } else {
                                swal("Information", "Trigger Already Exist...!", "info");
                            }
                        }, "json");
                }
            });
        });

        $('#dtAutomationList tbody').on('click', '.btnTrigger', function() {
            var data = dataTable.row($(this).parents('tr')).data();
            var id = data[0];
            $('#id_automation').val(id);
            automation_list.dt_trigger_list();

            //console.log($('#id_automation').val());
        });

        $('#triggerButton').click(function (e) {
            $('#modalTrigger').modal('show');
        });

        $('#btnNewAutomation').click(function() {
            sessionStorage.setItem('idAutomation', '');
            window.location.href = 'automation.php';
        });

        $('#selectServicesDiv').hide();
        $('#selecCampaignDiv').hide();
        $('#div_value_tags').hide();
        $('#btnServices').click(function (e) {
            e.preventDefault();
        });
        $('#automation_trigger').change(function () {
            $('#selectServicesDiv').hide();
            $('#selecCampaignDiv').hide();
            $('#div_value_tags').hide();
            $('#value_tags').rules("remove", "required");
            if($(this).val() == 2 || $(this).val() == 6 || $(this).val() == 7){
                $('#div_value_tags').show();
                $('#value_tags').rules("add", "required");
            }
            if ($(this).val() == 3 ) {
                $('#selectServicesDiv').show();
                $('#selecCampaignDiv').show();
            }
        });
        $('#selectServices').change(function () {
            $('#selecCampaign').html('');
            var list = $('#selecCampaign');
            var id = this.value;
            preloader('show');
            $.post("../model/automation_model.php", {
                    method: 'combo_flow_automation',
                    id: id
                },
                function (data) {
                    preloader('hide');
                    list.append(new Option('Select Campaign Leads', ''));
                    $.each(data.salida, function (index, item) {
                        list.append(new Option(item.name, item.id));
                    });
                }, "json");
        });

        $('#btnSaveAutomation').click(function (e) { // pendiente
            e.preventDefault();
            swal({
                title: "You're going to save an Automation. Are you sure?",
                // text: "You're going to ....",
                type: "warning",
                showCancelButton: !0,
                confirmButtonText: "Yes, save it!"
            }).then(function (e) {
                if (e.dismiss === "cancel") {
                    swal("Cancelled", "Automation was not saved!", "error");
                }
                if (e.value) {

                    var datos = {
                        method: 'saveAutomation',
                        automation_name: $('#automation_name').val(),
                        automation_description: $('#automation_description').val()
                    };
                    //preloader('show');
                    $.post("../model/automation_model.php", datos,
                        function (data) {
                            if (data.mss == 'Automation Saved') {
                                id_automation = data.id_automation;
                                //preloader('hide', 'New Trigger and Automation Created...!', 'success');
                                swal("Success", "New Automation Created...!!", "success");
                            } else {
                                //preloader('hide', 'Trigger and Automation Already Exist...!', 'danger');
                                swal("Information", "Automation Already Exist...!", "info");
                            }
                        }, "json");
                }
            });
        });

        $('#btnSaveTrigger').click(function (e) { // pendiente
            e.preventDefault();

            if (formTrigger.valid()) {
                var value_tags = '';
                $('select[name^="value_tags"]').each(function() {
                    value_tags += $(this).val();
                });
                swal({
                    title: "You're going to save a Trigger. Are you sure?",
                    // text: "You're going to ....",
                    type: "warning",
                    showCancelButton: !0,
                    confirmButtonText: "Yes, save it!"
                }).then(function (e) {
                    if (e.dismiss === "cancel") {
                        swal("Cancelled", "Trigger was not saved!", "error");
                    }
                    if (e.value) {
                    	var idCampaign = 0;
                    	if ($('#automation_trigger').val() == 3) {
                    		idCampaign = $('#selecCampaign').val();
                    	}                    	
                        var datos = {
                            method: 'setTrigger',
                            trigger_name: $('#trigger_name').val(),
                            automation_trigger: $('#automation_trigger').val(),
                            id_automation: $('#id_automation').val(),
                            id_campaign: idCampaign,
                            value_tags: value_tags
                        };
                        $.post("../model/automation_model.php", datos,
                            function (data) {
                                if (data.response === 'Trigger Saved') {
                                    swal("Success", "New Trigger Created...!!", "success");
                                    if ($.fn.DataTable.isDataTable("#dtTriggerList")) {
                                        $('#dtTriggerList').DataTable().clear().destroy();
                                    }
                                    automation_list.dt_trigger_list();
                                    automation_list.clear();
                                    dataTable.draw();
                                } else {
                                    swal("Information", "Trigger Already Exist...!", "info");
                                }
                            }, "json");
                    }
                });
            }
        });
    },

    clon_automation: function(automation_id) {

        swal({
            title: "Are you sure?",
            text: "Do you want to, clone this automation?",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, do it!"
        }).then(function(e) {
            //e.value && swal("Deleted!", "Your file has been deleted.", "success")
            if (e.dismiss) {
                swal({
                    position: "top-center",
                    type: "success",
                    title: 'Data is safe :)',
                    showConfirmButton: !1,
                    timer: 1500
                });
            }
            if (e.value) {
                preloader('show');
                $('#modal_confirm').modal('hide');
                    var datos = {
                        method: 'dtTriggerListClone',
                        id_automation: automation_id
                    };
                $.post("../model/automation_model.php", datos, function(response) {
                    preloader('hide');
                    if (response.data == '') {

                        setTimeout(function() {
                                swal({
                                    position: "top-center",
                                    type: "warning",
                                    title: 'The automation has no trigger :(',
                                    showConfirmButton: !1,
                                    timer: 3000
                                });
                        }, 100);                
                    }else{
                        $('#modal_confirm').modal('hide');
                            var datos = {
                                method: 'clon_automation',
                                id_automation_old: automation_id
                            };
                        $.post("../model/automation_model.php", datos, function(response) {
                            if (response.code == '200') {
                                swal(response.message, 'success');
                                dataTable.draw();
                            }
                        }, "json");
                    }
                }, "json");
            }

        });



    },
    getIdAutomation: function(automation_id) {
        sessionStorage.setItem('idAutomation', automation_id);
        window.location.href='automation.php';
    },

    getIdCampaign: function(idcampaign) {
        sessionStorage.setItem('idcampaign', idcampaign);
        window.location.href='automation.php';
    },

    clear: () => {
        formTrigger.validate().resetForm();
        $('#selectServices').val("");
        $('#selecCampaign').val("");
        $('#selectServicesDiv').hide();
        $('#selecCampaignDiv').hide();      
    }

};