"use strict";

const NUMRAMDOM = 10;
const MODEL = "../model/automation_model.php";

var flowchart = "";

var timeDetails = "";

var zoomSelectorCount = 2;
var formNodeCall = $("#formNodeCall");
var formNodeCheckTags = $("#formNodeCheckTags");
var formNodeCondition = $("#formNodeCondition");
var formNodeEmail = $("#formNodeEmail");
var formNodeSms = $("#formNodeSms");
var formNodeMms = $("#formNodeMms");
var formNodeWhatsapp = $("#formNodeWhatsapp");
var formNodeTags = $("#formNodeTags");
var formNodeWait = $("#formNodeWait");
var formNodeProperty = $("#formNodeProperty");
var formTestMaskPhone = $("#formTestMaskPhone");
var form_media_w = $("#form_media_w");

var id_automation = "";
//var input_image = '';
var attachedImage = "";
$("#formNodeProperty");

var makeCall = "";
var hasOptions = "";
var parameter = "";

var callOwmner = "";
var userToCallId = "";

var smsOwmner = "";
var userToSmsId = "";

var mmsOwmner = "";
var userToMmsId = "";

var emailOwmner = "";
var userToEmailId = "";

var selectorDeOperador = "";

var modules = "automation";
var file64;
var inputFile;
var excludedTypes = [
  "application/pdf",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "application/vnd.ms-excel",
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "application/msword",
];

var Automation = {
  init: () => {
    $("#modalNodeCall").on("shown.bs.modal", function () {
      $("#userToCall").select2({
        placeholder: "Select Users",
        tags: !0,
      });
    });

    $("#modalCampaignNodeSms").on("shown.bs.modal", function () {
      $("#userToSms").select2({
        placeholder: "Select Users",
        tags: !0,
      });
    });

    $("#modalCampaignNodeMms").on("shown.bs.modal", function () {
      $("#userToMms").select2({
        placeholder: "Select Users",
        tags: !0,
      });
    });

    $("#modalCampaignNodeEmail").on("shown.bs.modal", function () {
      $("#userToEmail").select2({
        placeholder: "Select Users",
        tags: !0,
      });
    });

    flowchart = $("#automationView");
    var $container = flowchart.parent();
    var cx = flowchart.width() / 2;
    var cy = flowchart.height() / 2;
    // Panzoom initialization...
    flowchart.panzoom();
    // Centering panzoom
    flowchart.panzoom(
      "pan",
      -cx + $container.width() / 2,
      -cy + $container.height() / 2
    );
    $(".zoomContainner button").click(function (e) {
      // listo
      var possibleZooms = [0.5, 0.75, 1, 1.25, 1.5, 1.75, 2, 2.5, 2.75, 3];
      var action = $(this).attr("class");
      flowchart.flowchart("setPositionRatio", possibleZooms[zoomSelectorCount]);
      flowchart.panzoom("zoom", possibleZooms[zoomSelectorCount], {
        animate: false,
        focal: e,
      });
      if (
        action ==
          "btn btn-outline-success m-btn m-btn--icon m-btn--outline-2x btn-block tr zoomIn" &&
        zoomSelectorCount < 7
      ) {
        zoomSelectorCount++;
        //console.log(zoomSelectorCount);
      } else if (
        action ==
          "btn btn-outline-accent m-btn m-btn--icon m-btn--outline-2x btn-block tr zoomOut" &&
        zoomSelectorCount > 0
      ) {
        zoomSelectorCount--;
      }
    });

    var data = {
      operators: {
        begin: {
          top: 20,
          left: 20,
          properties: {
            title: "Begin",
            inputs: {},
            outputs: {
              output_1: {
                label: "Next",
              },
            },
          },
        },
      },
      links: {},
    };

    flowchart.flowchart({
      //inicio de graphic
      data: data,
      onOperatorSelect: function (operatorId) {
        var title = flowchart.flowchart("getOperatorTitle", operatorId);
        if (title !== "Begin") {
          $("#modal_confirm").modal("show");
        }
        return true;
      },
      onLinkCreate: function (linkId, linkData) {
        var data = linkData;
        var from = data.fromOperator;
        var to = data.toOperator;
        var fromConnector = data.fromConnector;
        var option = "";
        var operatorName = "";

        if (fromConnector == "output_1") {
          operatorName = flowchart.flowchart("getOperatorTitle", from);
          //console.log(operatorName);
          if (operatorName === "Begin") {
            var d = {
              to: to,
              method: "setBeginNode",
            };
            //preloader('show');
            $.post(
              MODEL,
              d,
              function (data) {
                // preloader('hide');
              },
              "json"
            );
          }
          option = "yes";
        }
        if (fromConnector == "output_2") {
          option = "no";
        }
        if (fromConnector == "output_3") {
          option = "call_3";
        }
        if (fromConnector == "output_4") {
          option = "call_4";
        }

        setTimeout(function () {
          //despues de 3 segundos hace la conection de nodes
          var datos = {
            method: "ConnectorNode",
            from: from,
            to: to,
            option: option,
          };
          $.post(
            MODEL,
            datos,
            function (data) {
              if (data.res === "yes") {
                Automation.saveGraphic(); //guarda la grafica
              }
            },
            "json"
          );
        }, 3000);

        return true;
      },
      onOperatorMouseOver: function (operatorId) {
        var title = flowchart.flowchart("getOperatorTitle", operatorId);
        if (title !== "Begin") {
          var datos = {
            method: "viewNodeDetails",
            operatorId: operatorId,
          };

          timeDetails = setTimeout(() => {
            $.post(
              MODEL,
              datos,
              function (data) {
                $("#viewNodeDetails").html(data);
                $("#modalDetailsNode").modal("show");
              },
              "html"
            );
          }, 3000);
        }
      },
      onOperatorMouseOut: function (param) {
        clearTimeout(timeDetails);
      },
    });

    //////// valid

    formNodeCall.validate({
      rules: {
        name: {
          required: true,
        },
      },
    });

    formNodeCondition.validate({
      rules: {
        titleNodeCondition: {
          required: true,
        },
      },
    });

    formNodeCheckTags.validate({
      rules: {
        campaign_input_cnct_tags: {
          required: true,
        },
        titleNodeCheckTags: {
          required: true,
        },
      },
    });

    formNodeEmail.validate({
      rules: {
        campaign_input_cne_subbject: {
          required: true,
        },
        titleNodeEmail: {
          required: true,
        },
      },
    });

    formNodeSms.validate({
      rules: {
        message: {
          required: true,
        },
        titleNodeSms: {
          required: true,
        },
      },
    });

    formNodeMms.validate({
      rules: {
        message: {
          required: true,
        },
        titleNodeMms: {
          required: true,
        },
      },
    });

    formNodeWhatsapp.validate({
      rules: {        
        titleNodeWhatsapp: {
          required: true,
        },
      },
    });

    formNodeTags.validate({
      rules: {
        cnct_tags: {
          required: true,
        },
        titleNodeTags: {
          required: true,
        },
      },
    });

    formNodeWait.validate({
      rules: {
        value_duration: {
          required: true,
        },
        cnw_id_time: {
          required: true,
        },
        titleNodeWait: {
          required: true,
        },
      },
    });

    formNodeProperty.validate({
      rules: {
        cnsp_value: {
          required: true,
        },
        titleNodeProperty: {
          required: true,
        },
      },
    });

    formTestMaskPhone.validate({
      rules: {
        from: {
          required: true,
        },
        to: {
          required: true,
        },
      },
    });

    var CKEDITOR = $("#campaign_input_cne_html");
    if (CKEDITOR.length) {
      CKEDITOR.ckeditor(
        function () {
          /* Callback function code. */
        },
        {
          customConfig: "config.js",
          allowedContent: true,
          height: 200,
          width: 720,
        }
      );
    }
  },
  events: () => {
    $("#testMaskPhoneModal").click(function (e) {
      Automation.clear();
    });

    $("#btnTestPhone").click(function (e) {
      e.preventDefault();

      if (formTestMaskPhone.valid()) {
        swal({
          title: "You're going to make a Call. Are you sure?",
          text: "If 'YES', please wait 20 seconds",
          type: "warning",
          showCancelButton: !0,
          confirmButtonText: "Yes, do it!",
        }).then(function (e) {
          if (e.dismiss === "cancel") {
            swal("Cancelled", "Test aborted!", "error");
          }
          if (e.value) {
            var datos = {
              method: "makeTestPhonecall",
              from: $("#maskPhoneNumber").val(),
              to: $("#toPhoneNumber").val(),
            };
            preloader("show");
            $.post(
              "../ws/wsTestMask.php",
              datos,
              function (data) {
                if (data.response === "200") {
                  if (
                    data.hangupSource == "Carrier" ||
                    data.hangupSource == "Error"
                  ) {
                    swal(
                      "Outbound Call with Issues",
                      "The operator rejected the call, you shouldn't use this mask number",
                      "warning"
                    );
                  } else {
                    var $phone_number = data.phone_number;
                    swal(
                      "Outbound Call Maked!",
                      "If you receive the call, can use the number " +
                        $phone_number +
                        " for masking in your operator",
                      "success"
                    );
                  }
                }
                if (data.response === "400") {
                  var $plivoMessage = data.responsePlivo;
                  swal(
                    "Fail...!",
                    "Error: " + $plivoMessage + ". Try another number",
                    "error"
                  );
                }
              },
              "json"
            );
          }
        });
      }
    });

    $("#selectServicesDiv").hide();
    $("#selecCampaignDiv").hide();
    $("#audioFileDiv").hide();

    $("#btnServices").click(function (e) {
      // listo
      e.preventDefault();
    });

    $("#type").change(function () {
      if ($(this).val() == 6) {
        $("#parameterDiv").hide();
        $("#audioFileDiv").show();
        $("#audioFile").attr("required");
        $("#parameter").removeAttr("required");
      } else {
        $("#parameterDiv").show();
        $("#audioFileDiv").hide();
        $("#audioFile").removeAttr("required");
        $("#parameter").attr("required");
      }
    });

    $("#automation_trigger").change(function () {
      // listo
      if ($(this).val() == 3) {
        $("#selectServicesDiv").show();
        $("#selecCampaignDiv").show();
      } else {
        $("#selectServicesDiv").hide();
        $("#selecCampaignDiv").hide();
      }
    });

    // Eventos Nodo SMS ***********************************

    $("#divUsersListSms").hide();

    $("#smsOwmner").change(function (e) {
      e.preventDefault();
      smsOwmner = $("#smsOwmner").is(":checked") ? "1" : "0";
      if (smsOwmner === "0") {
        $("#divUsersListSms").hide();
      }
      if (smsOwmner === "1") {
        $("#divUsersListSms").show();
      }
    });

    $("#merge_field_sms").change(function () {
      // no funciona append en text area

      var select = document.getElementById("merge_field_sms");
      var selectedOption = this.options[select.selectedIndex];
      insertAtCursor($("#message")[0], selectedOption.value);
      //  $('#message').append(selectedOption.text);
    });

    // Eventos Nodo MMS ***********************************

    $("#divUsersListMms").hide();

    $("#mmsOwmner").change(function (e) {
      e.preventDefault();
      mmsOwmner = $("#mmsOwmner").is(":checked") ? "1" : "0";
      if (mmsOwmner === "0") {
        $("#divUsersListMms").hide();
      }
      if (mmsOwmner === "1") {
        $("#divUsersListMms").show();
      }
    });

    $("#merge_field_mms").change(function () {
      // no funciona append en text area

      var select = document.getElementById("merge_field_mms");
      var selectedOption = this.options[select.selectedIndex];
      insertAtCursor($("#message_mms")[0], selectedOption.value);
      //  $('#message').append(selectedOption.text);
    });

    $("#merge_field_whatsapp").change(function () {
      // no funciona append en text area

      var select = document.getElementById("merge_field_whatsapp");
      var selectedOption = this.options[select.selectedIndex];
      insertAtCursor($("#whatsapp_message")[0], selectedOption.value);
    });

    $("#selectServices").change(function () {
      // listo

      $("#selecCampaign").html("");

      var list = $("#selecCampaign");

      var id = this.value;
      preloader("show");
      $.post(
        "../model/automation_model.php",
        {
          method: "combo_flow_automation",
          id: id,
        },
        function (data) {
          preloader("hide");
          list.append(new Option("Select Campaign Leads", ""));
          $.each(data.salida, function (index, item) {
            list.append(new Option(item.name, item.id));
          });
        },
        "json"
      );
    });

    $("#selecCampaign").change(function () {
      // listo
      var datos = {
        method: "setGraphic",
        id_campaing: $(this).val(),
      };
      preloader("show");
      $.post(
        "../model/automation_model.php",
        datos,
        function (data) {
          preloader("hide");
          if (data.operator_gui !== null) {
            var dat = JSON.parse(data.operator_gui);
            flowchart.flowchart("setData", dat);
          } else {
            flowchart.flowchart("setData", "");
          }
        },
        "json"
      );
    });

    $("#btnSaveAutomation").click(function (e) {
      // listo
      e.preventDefault();
      swal({
        title: "You're going to save an Automation. Are you sure?",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, save it!",
      }).then(function (e) {
        if (e.dismiss === "cancel") {
          swal("Cancelled", "Automation was not saved!", "error");
        }
        if (e.value) {
          var datos = {
            method: "saveAutomation",
            automation_name: $("#automation_name").val(),
            automation_description: $("#automation_description").val(),
            automation_sms_box: $("#sms_box_config").val(),
            idAutomation: $("#idAutomation").val(),
          };
          //preloader('show');
          $.post(
            MODEL,
            datos,
            function (data) {
              if (data.update === "1") {
                swal("Automation Updated...!");
                $("#idAutomation").val(data.idAutomation);
              }
              if (data.update === "0") {
                swal("Automation Saved...!");
                $("#idAutomation").val(data.idAutomation);
              }
            },
            "json"
          );
        }
      });
    });

    $("#automation_name").focusout(function (e) {
      e.preventDefault();
      var datos = {
        method: "checkNameAutomation",
        automation_name: $("#automation_name").val(),
      };
      $.post(
        MODEL,
        datos,
        function (data) {
          if (data.res === "yes") {
            $("#automation_name").val("");
            swal("Automation All Ready Exits...!", "error");
          }
        },
        "json"
      );
    });

    $("#automation_button_remove_node").click(function () {
      //listo
      $("#modal_confirm").modal("hide");
      Automation.deleteNode();
    });

    $("#automation_button_edit_node").click(function () {
      //listo
      $("#modal_confirm").modal("hide");
      Automation.showNodeModal();
    });

    $("#automation_button_clone_node").click(function () {
      //listo
      swal({
        title: "Are you sure?",
        text: "Do you want to, clone this node?",
        type: "warning",
        showCancelButton: !0,
        confirmButtonText: "Yes, do it!",
      }).then(function (e) {
        if (e.dismiss) {
          swal({
            position: "top-center",
            type: "success",
            title: "Data is safe :)",
            showConfirmButton: !1,
            timer: 1500,
          });
        }
        if (e.value) {
          $("#modal_confirm").modal("hide");
          var operatorId = flowchart.flowchart("getSelectedOperatorId");
          var data = flowchart.flowchart("getData");
          var operatorData = data["operators"][operatorId];
          operatorData["top"] = parseInt(operatorData["top"]) + 20;
          operatorData["left"] = parseInt(operatorData["left"]) + 20;
          var datos = {
            method: "cloneNode",
            operatorId: operatorId,
          };
          $.post(
            MODEL,
            datos,
            function (response) {
              if (response.code == "200") {
                swal(response.message, "success");
                flowchart.flowchart(
                  "createOperator",
                  response.operatorId,
                  operatorData
                );
              }
            },
            "json"
          );
        }
      });
    });

    $("#btnEditNode").click(function (e) {
      e.preventDefault();
      var operatorId = flowchart.flowchart("getSelectedOperatorId");
      if (operatorId === null) {
        swal("Must Indicate Node To Edit");
      } else {
        Automation.showNodeModal();
      }
    });
    $("#width_increase").click(function () {
      flowchart.css("width", parseInt(flowchart.css("width")) + 100);
    });

    $("#btnDelNode").click(function (e) {
      e.preventDefault();
      var operatorId = flowchart.flowchart("getSelectedOperatorId");
      if (operatorId === null) {
        swal("Must Indicate Node To Be Deleted");
      } else {
        Automation.deleteNode();
      }
    });

    // Eventos Nodo Email ***********************************

    $("#divUsersListEmail").hide();

    $("#emailOwmner").change(function (e) {
      e.preventDefault();
      emailOwmner = $("#emailOwmner").is(":checked") ? "1" : "0";
      if (emailOwmner === "0") {
        $("#divUsersListEmail").hide();
      }
      if (emailOwmner === "1") {
        $("#divUsersListEmail").show();
      }
    });

    $("#campaign_input_cne_cc_email").focusout(function (e) {
      e.preventDefault();
      var regex = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;

      if (regex.test($("#campaign_input_cne_cc_email").val().trim())) {
        swal("The email valid...!");
      } else {
        $("#campaign_input_cne_cc_email").val("");
        swal("The email address is not valid...!");
      }
    });

    $("#campaign_input_cne_bcc_email").focusout(function (e) {
      e.preventDefault();
      var regex = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;

      if (regex.test($("#campaign_input_cne_bcc_email").val().trim())) {
        swal("The email valid...!");
      } else {
        $("#campaign_input_cne_bcc_email").val("");
        swal("The email address is not valid...!");
      }
    });

    $("#delLink").click(function (e) {
      var dataLink = flowchart.flowchart("getData");
      var LinkId = flowchart.flowchart("getSelectedLinkId");
      var operatorId = dataLink.links[LinkId].fromOperator;
      var fromConnector = dataLink.links[LinkId].fromConnector;
      var option = "";

      if (fromConnector == "output_1") {
        option = "yes";
      }
      if (fromConnector == "output_2") {
        option = "no";
      }
      if (fromConnector == "output_3") {
        option = "call_3";
      }
      if (fromConnector == "output_4") {
        option = "call_4";
      }

      var datos = {
        method: "deleteConnectorNode",
        operatorId: operatorId,
        option: option,
      };
      $.post(
        MODEL,
        datos,
        function (data) {
          //console.log(data.res);
          if (data.res === "yes") {
            flowchart.flowchart("deleteSelected");
            Automation.saveGraphic(); //guarda la grafica
          }
        },
        "json"
      );
     // console.log(operatorId, fromConnector);
    });

    $("#SaveGraphics").click(function (e) {
      e.preventDefault();
      Automation.saveGraphic();
    });

    // SELECTORES NODO CALL

    $("#optionsSection").hide();
    $("#divCallOwner").hide();
    $("#divUsersListCall").hide();

    $("#makeCall").change(function (e) {
      e.preventDefault();
      makeCall = $("#makeCall").is(":checked") ? "1" : "0";
      if (makeCall === "0") {
        $("#divCallOwner").hide();
        $("#callOwmner").prop("checked", false);
        $("#divHasOptions").show();
        $("#divUsersListCall").hide();
      }
      if (makeCall === "1") {
        if (!$("#hasOptions").is(":checked")) {
          $("#divCallOwner").show();
        }
      }
    });

    $("#callOwmner").change(function (e) {
      e.preventDefault();
      callOwmner = $("#callOwmner").is(":checked") ? "1" : "0";
      if (callOwmner === "0") {
        $("#divHasOptions").show();
        $("#divUsersListCall").hide();
      }
      if (callOwmner === "1") {
        $("#divHasOptions").hide();
        $("#hasOptions").prop("checked", false);
        $("#optionsSection").hide();
        $("#divUsersListCall").show();
      }
    });

    $("#hasOptions").change(function (e) {
      e.preventDefault();
      hasOptions = $("#hasOptions").is(":checked") ? "1" : "0";

      if (hasOptions === "0") {
        $("#optionsSection").hide();
        if ($("#makeCall").is(":checked")) {
          $("#divCallOwner").show();
          //$('#divUsersListCall').show();
        }
      }
      if (hasOptions === "1") {
        $("#optionsSection").show();
        $("#divCallOwner").hide();
        $("#divUsersListCall").hide();
        $("#divCallOwner").prop("checked", false);
        $("#selectorDeOperador").trigger("change");
      }
    });

    $("#digit1").hide();
    $("#digit2").hide();
    $("#digit3").hide();
    $("#digit4").hide();

    $("#selectorDeOperador").change(function (e) {
      e.preventDefault();
      selectorDeOperador = $("#selectorDeOperador").val();
      $("#digit1").hide();
      $("#digit2").hide();
      $("#digit3").hide();
      $("#digit4").hide();
      if (selectorDeOperador === "") {
        $("#tdigit1").rules("remove", "required");
        $("#tdigit1").rules("remove", "digits");
        $("#tdigit2").rules("remove", "required");
        $("#tdigit2").rules("remove", "digits");
        $("#tdigit3").rules("remove", "required");
        $("#tdigit3").rules("remove", "digits");
        $("#tdigit4").rules("remove", "required");
        $("#tdigit4").rules("remove", "digits");

        Automation.clear();
      }
      if (selectorDeOperador === "1") {
        $("#digit1").show();

        $("#tdigit1").rules("add", "required");
        $("#tdigit1").rules("add", "digits");
        $("#tdigit2").rules("remove", "required");
        $("#tdigit2").rules("remove", "digits");
        $("#tdigit3").rules("remove", "required");
        $("#tdigit3").rules("remove", "digits");
        $("#tdigit4").rules("remove", "required");
        $("#tdigit4").rules("remove", "digits");

        $("#tdigit2").val("0");
        $("#tdigit3").val("0");
        $("#tdigit4").val("0");
      }
      if (selectorDeOperador === "2") {
        $("#digit1").show();
        $("#digit2").show();

        $("#tdigit1").rules("add", "required");
        $("#tdigit1").rules("add", "digits");
        $("#tdigit2").rules("add", "required");
        $("#tdigit2").rules("add", "digits");
        $("#tdigit3").rules("remove", "required");
        $("#tdigit3").rules("remove", "digits");
        $("#tdigit4").rules("remove", "required");
        $("#tdigit4").rules("remove", "digits");

        $("#tdigit3").val("0");
        $("#tdigit4").val("0");
      }
      if (selectorDeOperador === "3") {
        $("#digit1").show();
        $("#digit2").show();
        $("#digit3").show();

        $("#tdigit1").rules("add", "required");
        $("#tdigit1").rules("add", "digits");
        $("#tdigit2").rules("add", "required");
        $("#tdigit2").rules("add", "digits");
        $("#tdigit3").rules("add", "required");
        $("#tdigit3").rules("add", "digits");
        $("#tdigit4").rules("remove", "required");
        $("#tdigit4").rules("remove", "digits");

        $("#tdigit4").val("0");
      }
      if (selectorDeOperador === "4") {
        $("#digit1").show();
        $("#digit2").show();
        $("#digit3").show();
        $("#digit4").show();

        $("#tdigit1").rules("add", "required");
        $("#tdigit1").rules("add", "digits");
        $("#tdigit2").rules("add", "required");
        $("#tdigit2").rules("add", "digits");
        $("#tdigit3").rules("add", "required");
        $("#tdigit3").rules("add", "digits");
        $("#tdigit4").rules("add", "required");
        $("#tdigit4").rules("add", "digits");
      }
    });
  },
  eventsNodeCall: () => {
    $("#addSetCall").click(function (e) {
      e.preventDefault();
      Automation.clear();
      Automation.clearFormCall();
      var id_automation = $("#idAutomation").val();
      $("#divHasOptions").show();
      $("#divCallOwner").hide();
      $("#divUsersListCall").hide();

      if (id_automation !== "0") {
        $("#modalNodeCall")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdCall").val(operatorId);
        $("#idNewNodeCall").val("0");
        $("#parent").val("0");
        $("#modalNodeCall").modal("show");
        $("#optionsSection").hide();
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeCall").click(function (e) {
      e.preventDefault();

      if (formNodeCall.valid()) {
        var operatorIdCall = $("#operatorIdCall").val();
        var titleNodeCall = $("#name").val();
        var selectorDeOperador = $("#selectorDeOperador").val();
        var hasOptions = $("#hasOptions").is(":checked") ? 1 : 0;
        var timeout = $("#timeout").val();
        var retries = $("#retries").val();
        var type = $("#type").val();
        var callToUser = $("#callOwmner").is(":checked") ? 1 : 0;
        var timeWait = $("#timeWait").val();

        if (hasOptions == 0) {
          $("#tdigit1").val(0);
          $("#tdigit2").val(0);
          $("#tdigit3").val(0);
          $("#tdigit4").val(0);
        }
        if (timeout == "") {
          timeout = "5";
        }
        if (retries == "") {
          retries = "1";
        }
        if (timeWait == "") {
          timeWait = "1";
        }
        if (type == 6) {
          // fijar valor de parameter si el nodo es para reproducir archivo de audio
          parameter = $("#audioFile").val();
        } else {
          parameter = $("#parameter").val();
        }
        if (callToUser == 1) {
          userToCallId = $("#userToCall").val().join();
        } else {
          userToCallId = 0;
        }
        var dataNode = {
          operatorIdCall: operatorIdCall,
          idAutomation: $("#idAutomation").val(),
          name: $("#name").val(),
          number_from: $("#phone").val(),
          language: $("#Language").val(),
          voice: $("#voice").val(),
          idNewNodeCall: $("#idNewNodeCall").val(),
          type: type,
          parameter: parameter,
          end_flag: $("#end_flag").is(":checked") ? 1 : 0,
          metodo: $("#metodo").val(),
          method: "SaveNodeCall",
          tdigit1: $("#tdigit1").val() ? $("#tdigit1").val() : 0,
          tdigit2: $("#tdigit2").val() ? $("#tdigit2").val() : 0,
          tdigit3: $("#tdigit3").val() ? $("#tdigit3").val() : 0,
          tdigit4: $("#tdigit4").val() ? $("#tdigit4").val() : 0,
          makeCall: $("#makeCall").is(":checked") ? 1 : 0,
          hasOptions: hasOptions,
          timeout: timeout,
          retries: retries,
          userToCallId: userToCallId,
          timeWait: timeWait,
          mask_phone: $("#mask_phone").val(),
        };
        preloader("show");
        $.post(
          MODEL,
          dataNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "1") {
                flowchart.flowchart("deleteSelected");
                var operatorData = "";
                if (selectorDeOperador === "1" || selectorDeOperador === "0") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "2") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "3") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                        output_3: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "4") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                        output_3: {
                          label: "Out",
                        },
                        output_4: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                flowchart.flowchart(
                  "createOperator",
                  operatorIdCall,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCall,
                  titleNodeCall
                );
                $("#modalNodeCall").modal("hide");
                preloader("hide", "Node Call Updated...!", "success");
              } else {
                var operatorData = "";
                if (selectorDeOperador === "1" || selectorDeOperador === "0") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "2") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "3") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                        output_3: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }
                if (selectorDeOperador === "4") {
                  operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeCall classTitleNodeCall",
                      inputs: {
                        input_1: {
                          label: "In",
                        },
                      },
                      outputs: {
                        output_1: {
                          label: "Out",
                        },
                        output_2: {
                          label: "Out",
                        },
                        output_3: {
                          label: "Out",
                        },
                        output_4: {
                          label: "Out",
                        },
                      },
                    },
                  };
                }

                flowchart.flowchart(
                  "createOperator",
                  operatorIdCall,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCall,
                  titleNodeCall
                );
                $("#idNewNodeCall").val(data.idNewNodeCall);
                $("#modalNodeCall").modal("hide");
                preloader("hide", "Node Call Created...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      } // valid
    });
  },
  clearFormCall: () => {
    $("#digit1").hide();
    $("#digit2").hide();
    $("#digit3").hide();
    $("#digit4").hide();

    $("#tdigit1").rules("remove", "required");
    $("#tdigit1").rules("remove", "digits");
    $("#tdigit2").rules("remove", "required");
    $("#tdigit2").rules("remove", "digits");
    $("#tdigit3").rules("remove", "required");
    $("#tdigit3").rules("remove", "digits");
    $("#tdigit4").rules("remove", "required");
    $("#tdigit4").rules("remove", "digits");

    $("#parameterDiv").show();
    $("#audioFileDiv").hide();
    $("#audioFile").removeAttr("required");
    $("#parameter").attr("required");
  },
  eventsNodeCheckTags: () => {
    $("#addCheckTags").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();

      if (id_automation !== "0") {
        $("#modalCampaignnodeCheckTags")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdCheckTags").val(operatorId);
        $("#idCampaignNodeCheckTags").val("0");

        $("#modalCampaignnodeCheckTags").modal("show");
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeCheckTags").click(function (e) {
      e.preventDefault();

      if (formNodeCheckTags.valid()) {
        var operatorIdCheckTags = $("#operatorIdCheckTags").val();
        var titleNodeCheckTags = $("#titleNodeCheckTags").val();
        var dataNode = {
          method: "SaveNodeCheckTags",
          cnct_tags: $("#campaign_input_cnct_tags").val(),
          operatorIdCheckTags: operatorIdCheckTags,
          idCampaignNodeCheckTags: $("#idCampaignNodeCheckTags").val(),
          idAutomation: $("#idAutomation").val(),
        };
        preloader("hide");
        $.post(
          MODEL,
          dataNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                $("#idCampaignNodeCheckTags").val(data.idCampaignNodeCheckTags);
                $("#modalCampaignnodeCheckTags").modal("hide");
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeCheckTag classTitleNodeCheckTag",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Yes",
                      },
                      output_2: {
                        label: "No",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdCheckTags,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCheckTags,
                  titleNodeCheckTags
                );
                preloader("hide", "Node Check Tags Created...!");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCheckTags,
                  titleNodeCheckTags
                );
                $("#modalCampaignnodeCheckTags").modal("hide");
                preloader("hide", "Node Check Tags Updated...!");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeCondition: () => {
    $("#modalCampaignNodeCondition").on("hidden.bs.modal", function (event) {
      $("#select_user_interacting").select2({
        placeholder: "Select user..",
        minimumResultsForSearch: 1 / 0,
      });
    });

    $("#div_user_interacting").hide();
    $("#div_with_value_language").hide();

    $("#campaign_select_cnc_merge_field").change(function () {
      // DJ. modificado para meter language

      var mergeFieldSet = $(this).children("option:selected").val();

      if (mergeFieldSet == "{{communication_language}}") {
        $("#div_compare_this").hide();
        $("#div_with_value").hide();
        $("#div_user_interacting").hide();
        $("#div_with_value_language").show();
      } else {
        if (mergeFieldSet == "{{owner}}") {
          $("#div_user_interacting").show();
          $("#div_with_value").hide();
        } else {
          $("#div_with_value").show();
          $("#div_user_interacting").hide();
        }

        $("#div_compare_this").show();
        $("#div_with_value_language").hide();
      }
    });

    $("#addCondition").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();

      if (id_automation !== "0") {
        $("#modalCampaignNodeCondition")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdCondition").val(operatorId);
        $("#idCampaignNodeCondition").val("0");

        $("#modalCampaignNodeCondition").modal("show");
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeCondition").click(function (e) {
      e.preventDefault();
      var with_value = "";

      var mergeFieldSet = $("#campaign_select_cnc_merge_field").val();
      var compare_this = $("#campaign_select_cnc_compare_this").val();

      if (mergeFieldSet == "{{id_user_crm}}") {
        with_value = $("#select_user_interacting").val();
        $("#campaign_input_cnc_with_value").val(with_value);
      } else if (mergeFieldSet == "{{communication_language}}") {
        with_value = $("#condition_language").val();
        $("#campaign_input_cnc_with_value").val(with_value);
        compare_this = "=";
      } else {
        with_value = $("#campaign_input_cnc_with_value").val();
        $("#campaign_input_cnc_with_value").val("");
      }

      if (formNodeCondition.valid()) {
        var operatorIdCondition = $("#operatorIdCondition").val();
        var titleNodeCondition = $("#titleNodeCondition").val();
        var datosNode = {
          method: "SaveNodeCondition",
          idAutomation: $("#idAutomation").val(),
          operatorIdCondition: operatorIdCondition,
          type_condition: $("#campaign_select_cnc_type_condition").val(),
          idCampaignNodeCondition: $("#idCampaignNodeCondition").val(),
          type_variable: $("#campaign_select_cnc_type_variable").val(),
          merge_field: mergeFieldSet,
          compare_this: compare_this,
          with_value: with_value,
        };

        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeCondition classTitleNodeCondition",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Yes",
                      },
                      output_2: {
                        label: "No",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdCondition,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCondition,
                  titleNodeCondition
                );
                $("#idCampaignNodeCondition").val(data.idCampaignNodeCondition);
                $("#modalCampaignNodeCondition").modal("hide");
                preloader("hide", "Node Condition Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdCondition,
                  titleNodeCondition
                );
                $("#modalCampaignNodeCondition").modal("hide");
                preloader("hide", "Node Condition Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeEmail: () => {
    $("#addSendMail").click(function (e) {
      e.preventDefault();
      Automation.clear();
      $("#files_preview").attr("src", "");
      var id_automation = $("#idAutomation").val();
      $("#divUsersListEmail").hide();

      if (id_automation !== "0") {
        $("#modalCampaignNodeEmail")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdEmail").val(operatorId);
        $("#idCampaignNodeEmail").val("0");

        $("#modalCampaignNodeEmail").modal({
          focus: false,
        });
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeEmail").click(function (e) {
      e.preventDefault();

      if (formNodeEmail.valid()) {
        var operatorIdEmail = $("#operatorIdEmail").val();
        var titleNodeEmail = $("#titleNodeEmail").val();
        var emailToUser = $("#emailOwmner").is(":checked") ? 1 : 0;
        var bulkEmailNameCheck = $("#select_email option:selected").attr(
          "name"
        );
        var bulkEmail = 0;

        if (emailToUser == 1) {
          userToEmailId = $("#userToEmail").val().join();
        } else {
          userToEmailId = 0;
        }

        if (bulkEmailNameCheck == "Bulk Email") {
          bulkEmail = 1;
        }

        //console.log("bulkEmail: ");
        //console.log(bulkEmail);

        var datosNode = {
          method: "SaveNodeEmail",
          idAutomation: $("#idAutomation").val(),
          operatorIdEmail: operatorIdEmail,
          idCampaignNodeEmail: $("#idCampaignNodeEmail").val(),
          cc_email: $("#campaign_input_cne_cc_email").val(),
          bcc_email: $("#campaign_input_cne_bcc_email").val(),
          id_email_server_setting: $("#select_email").val(),
          subbject: $("#campaign_input_cne_subbject").val(),
          text: $("#campaign_select_cne_text").val(),
          html: CKEDITOR.instances["campaign_input_cne_html"].getData(),
          userToEmailId: userToEmailId,
          email_attachment: $("#files").val(),
          bulkEmail: bulkEmail,
        };
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res == "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeEmail classTitleNodeEmail",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdEmail,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdEmail,
                  titleNodeEmail
                );
                $("#idCampaignNodeEmail").val(data.idCampaignNodeEmail);
                $("#modalCampaignNodeEmail").modal("hide");
                preloader("hide", "Node Email Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdEmail,
                  titleNodeEmail
                );
                $("#modalCampaignNodeEmail").modal("hide");
                preloader("hide", "Node Email Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeSms: () => {
    $("#addSendSms").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();
      $("#divUsersListSms").hide();

      if (id_automation !== "0") {
        $("#modalCampaignNodeSms")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdSms").val(operatorId);
        $("#idCampaignNodeEmail").val("0");

        $("#modalCampaignNodeSms").modal("show");
        Caracteres.reset();
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeSMS").click(function (e) {
      e.preventDefault();

      if (formNodeSms.valid()) {
        var operatorIdSms = $("#operatorIdSms").val();
        var titleNodeSms = $("#titleNodeSms").val();
        var smsToUser = $("#smsOwmner").is(":checked") ? 1 : 0;

        if (smsToUser == 1) {
          userToSmsId = $("#userToSms").val().join();
        } else {
          userToSmsId = 0;
        }

        var datosNode = {
          method: "SaveNodeSMS",
          idAutomation: $("#idAutomation").val(),
          operatorIdSms: operatorIdSms,
          idCampaignNodeSms: $("#idCampaignNodeSms").val(),
          phonesms: $("#phonesms").val(),
          message: $("#message").val(),
          cant_characters: $("#cant_characters").val(),
          cant_msj: $("#cant_msj").val(),
          userToSmsId: userToSmsId,
        };
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeSMS classTitleNodeSMS",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdSms,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdSms,
                  titleNodeSms
                );
                $("#idCampaignNodeEmail").val(data.id_automation_node_sms);
                $("#modalCampaignNodeSms").modal("hide");
                preloader("hide", "Node SMS Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdSms,
                  titleNodeSms
                );
                $("#modalCampaignNodeSms").modal("hide");
                preloader("hide", "Node SMS Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeMms: () => {
    $("#addSendMms").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();
      $("#divUsersListMms").hide();
      $("#mms_file_preview").attr("src", "");

      if (id_automation !== "0") {
        $("#modalCampaignNodeMms")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdMms").val(operatorId);
        $("#idCampaignNodeMms").val("0");

        $("#modalCampaignNodeMms").modal("show");
        Caracteres.reset();
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeMMS").click(function (e) {
      e.preventDefault();
      //console.log($('#mmsFile').val());
      if (formNodeMms.valid()) {
        var operatorIdMms = $("#operatorIdMms").val();
        var titleNodeMms = $("#titleNodeMms").val();
        var mmsToUser = $("#mmsOwmner").is(":checked") ? 1 : 0;

        if (mmsToUser == 1) {
          userToMmsId = $("#userToMms").val().join();
        } else {
          userToMmsId = 0;
        }

        var datosNode = {
          method: "SaveNodeMMS",
          idAutomation: $("#idAutomation").val(),
          operatorIdMms: operatorIdMms,
          idCampaignNodeMms: $("#idCampaignNodeMms").val(),
          phonemms: $("#phonemms").val(),
          message: $("#message_mms").val(),
          cant_characters: $("#cant_characters_mms").val(),
          cant_msj: $("#cant_msj_mms").val(),
          userToMmsId: userToMmsId,
          mms_file_url: $("#mmsFile").val(),
        };
        //console.log(datosNode);
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeMMS classTitleNodeMMS",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdMms,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdMms,
                  titleNodeMms
                );
                $("#idCampaignNodeMms").val(data.id_automation_node_sms);
                $("#modalCampaignNodeMms").modal("hide");
                preloader("hide", "Node MMS Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdMms,
                  titleNodeMms
                );
                $("#modalCampaignNodeMms").modal("hide");
                preloader("hide", "Node MMS Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeTags: () => {
    $("#addTags").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();

      if (id_automation !== "0") {
        $("#modalCampaignNodeTags")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdTags").val(operatorId);
        $("#idCampaignNodeTags").val("0");

        $("#modalCampaignNodeTags").modal("show");
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeTags").click(function (e) {
      e.preventDefault();

      if (formNodeTags.valid()) {
        var operatorIdTags = $("#operatorIdTags").val();
        var titleNodeTags = $("#titleNodeTags").val();
        var datosNode = {
          method: "SaveNodeTags",
          idAutomation: $("#idAutomation").val(),
          operatorIdTags: operatorIdTags,
          idCampaignNodeTags: $("#idCampaignNodeTags").val(),
          tag_type: $("#tag_type").val(),
          cnct_tags: $("#cnct_tags").val(),
        };
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeTags classTitleNodeTags",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdTags,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdTags,
                  titleNodeTags
                );
                $("#idCampaignNodeTags").val(data.id_automation_node_tags);
                $("#modalCampaignNodeTags").modal("hide");
                preloader("hide", "Node Tag Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdTags,
                  titleNodeTags
                );
                $("#modalCampaignNodeTags").modal("hide");
                preloader("hide", "Node Tag Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeWait: () => {
    $("#addWait").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();

      if (id_automation !== "0") {
        $("#modalCampaignNodeWait")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdWait").val(operatorId);
        $("#idCampaignNodeWait").val("0");

        $("#modalCampaignNodeWait").modal("show");
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeWait").click(function (e) {
      e.preventDefault();

      if (formNodeWait.valid()) {
        var operatorIdWait = $("#operatorIdWait").val();
        var titleNodeWait = $("#titleNodeWait").val();
        var datosNode = {
          method: "SaveNodeWait",
          idAutomation: $("#idAutomation").val(),
          operatorIdWait: operatorIdWait,
          idCampaignNodeWait: $("#idCampaignNodeWait").val(),
          value_duration: $("#value_duration").val(),
          type_duration: $("#type_duration").val(),
          cnw_id_time: $("#cnw_id_time").val(),
          time_zone: $("#time_zone").val(),
        };
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "Wait",
                    class: "classNodeWait classTitleNodeWait",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdWait,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdWait,
                  titleNodeWait
                );
                $("#idCampaignNodeWait").val(data.id_automation_node_wait);
                $("#modalCampaignNodeWait").modal("hide");
                preloader("hide", "Node Wait Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdWait,
                  titleNodeWait
                );
                $("#modalCampaignNodeWait").modal("hide");
                preloader("hide", "Node Wait Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeProperty: () => {
    $("#addSetProperty").click(function (e) {
      e.preventDefault();
      Automation.clear();
      var id_automation = $("#idAutomation").val();

      if (id_automation !== "0") {
        $("#modalCampaignNodeProperty")
          .children()
          .find("input,textarea")
          .each(function () {
            $(this).val("");
          });
        var operatorId = randString(NUMRAMDOM);
        $("#operatorIdProperty").val(operatorId);
        $("#idCampaignNodeProperty").val("0");

        $("#modalCampaignNodeProperty").modal("show");
      } else {
        swal("Please Create an Automation first!");
      }
    });

    $("#btnSaveNodeProperty").click(function (e) {
      e.preventDefault();

      if (formNodeProperty.valid()) {
        var operatorIdProperty = $("#operatorIdProperty").val();
        var titleNodeProperty = $("#titleNodeProperty").val();
        var datosNode = {
          method: "SaveNodeProperty",
          idAutomation: $("#idAutomation").val(),
          operatorIdProperty: operatorIdProperty,
          idCampaignNodeProperty: $("#idCampaignNodeProperty").val(),
          merge_field: $("#merge_field").val(),
          type_set: $("#type_set").val(),
          cnsp_value: $("#cnsp_value").val(),
        };
        preloader("show");
        $.post(
          MODEL,
          datosNode,
          function (data) {
            if (data.res === "yes") {
              if (data.update === "0") {
                var operatorData = {
                  top: 60,
                  left: 500,
                  properties: {
                    title: "",
                    class: "classNodeProperty classTitleNodeProperty",
                    inputs: {
                      input_1: {
                        label: "In",
                      },
                      input_2: {
                        label: "In",
                      },
                    },
                    outputs: {
                      output_1: {
                        label: "Next",
                      },
                    },
                  },
                };

                flowchart.flowchart(
                  "createOperator",
                  operatorIdProperty,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdProperty,
                  titleNodeProperty
                );
                $("#idCampaignNodeProperty").val(
                  data.id_automation_node_property
                );
                $("#modalCampaignNodeProperty").modal("hide");
                preloader("hide", "Node Property Created...!", "success");
              } else {
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdProperty,
                  titleNodeProperty
                );
                $("#modalCampaignNodeProperty").modal("hide");
                preloader("hide", "Node Property Updated...!", "success");
              }
            }
          },
          "json"
        ).done(function () {
          Automation.saveGraphic();
        });
      }
    });
  },
  eventsNodeWhatsapp: () => {
    form_media_w.validate({
      rules: {
          input_name: {
              required: !0
          },
          select_type_media: {
              required: !0
          }
      },
      invalidHandler: function(e, r) {
          $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
      },
      submitHandler: function(e) {}
    });
    ////
    $("#addSendWhatsapp").click(function (e) {
      e.preventDefault();
      Automation.clear();
      file_Images_media();
      file_doc_madia();
      viewElemenet();
      $("#idNodeWhatsapp").val(0);
      $("#preview").hide();
      $("#preview").prop("src", "");
      $("#file_preview").hide();
      $("#file_preview").prop("src", "")
      let operatorId = randString(NUMRAMDOM);
      $("#operatorIdWhatsapp").val(operatorId);       
      $("#modalNodeWhatsApp").modal("show");
      loadEmojins();
    });
    ////
    $("#node_type").change(function (e) { 
      e.preventDefault();
      let node_type = $("#node_type").val();
      viewElemenet(node_type);
    });
    ////
    $("#btnSaveNodeWhatsapp").click(function (e) {
      e.preventDefault();     
      /////
      if (formNodeWhatsapp.valid()) {
        if (ValidateTypeNodeWhatsApp()) {
          let titleNodeWhatsapp = $("#titleNodeWhatsapp").val();
          let node_final = $("#node_final").val();
          let operatorIdWhatsapp = $("#operatorIdWhatsapp").val();
          ///////////////////////////////////////////////////////
          let datosNode = {
            method:"SaveNodeWhatsapp",
            idAutomation: $("#idAutomation").val(),
            idNodeWhatsapp:$("#idNodeWhatsapp").val(),
            operatorIdWhatsapp:$("#operatorIdWhatsapp").val(),
            node_final:$("#node_final").val(),
            node_type:$("#node_type").val(),
            retries_nw:0,
            phonewhatsapp_client:"",
            merge_field_whatsapp:$("#merge_field_whatsapp").val(),
            startup_language:$("#startup_language").val(),
            whatsapp_message:$("#whatsapp_message").val(),
            title_document:$("#title_document").val(),
            file_Images_media:$("#file_Images_media").val(),
            file_doc_madia:$("#file_doc_madia").val()
          }
          //console.log(datosNode);
          preloader("show");
          $.post(MODEL, datosNode,
            function (data, textStatus, jqXHR) {
              if (data.res === "yes") {
                if (data.update === "0") {

                  if (node_final == "yes") { // el node es final
                    var operatorData = {
                      top: 60,
                      left: 500,
                      properties: {
                        title: "",
                        class: "classNodeWhatsapp classTitleNodeWhatsapp",
                        inputs: {
                          input_1: {
                            label: "In",
                          }
                        },
                        outputs: {},
                      },
                    };
      
                  }

                  if (node_final == "no") {// el node no es final (continua)
                    var operatorData = {
                      top: 60,
                      left: 500,
                      properties: {
                        title: "",
                        class: "classNodeWhatsapp classTitleNodeWhatsapp",
                        inputs: {
                          input_1: {
                            label: "In",
                          }
                        },
                        outputs: {
                          output_1: {
                            label: "Next",
                          },
                        },
                      },
                    };
                  }                 

                  flowchart.flowchart(
                    "createOperator",
                    operatorIdWhatsapp,
                    operatorData
                  );
                  flowchart.flowchart(
                    "setOperatorTitle",
                    operatorIdWhatsapp,
                    titleNodeWhatsapp
                  );
                  $("#idNodeWhatsapp").val(
                    data.id_automation_node_whatsapp
                  );
                  $("#modalNodeWhatsApp").modal("hide");
                  preloader("hide", "Node WhatsApp Created...!", "success");               
                } else {
                  /////////////////////////////////////////////////////
                  flowchart.flowchart("deleteSelected");
                  /////////////////////////////////////////////////////
                  if (node_final == "yes") { // el node es final
                    var operatorData = {
                      top: 60,
                      left: 500,
                      properties: {
                        title: "",
                        class: "classNodeWhatsapp classTitleNodeWhatsapp",
                        inputs: {
                          input_1: {
                            label: "In",
                          }
                        },
                        outputs: {},
                      },
                    };
      
                  }

                  if (node_final == "no") {// el node no es final (continua)
                    var operatorData = {
                      top: 60,
                      left: 500,
                      properties: {
                        title: "",
                        class: "classNodeWhatsapp classTitleNodeWhatsapp",
                        inputs: {
                          input_1: {
                            label: "In",
                          }
                        },
                        outputs: {
                          output_1: {
                            label: "Next",
                          },
                        },
                      },
                    };
                  }                 

                  flowchart.flowchart(
                    "createOperator",
                    operatorIdWhatsapp,
                    operatorData
                  );
                  flowchart.flowchart(
                    "setOperatorTitle",
                    operatorIdWhatsapp,
                    titleNodeWhatsapp
                  );
                  
                  $("#modalNodeWhatsApp").modal("hide");
                  preloader("hide", "Node WhatsApp Updated...!", "success");
                }
                Automation.saveGraphic();
              }
            },
            "json"
          );
        }
        /*let titleNodeWhatsapp = $("#titleNodeWhatsapp").val();
        let node_final = $("#node_final").val();
        let operatorIdWhatsapp = $("#operatorIdWhatsapp").val();
        ///////////////////////////////////////////////////////
        let datosNode = {
          method:"SaveNodeWhatsapp",
          idAutomation: $("#idAutomation").val(),
          idNodeWhatsapp:$("#idNodeWhatsapp").val(),
          operatorIdWhatsapp:$("#operatorIdWhatsapp").val(),
          node_final:$("#node_final").val(),
          node_type:$("#node_type").val(),
          retries_nw:$("#retries_nw").val(),
          phonewhatsapp_client:$("#phonewhatsapp_client").val(),
          merge_field_whatsapp:$("#merge_field_whatsapp").val(),
          startup_language:$("#startup_language").val(),
          whatsapp_message:$("#whatsapp_message").val(),
          title_document:$("#title_document").val(),
          file_Images_media:$("#file_Images_media").val(),
          file_doc_madia:$("#file_doc_madia").val()
        }
        preloader("show");
        $.post(MODEL, datosNode,
          function (data, textStatus, jqXHR) {
            if (data.res === "yes") {
              if (data.update === "0") {

                if (node_final == "yes") { // el node es final
                  var operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeWhatsapp classTitleNodeWhatsapp",
                      inputs: {
                        input_1: {
                          label: "In",
                        }
                      },
                      outputs: {},
                    },
                  };
    
                }

                if (node_final == "no") {// el node no es final (continua)
                  var operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeWhatsapp classTitleNodeWhatsapp",
                      inputs: {
                        input_1: {
                          label: "In",
                        }
                      },
                      outputs: {
                        output_1: {
                          label: "Next",
                        },
                      },
                    },
                  };
                }                 

                flowchart.flowchart(
                  "createOperator",
                  operatorIdWhatsapp,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdWhatsapp,
                  titleNodeWhatsapp
                );
                $("#idNodeWhatsapp").val(
                  data.id_automation_node_whatsapp
                );
                $("#modalNodeWhatsApp").modal("hide");
                preloader("hide", "Node WhatsApp Created...!", "success");               
              } else {
                /////////////////////////////////////////////////////
                flowchart.flowchart("deleteSelected");
                /////////////////////////////////////////////////////
                if (node_final == "yes") { // el node es final
                  var operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeWhatsapp classTitleNodeWhatsapp",
                      inputs: {
                        input_1: {
                          label: "In",
                        }
                      },
                      outputs: {},
                    },
                  };
    
                }

                if (node_final == "no") {// el node no es final (continua)
                  var operatorData = {
                    top: 60,
                    left: 500,
                    properties: {
                      title: "",
                      class: "classNodeWhatsapp classTitleNodeWhatsapp",
                      inputs: {
                        input_1: {
                          label: "In",
                        }
                      },
                      outputs: {
                        output_1: {
                          label: "Next",
                        },
                      },
                    },
                  };
                }                 

                flowchart.flowchart(
                  "createOperator",
                  operatorIdWhatsapp,
                  operatorData
                );
                flowchart.flowchart(
                  "setOperatorTitle",
                  operatorIdWhatsapp,
                  titleNodeWhatsapp
                );
                 
                $("#modalNodeWhatsApp").modal("hide");
                preloader("hide", "Node WhatsApp Updated...!", "success");
              }
              Automation.saveGraphic();
            }
          },
          "json"
        );*/
      }      
      
    });
    ////
    $("#preview").hide();
    $("#file_Images_media").change(function (e) { 
      e.preventDefault();
      let file_Images_media = $("#file_Images_media").val();
      if (file_Images_media == "") {
        $("#preview").hide();
        $("#title_document").val("");
        $("#preview").prop("src", "")
      }
      if (file_Images_media != "") {
        let name = $(this).find(':selected').data('name');   
        $("#title_document").val("");
        $("#title_document").val(name);
        $("#preview").show();
        $("#preview").prop("src", file_Images_media)
      }
    });
    ////
    $("#file_preview").hide();
    $("#file_doc_madia").change(function (e) { 
      e.preventDefault();
      let file_doc_madia = $("#file_doc_madia").val();
      if (file_doc_madia == "") {
        $("#file_preview").hide();
        $("#title_document").val("");
        $("#file_preview").prop("src", "")
      }
      if (file_doc_madia != "") {
        let name = $(this).find(':selected').data('name');        
        $("#title_document").val("");
        $("#title_document").val(name);
        $("#file_preview").show();
        $("#file_preview").prop("src", file_doc_madia)
      }
    });
    ////
    $('#new_media_whatsapp').click(function() {
      clearModal();
      $('#a_url_file').prop("hidden", true);       
      $('.div_alert_audio').hide(400);
      $('.div_alert_mms').hide(400);
      $('.div_alert_image').hide(400);
      $('#modal_media_whatsapp').modal('show');
    });
    ////
    $('#select_type_media_w').change(function() {
      //console.log($(this).val());

      $(".btn-file").removeClass("btn-disabled");
      $(".btn-file").addClass("btn-brand");   
      $('#upload_document').prop({ "disabled": false});   

      if ($(this).val() == 'AUDIO') {
          $('.div_alert_audio').show(400);
          $('.div_alert_mms').hide(400);
          $('.div_alert_image').hide(400);
          /*$('#upload_document').prop({
              "disabled": false,
              "accept": "audio/mpeg"
          });*/

      } else if ($(this).val() == 'IMAGE') {
          $('.div_alert_audio').hide(400);
          $('.div_alert_mms').hide(400);
          $('.div_alert_image').show(400);
          /*$('#upload_document').prop({
              "disabled": false,
              "accept": "image/*"               
          });*/

      } else if ($(this).val() == 'MMS') {
          $('.div_alert_audio').hide(400);
          $('.div_alert_mms').show(400);
          $('.div_alert_image').hide(400);
          /*$('#upload_document').prop({
              "disabled": false,
              "accept": "application/*,image/*,audio/*,video/*,text/*"             
          });*/

      } else {
          ////"accept": ".3gp,.3g2,.bmp,.gif,.jpg,.png,.amr,.mp4,.mpeg,.wav,.pdf,.vcf,.vcard,.ics,.ifb,.iCal,.iFBf,.icalendar"
          $('.div_alert_audio').hide(400);
          $('.div_alert_mms').hide(400);
          $('.div_alert_image').hide(400);
          $('#upload_document').prop({ "disabled": true});   
          $('#upload_document').val(""); 	  
      }

    });
    ////
    $('#button_add_media_w').click(function() {
      if (form_media_w.valid()) {
         
        var file = document.getElementById("upload_document").files[0];     
        console.log(file);
        var type_media = $("#select_type_media_w").val();
        var typeRelated = '';
        var size_flag = 0;
        var max_size = 0;

        if (type_media == 'IMAGE') {
            typeRelated = 5;
            if (file.size > 2097152) { // 2 MB
              size_flag = 1;
              max_size = '2 MB';
            }
            if (size_flag != 0 ) {
              swal('File too large!', "Must be less than " + max_size, "warning");
            }
            if (size_flag == 0) {
              function fileValidationImage(){
                var fileInput = document.getElementById("upload_document");  
                var filePath = fileInput.value;
                var allowedExtensions = /(.jpg|.jpeg|.png|.JPG|.JPEG|.PNG)$/i;
                if(!allowedExtensions.exec(filePath)){
                  swal('Please upload file having extensions .jpeg/.jpg/.png/ only.');                  
                }else{
                  firebaseUploadFileW(typeRelated);
                }
              }
              fileValidationImage();
            }
        } 
        ///////////////////////////
        if (type_media == 'MMS') {
          typeRelated = 6;       
          if (file.size > 691200) { // 675 kB
            size_flag = 1;
            max_size = '675 kB';
          }   
          if (size_flag != 0 ) {
            swal('File too large!', "Must be less than " + max_size, "warning");
          }    
          if (size_flag == 0) {
            function fileValidationFile(){
              var fileInput = document.getElementById("upload_document");  
              var filePath = fileInput.value;
              var allowedExtensions = /(.pdf|.PDF|.doc|.DOC|.docx|.DOCX)$/i;
              if(!allowedExtensions.exec(filePath)){
                  swal('Please upload file having extensions .pdf/.doc/.xlxs/ only.');                  
              }else{
                firebaseUploadFileW(typeRelated);
              }
            }
            fileValidationFile();
          }
        }            
      } /// validate   
    });
    ////
    $("#record_w").click(function (e) { 
      e.preventDefault();
      
    });
    ////
    $("#stop_w").click(function (e) { 
      e.preventDefault();
      
    });
    ////
    $("#select_emojin").change(function (e) { 
      e.preventDefault();
      let select_emojin = $("#select_emojin").val();
      let whatsapp_message = $("#whatsapp_message").val();
      if (select_emojin != "") {
        whatsapp_message = whatsapp_message + " "+ select_emojin;
        $("#whatsapp_message").val(whatsapp_message);
      }      
    });
    ////
    
    
  },
  deleteNode: () => {
    var operatorId = flowchart.flowchart("getSelectedOperatorId");
    preloader("show");
    $.post(
      "../model/automation_model.php",
      {
        method: "deleteNode",
        operatorId: operatorId,
      },
      function (data) {
        if (data.res === "yes") {
          flowchart.flowchart("deleteSelected");
          preloader("hide", "Node Deleted...!", "success");
        }
      },
      "json"
    ).done(function () {
      Automation.saveGraphic();
    });
  },
  showNodeModal: () => {
    Automation.clear();
    var title = "";
    var operatorId = flowchart.flowchart("getSelectedOperatorId");

    preloader("show");
    
    $.post(
      "../model/automation_model.php",
      {
        method: "showNodeModal",
        operatorId: operatorId,
      },
      function (data) {
        if (data[0].type_node !== "10") {
          preloader("hide");          
        }
        

        if (data[0].type_node === "1") {
          // check tags
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeCheckTags").val(title);

          $("#operatorIdCheckTags").val(data[0].operatorId);
          $("#idCampaignNodeCheckTags").val(data[0].id_node_check_tags);
          $("#campaign_input_cnct_tags").val(data[0].tags);

          $("#modalCampaignnodeCheckTags").modal("show");
        }

        if (data[0].type_node === "2") {
          // condition

          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeCondition").val(title);

          $("#operatorIdCondition").val(data[0].operatorId);
          $("#idCampaignNodeCondition").val(data[0].id_node_check_condition);

          $("#campaign_select_cnc_type_condition").val(data[0].type_condition);
          $("#campaign_select_cnc_type_variable").val(data[0].type_variable);

          if (data[0].merge_field == "{{id_user_crm}}") {
            $("#div_user_interacting").show();
            $("#div_compare_this").show();
            $("#div_with_value").hide();
            $("#div_with_value_language").hide();
            $("#select_user_interacting").val(data[0].with_value);
          } else if (data[0].merge_field == "{{communication_language}}") {
            //} else if (jQuery.inArray(data[0].merge_field, langArray) !== -1) {
            $("#div_user_interacting").hide();
            $("#div_compare_this").hide();
            $("#div_with_value").hide();
            $("#div_with_value_language").show();
            $("#condition_language").val(data[0].with_value);
          } else {
            $("#div_with_value").show();
            $("#div_compare_this").show();
            $("#div_user_interacting").hide();
            $("#div_with_value_language").hide();
            $("#campaign_input_cnc_with_value").val(data[0].with_value);
          }

          $("#campaign_select_cnc_merge_field").val(data[0].merge_field);
          $("#campaign_select_cnc_compare_this").val(data[0].compare_this);

          $("#modalCampaignNodeCondition").modal("show");
        }

        if (data[0].type_node === "3") {
          // email

         // console.log("select_email: " + data[0].select_email);
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeEmail").val(title);
          $("#operatorIdEmail").val(data[0].operatorId);
          $("#idCampaignNodeEmail").val(data[0].id_node_emails);
          $("#campaign_input_cne_cc_email").val(data[0].cc_email);
          $("#campaign_input_cne_bcc_email").val(data[0].bcc_email);
          CKEDITOR.instances["campaign_input_cne_html"].setData(data[0].html);
          $("#campaign_select_cne_text").val(data[0].text);
          $("#campaign_input_cne_subbject").val(data[0].subbject);
          $("#select_email").val(data[0].select_email);
          $("#files").val(data[0].email_attachment);
          $("#files_preview").attr("src", data[0].email_attachment);

          if (data[0].emailToUserId == 0 || data[0].emailToUserId == "") {
            $("#emailOwmner").prop("checked", false);
            $("#divUsersListEmail").hide();
          } else {
            $("#emailOwmner").prop("checked", true);
            $("#userToEmail").val(data[0].emailToUserId.split(","));
            $("#divUsersListEmail").show();
          }

          $("#modalCampaignNodeEmail").modal("show");
        }

        if (data[0].type_node === "4") {
          // SMS
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeSms").val(title);

          $("#operatorIdSms").val(data[0].operatorId);
          $("#idCampaignNodeSms").val(data[0].id_node_sms);

          $("#phonesms").val(data[0].number_phone);
          $("#message").val(data[0].message);
          $("#cant_characters").val(data[0].characters);
          $("#cant_msj").val(data[0].cant_msj);

          if (data[0].smsToUserId != "0") {
            $("#smsOwmner").prop("checked", true);
            $("#userToSms").val(data[0].smsToUserId.split(","));
            $("#divUsersListSms").show();
          } else {
            $("#smsOwmner").prop("checked", false);
            $("#divUsersListSms").hide();
          }

          $("#modalCampaignNodeSms").modal("show");
          setTimeout(() => {
            Caracteres.reset();
          }, 2000);
        }

        if (data[0].type_node === "5") {
          // tags
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeTags").val(title);

          $("#operatorIdTags").val(data[0].operatorId);
          $("#idCampaignNodeTags").val(data[0].id_node_tags);

          $("#type_tag").val(data[0].type_tag);
          $("#cnct_tags").val(data[0].tags);

          $("#modalCampaignNodeTags").modal("show");
        }

        if (data[0].type_node === "6") {
          // wait

          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeWait").val(title);

          $("#operatorIdWait").val(data[0].operatorId);
          $("#idCampaignNodeWait").val(data[0].id_node_wait);

          $("#value_duration").val(data[0].value_duration);
          $("#type_duration").val(data[0].type_duration);
          $("#cnw_id_time").val(data[0].id_time);
          $("#time_zone").val(data[0].id_time_zone);

          $("#modalCampaignNodeWait").modal("show");
        }

        if (data[0].type_node === "7") {
          // property

          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeProperty").val(title);

          $("#operatorIdProperty").val(data[0].operatorId);
          $("#idCampaignNodeProperty").val(data[0].id_node_property);

          $("#merge_field").val(data[0].merge_fieltype_set);
          $("#type_set").val(data[0].type_set);
          $("#cnsp_value").val(data[0].dato);

          $("#modalCampaignNodeProperty").modal("show");
        }

        if (data[0].type_node === "8") {
          // call
          Automation.clearFormCall();
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeCall").val(title);

          $("#operatorIdCall").val(data[0].operatorId);
          $("#idNewNodeCall").val(data[0].id_node_call);
          $("#name").val(data[0].name);

          $("#number_from").val(data[0].number_from);
          $("#language").val(data[0].language);
          $("#voice").val(data[0].voice);
          $("#type").val(data[0].type);
          $("#metodo").val(data[0].metodo);

          if (data[0].type == 6) {
            $("#parameterDiv").hide();
            $("#audioFileDiv").show();
            $("#audioFile").attr("required");
            $("#parameter").removeAttr("required");
            $("#audioFile").val(data[0].parameter);
          } else {
            $("#parameterDiv").show();
            $("#audioFileDiv").hide();
            $("#audioFile").removeAttr("required");
            $("#parameter").attr("required");
            $("#parameter").html(data[0].parameter);
          }

          if (data[0].end_flag === "1") {
            $("#end_flag").prop("checked", true);
          } else {
            $("#end_flag").prop("checked", false);
          }
          $("#model_method").val(data[0].model_method);
          var cnt = 0;
          if (data[0].digit1 !== "0") {
            $("#digit1").show();
            $("#tdigit1").val(data[0].digit1);
            cnt++;
          }

          if (data[0].digit2 !== "0") {
            $("#digit2").show();
            $("#tdigit2").val(data[0].digit2);
            cnt++;
          }

          if (data[0].digit3 !== "0") {
            $("#digit3").show();
            $("#tdigit3").val(data[0].digit3);
            cnt++;
          }

          if (data[0].digit4 !== "0") {
            $("#digit4").show();
            $("#tdigit4").val(data[0].digit4);
            cnt++;
          }

          if (cnt !== "0") {
            $("#selectorDeOperador").val(cnt);
          } else {
            $("#selectorDeOperador").val("");
          }

          if (data[0].makeCall === "1") {
            $("#makeCall").prop("checked", true);
          } else {
            $("#makeCall").prop("checked", false);
          }

          if (data[0].hasOptions === "1") {
            $("#hasOptions").prop("checked", true);
          } else {
            $("#hasOptions").prop("checked", false);
          }

          if (data[0].callToUserId != "0") {
            $("#callOwmner").prop("checked", true);
            $("#divUsersListCall").show();
            $("#userToCall").val(data[0].callToUserId.split(","));
            $("#divHasOptions").hide();
          } else {
            $("#callOwmner").prop("checked", false);
            $("#divCallOwner").hide();
            $("#divUsersListCall").hide();
          }
          $("#hasOptions").trigger("change");
          $("#callOwmner").trigger("change");
          $("#modalNodeCall").modal("show");
          $("#timeout").val(data[0].timeout);
          $("#retries").val(data[0].retries);
          $("#timeWait").val(data[0].timewait);
          $("#mask_phone").val(data[0].mask_phone);
        }

        if (data[0].type_node === "10") {
          // Whatsapp
          viewElemenet(data[0].type);

          file_Images_media();
          file_doc_madia();

          setTimeout(() => {
            
            preloader("hide");

            $("#preview").hide();
            $("#file_preview").hide();
            $("#preview").prop("src", "");
            $("#file_preview").prop("src", "")
            ////////////////////////////////////////////////////////////
            title = flowchart.flowchart("getOperatorTitle", operatorId);
            $("#titleNodeWhatsapp").val(title);
            $("#operatorIdWhatsapp").val(data[0].operatorId);
            $("#idNodeWhatsapp").val(data[0].id_node_whatsapp);
            ////////////////////////////////////////////////////////////
            $("#node_final").val(data[0].node_final);
            $("#node_type").val(data[0].type);
            $("#retries_nw").val(data[0].retries);
            $("#phonewhatsapp_client").val(data[0].number_phone);
            $("#startup_language").val(data[0].language);
            $("#whatsapp_message").val(data[0].message);
            $("#title_document").val(data[0].title_document);
            $("#file_Images_media").val(data[0].image_link);
            $("#file_doc_madia").val(data[0].document_link);

            if (data[0].image_link != "") {
              $("#preview").prop("src", data[0].image_link);
              $("#preview").show();            
            }
            if (data[0].document_link != "") {
              $("#file_preview").prop("src", data[0].document_link);
              $("#file_preview").show();
            }                   
            
            $("#modalNodeWhatsApp").modal("show");

            }, 3000);
          
        }

        if (data[0].type_node === "11") {
          // MMS
          title = flowchart.flowchart("getOperatorTitle", operatorId);
          $("#titleNodeMms").val(title);

          $("#operatorIdMms").val(data[0].operatorId);
          $("#idCampaignNodeMms").val(data[0].id_node_mms);

          $("#phonemms").val(data[0].number_phone);
          $("#message_mms").val(data[0].message);
          $("#cant_characters_mms").val(data[0].characters);
          $("#cant_msj_mms").val(data[0].cant_msj);
          $("#mmsFile").val(data[0].mms_file_url);
          $("#mms_file_preview").attr("src", data[0].mms_file_url);

          if (data[0].mmsToUserId != "0") {
            $("#mmsOwmner").prop("checked", true);
            $("#userToMms").val(data[0].mmsToUserId.split(","));
            $("#divUsersListMms").show();
          } else {
            $("#mmsOwmner").prop("checked", false);
            $("#divUsersListMms").hide();
          }

          $("#modalCampaignNodeMms").modal("show");
          setTimeout(() => {
            Caracteres.reset();
          }, 2000);
        }


      },
      "json"
    );
  },
  saveGraphic: () => {
    // para guardar la grafica
    var flowchart_width = flowchart.css("width");
    var id_automation = $("#idAutomation").val();
    var data = flowchart.flowchart("getData");
    var flowGraph = JSON.stringify(data, null, 2);
    var d = {
      id_automation: id_automation,
      flowchart_width: flowchart_width,
      flowGraph: flowGraph,
      method: "saveGraphic",
    };
    $.post(
      MODEL,
      d,
      function (data) {
        flowchart.css("width", "" + data.flowchart_width + "");
      },
      "json"
    );
  },
  upload_email_attachment: function (operatorIdEmail) {
    if ($("#files")[0].files.length > 0) {
      //console.log(operatorIdEmail);
      var automationUpload = operatorIdEmail;
      var id = $("#id_contact").val();

      var data = new FormData();
      var count = 0;
      $.each($("#files")[0].files, function (i, file) {
        data.append("files-" + i, file);
        count = i;
      });
      data.append("automationUpload", automationUpload);
      data.append("id", id);
      data.append("count", count);

      $.ajax({
        url: "../upload.php",
        data: data,
        cache: false,
        contentType: false,
        processData: false,
        method: "POST",
        type: "POST", // For jQuery < 1.9
        dataType: "json",
        success: function (response) {
          //console.log(response);
          if (response.code == "440") {
            return;
          } else if (response.code === "200") {
            contact_view.findHistoryByIdContact();
            preloader("hide", response.message, "success");
          }
        },
      });
    }
  },
  clear: () => {
    formNodeCall.validate().resetForm();
    formNodeCondition.validate().resetForm();
    formNodeCheckTags.validate().resetForm();
    formNodeEmail.validate().resetForm();
    formNodeSms.validate().resetForm();
    formNodeWhatsapp.validate().resetForm();
    formNodeTags.validate().resetForm();
    formNodeWait.validate().resetForm();
    formNodeProperty.validate().resetForm();
    formNodeMms.validate().resetForm();
    formTestMaskPhone.validate().resetForm();
  },
};

function insertAtCursor(input, textToInsert) {
  // get current text of the input
  const value = input.value;

  // save selection start and end position
  const start = input.selectionStart;
  const end = input.selectionEnd;

  // update the value with our text inserted
  input.value = value.slice(0, start) + textToInsert + value.slice(end);

  // update cursor to be at the end of insertion
  input.selectionStart = input.selectionEnd = start + textToInsert.length;
}

function get_idcampaign(idcampaign) {
  var datos = {
    method: "setGraphic",
    id_campaing: idcampaign,
  };
  preloader("show");
  $.post(
    "../model/automation_model.php",
    datos,
    function (data) {
      preloader("hide");
      if (data.operator_gui !== null) {
        var dat = JSON.parse(data.operator_gui);
        flowchart.flowchart("setData", dat);
        flowchart.css("width", "" + data.flowchart_width + "");
      } else {
        flowchart.flowchart("setData", "");
      }
    },
    "json"
  );
}

function get_automation(idAutomation) {
  var datos = {
    method: "fillAutomation",
    idAutomation: idAutomation,
  };
  preloader("show");
  $.post(
    MODEL,
    datos,
    function (data) {
      preloader("hide");
      $("#automation_name").val(data.name);
      $("#automation_description").val(data.description);
      $("#sms_box_config").val(data.sms_box_config);
      $("#idAutomation").val(data.idAutomation);
      flowchart.css("width", "" + data.flowchart_width + "");
      if (data.operator_gui !== null) {
        var dat = JSON.parse(data.operator_gui);
        // var dat = data.operator_gui;
        flowchart.flowchart("setData", dat);
      } else {
        flowchart.flowchart("setData", "");
      }
    },
    "json"
  );
}

function getOperatorData($element) {
  var nbInputs = parseInt($element.data("nb-inputs"));
  var nbOutputs = parseInt($element.data("nb-outputs"));
  var data = {
    properties: {
      title: $element.text(),
      inputs: {},
      outputs: {},
    },
  };

  var i = 0;
  for (i = 0; i < nbInputs; i++) {
    data.properties.inputs["input_" + i] = {
      label: "Input " + (i + 1),
    };
  }
  for (i = 0; i < nbOutputs; i++) {
    data.properties.outputs["output_" + i] = {
      label: "Output " + (i + 1),
    };
  }

  return data;
}

var Caracteres = {
  inicio: function () {
    $("#message").keyup(function () {
      Caracteres.updateContadorTa();
    });
    $("#message").change(function () {
      Caracteres.updateContadorTa();
    });
    $("#message").focusout(function () {
      Caracteres.updateContadorTa();
    });

    $("#message_mms").keyup(function () {
      Caracteres.updateContadorTaMms();
    });
    $("#message_mms").change(function () {
      Caracteres.updateContadorTaMms();
    });
    $("#message_mms").focusout(function () {
      Caracteres.updateContadorTaMms();
    });
  },
  updateContadorTa: function () {
    $("#conteo").html(0);
    $("#cmsj").val(0);
    $("#cant_msj").val(0);

    var max = 152;

    var contador = $("#contadorTaComentario");
    var ta = $("#message");

    var cont = ta.val().length;
    var total = cont / max;

    var cmsj = 0;
    if (Number.isInteger(total)) {
      cmsj = parseInt(total);
      contador.html(cont + "/" + cmsj);
      $("#cmsj").val(parseInt(total));
    } else {
      cmsj = parseInt(total) + 1;
      contador.html(cont + "/" + cmsj);
      $("#cmsj").val(parseInt(total) + 1);
    }
    $("#cant_msj").val(cmsj);
    $("#cant_characters").val(ta.val().length);
  },
  updateContadorTaMms: function () {
    $("#conteo").html(0);
    $("#cmsj").val(0);
    $("#cant_msj_mms").val(0);

    var max = 152;

    var contador = $("#contadorTaComentarioMms");
    var ta = $("#message_mms");

    var cont = ta.val().length;
    var total = cont / max;

    // contador.html("0/" + total);
    var cmsj = 0;
    if (Number.isInteger(total)) {
      cmsj = parseInt(total);
      contador.html(cont + "/" + cmsj);
      // $("#conteo").html(parseInt(total));
      $("#cmsj").val(parseInt(total));
    } else {
      cmsj = parseInt(total) + 1;
      contador.html(cont + "/" + cmsj);
      // $("#conteo").html(parseInt(total) + 1);
      $("#cmsj").val(parseInt(total) + 1);
    }
    //contador.html(cont + "/" + max);
    $("#cant_msj_mms").val(cmsj);
    $("#cant_characters_mms").val(ta.val().length);
  },
  reset: function () {
    Caracteres.updateContadorTa();
  },
};

//// whatsapp

function ValidateTypeNodeWhatsApp() {
  let node_type = $("#node_type").val();
  let whatsapp_message = $("#whatsapp_message").val();
  let title_document = $("#title_document").val();
  let file_doc_madia = $("#file_doc_madia").val();
  let file_Images_media = $("#file_Images_media").val();
  if (node_type == "1") { // text
    if (whatsapp_message == "") {
      swal("You must indicate a text to send...!");
      return false;
    }
  }
  if (node_type == "2") {// url
    if (whatsapp_message == "") {
      swal("You must indicate a text to send...!");
      return false;
    }
  }
  if (node_type == "3") {// image
    if (file_Images_media == "") {
      swal("you must select an image to send...!");
      return false;
    }
  }
  if (node_type == "4") {// document
    if (file_doc_madia == "") {
      swal("You must select a document to send...!");
      return false;
    }
    if (title_document == "") {
      swal("You must indicate the title for the document to be sent...!");
      return false;
    }
  }
  if (node_type == "5") {// text - image
    if (whatsapp_message == "") {
      swal("You must indicate a text to send...!");
      return false;
    }
    if (file_Images_media == "") {
      swal("you must select an image to send...!");
      return false;
    }
  }
  if (node_type == "6") {
    if (whatsapp_message == "") {
      swal("You must indicate a text to send...!");
      return false;
    }
    if (title_document == "") {
      swal("You must indicate the title for the document to be sent...!");
      return false;
    }
  }
  
  return true;
}
////
function file_Images_media(id = 0) {
  $.post(MODEL, {method:'file_Images_media'},
    function (response, textStatus, jqXHR) {
      //console.log(response);
      let list = "<option value='' selected>Select...</option>";
      if (response.code == "200") {
        response.list.forEach(element => {              
          list += `<option data-name="${element.name}" value="${element.url_file}" >${element.name}</option>`
        });
      }  
      $('#file_Images_media').html(list);       
    },
    "json"
  );
}
////
function file_doc_madia(id = 0) {
  $.post(MODEL, {method:'file_doc_madia'},
    function (response, textStatus, jqXHR) {
      //console.log(response);
      let list = "<option value='' selected>Select...</option>";
      if (response.code == "200") {
        response.list.forEach(element => {              
          list += `<option data-name="${element.name}" value="${element.url_file}" >${element.name}</option>`
        });
      }  
      $('#file_doc_madia').html(list);       
    },
    "json"
  );
}    
/////
function clearModal() {
  $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
  $("#input_name").val('');
  $('#upload_document').prop("disabled", true);
  $('#select_type_media').val('');
  $(".btn-file").removeClass("btn-brand");
  $(".btn-file").addClass("btn-disabled");
  $('#id_media').val('');
  form_media_w.validate().resetForm();
}
///////
function firebaseUploadFileW(typeRelated){ 
 
  var file = document.getElementById("upload_document").files[0];     
  var id_client = $('#input_id_client').val();

  
  var mainDir = '';  
  if(typeRelated == 5) {
      mainDir = 'multimedia/';
      var idRelated = id_client;
  } else if(typeRelated == 6) {
      mainDir = 'mms/';
      var idRelated = id_client;
  } else { //No typeRelated
      mainDir = 'others/';
      var idRelated = 0;
  }

  if (file.length != 0) {          

      firebaseInit();
      var randomStr = randString(8); // Para añadir srting aleatorio es caso de nombres de archivos repetidos
      var file_path = mainDir + idRelated + '/' + randomStr + '/' + file.name;
      //var file_path = mainDir + idRelated + '/' + file.name          
      var storageRef = firebase.storage().ref();
      var uploadTask = storageRef.child(file_path).put(file);
      uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED,
        function(snapshot) {
          var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
          console.log('Upload is ' + progress + '% done');
          switch (snapshot.state) {
            case firebase.storage.TaskState.PAUSED: // or 'paused'
              console.log('Upload is paused');
              break;
            case firebase.storage.TaskState.RUNNING: // or 'running'
              console.log('Upload is running');
              break;
          }
        }, function(error) {
          alert("Error Uploading!\r\nError Code: " + error.code);
      }, function() {
          uploadTask.snapshot.ref.getDownloadURL()
          uploadTask.snapshot.ref.getDownloadURL()
          .then(function(downloadURL) {
              console.log('downloadURL: ', downloadURL);               
              let name_file = $("#input_name").val();
              var parametros = {
                  "method": "saveFilesUrl",
                  "type": $("#select_type_media_w").val(),
                  "id_related": idRelated,                       
                  "file_name": name_file,
                  "file_path": file_path,
                  "file_url": downloadURL
              };
              preloader("show");
              $.ajax({
                  data: parametros,
                  url: MODEL,
                  method: 'post',
                  dataType: 'json',
                  success: function (data) {
                      if (data.code == '440'){
                          loginTimeout(data.message);
                          return;
                      }
                      if (data.code == '200') {
                        preloader("hide", `File Loaded! : ${name_file}` , "success");
                        //swal('File Loaded!', data.filename + " is in your cloud bucket", "success");                             
                        file_Images_media();
                        file_doc_madia();                            
                        $('#modal_media_whatsapp').modal('hide');
                          
                      }                          
                  },
                  error: function(){
                      swal('File Loaded with error!', "Please try again. AJAX Error", "error");
                  }
              });
          
          });

      });
  } else {
      swal('No File to Upload!', "Please try again", "error");
  }
};
//////
function loadEmojins() {
  $.post("../wswapp/emoji-en-US.json", {},
    function (response, textStatus, jqXHR) {
      console.log(response);
      let select_emojin = '<option value="">Select Emojin</option>';
      for (let clave in response){
        //console.log(clave);           
        select_emojin += `<option class="more" value="${clave}">${clave}</option>`;
      }
      $("#select_emojin").html(select_emojin);
    },
    "json"
  );
}

function viewElemenet(params = "") {  
   // console.log(`params: ${params}`);
    $("#div_message").hide();
    $("#div_title_document").hide();
    $("#div_media").hide();
    $("#div_image").hide();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  ///////////////////
  if (params == "") {
    $("#div_message").show();
    $("#div_title_document").hide();
    $("#div_media").hide();
    $("#div_image").hide();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "1") {
    $("#div_message").show();
    $("#div_title_document").hide();
    $("#div_media").hide();
    $("#div_image").hide();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "2") {
    $("#div_message").show();
    $("#div_title_document").hide();
    $("#div_media").hide();
    $("#div_image").hide();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "3") {
    $("#div_message").hide();
    $("#div_title_document").hide();
    $("#div_media").show();
    $("#div_image").show();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "4") {
    $("#div_message").hide();
    $("#div_title_document").hide();
    $("#div_media").show();
    $("#div_image").hide();
    $("#div_document").show();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "5") {
    $("#div_message").show();
    $("#div_title_document").hide();
    $("#div_media").show();
    $("#div_image").show();
    $("#div_document").hide();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
  if (params == "6") {
    $("#div_message").show();
    $("#div_title_document").hide();
    $("#div_media").show();
    $("#div_image").hide();
    $("#div_document").show();
    $("#preview").prop("src", "");
    $("#file_preview").prop("src", "");
    $("#file_Images_media").val("");
    $("#file_doc_madia").val("");
    $("#preview").hide();
    $("#file_preview").hide();
  }
}

//// whatsapp

$(function () {
  media.list(modules);
  media.events();
  Automation.init();
  Automation.events();
  Automation.eventsNodeCall();
  Automation.eventsNodeCheckTags();
  Automation.eventsNodeCondition();
  Automation.eventsNodeEmail();
  Automation.eventsNodeSms();
  Automation.eventsNodeMms();
  Automation.eventsNodeTags();
  Automation.eventsNodeWait();
  Automation.eventsNodeWhatsapp();
  Automation.eventsNodeProperty();
  Caracteres.inicio();
});
