"use strict";
var $formAddValidate = $('#frmAddAutomatedAssignment'),
    dataTable = '',
    selectUnlimited = $('#select_unlimited'),
    selectTypeRelated = $('#select_type_related');
$(function() {
    // dynamic grid
    automated_assignment.init();
    automated_assignment.list();
    automated_assignment.events();
});
var automated_assignment = {
    init: function() {
        $('.Limited').hide();
        $('.unlimited').hide();
        $('.agent').hide();
        $('.agency').hide();
        $('.broker').hide();
        $('.group').hide();
        $('.another').hide();

        $("#init_date").datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true,
                showButtonPanel: true,
                maxDate: '' 
        });

        $("#end_date").datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true,
                showButtonPanel: true,
                maxDate: '' 
        });

        $("#input_date_unlimited").datepicker({
            rtl: mUtil.isRTL(),
            todayHighlight: !0,
            orientation: "bottom left",
            dateFormat: 'yy-mm-dd',

        });

        $("#modal_add_automated_assignment").on("shown.bs.modal", function() {
            $("#select_agency").select2({
                placeholder: "Select Agency",
                dropdownParent: $("#modal_add_automated_assignment")
            });

            $("#select_broker").select2({
                placeholder: "Select Broker",
                dropdownParent: $("#modal_add_automated_assignment")
            });

            $("#select_group").select2({
                placeholder: "Select Group",
                dropdownParent: $("#modal_add_automated_assignment")
            });

            $("#select_agent").select2({
                placeholder: "Select Agent",
                dropdownParent: $("#modal_add_automated_assignment")
            });

            $("#select_id_campaign_leads_ads").select2({
                placeholder: "Select Campaign",
                dropdownParent: $("#modal_add_automated_assignment")
            });

            $("#select_id_campaign_leads_ads").select2({
                placeholder: "Select Campaign",
                dropdownParent: $("#modal_add_automated_assignment")
            });
        });

        $formAddValidate.validate({
            rules: {
                select_id_user_crm: {
                    required: !0
                },
                select_id_campaign_leads_ads: {
                    required: !0
                },
                select_unlimited: {
                    required: !0
                },
                add_agencycode: {
                    required: !0
                }
            },
            invalidHandler: function(e, r) {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            },
            submitHandler: function(e) {}
        });
    },
    list: function() {
        dataTable = $('#dtAutomatedAssignmentList').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/automated_assignment_model.php", // json datasource
                data: {
                    method: "automatedAssignmentList"
                },
                type: "post",
                error: function() {}
            },
            "order": [
                [0, "asc"]
            ],
            drawCallback: function(response) {
                if (response.json.code == '440'){
                    loginTimeout(response.json.message);
                    return;
                }
            }
        });
    },
    showModal: function(id) {
        $.post(
            "../model/automated_assignment_model.php", 
            {
                "method": 'findAutomatedAssignmentById',
                "id": id
            }, 
            function(response) {
                if (response.code == '440'){
                    loginTimeout(response.message);
                    return;
                }
                var checked = $("#input_status").is(':checked');
                preloader('hide');
                if (response.code == '200') {
                    var data = response.data;
                    $('#input_id').val(id);
                    selectTypeRelated.val(data.type_related);
                    selectTypeRelated.trigger('change');
                    
                    console.log('data.type_related = '+data.type_related);
                    switch(data.type_related) {
                        case '1':
                            $('#select_agent').val(data.id_related);
                            break;
                        case '2':
                            $('#select_group').val(data.id_related);
                            break;
                        case '3':
                            $('#select_agency').val(data.id_related);
                            break;
                        case '4':
                            $('#select_broker').val(data.id_related);
                            break;
                        case '5':
                            console.log('type_related = 5');
                            $('#input_code').val(data.code);
                            $('#input_id_client').val(data.id_client);
                            $('#input_id_campaign_leads_ads_destination').val(data.id_campaign_leads_ads_destination);
                            $('#input_client').val(data.name_client);
                            $('#input_campaign').val(data.name_campaign);
                            break;
                    }

                    $('#select_id_user_crm').val(data.id_user_crm);
                    $('#select_id_campaign_leads_ads').val(data.id_campaign_leads_ads);
                    selectUnlimited.val(data.unlimited);
                    selectUnlimited.trigger('change');
                    $('#input_total_leads').val(data.total_leads);
                    $('#input_leads_per_day').val(data.leads_per_day);
                    $('#input_date_unlimited').val(data.date_unlimited);
                    if ((data.status == 1 && checked == false) || (data.status == 2 && checked == true)) {
                        $('#input_status').click();
                    }
                    $("#modal_add_automated_assignment").modal('show');
                } else {
                    console.log(response.message);
                }
                preloader('hide');
            }, "json").fail(function(error) {
                console.log(error.responseJSON)
            });
    },
    delete: function(id) {
        swal({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!"
        }).then(function(e) {
            if (e.dismiss === "cancel") {
                swal("Cancelled", "Data is safe :)", "error");
            }
            if (e.value) {
                var parametros = {
                    "method": "automatedAssignmentDelete",
                    "id": id
                };
                $.post('../model/automated_assignment_model.php', parametros, function(response) {
                    console.log(response.code);
                    if (response.code == '440'){
                        loginTimeout(response.message);
                        return;
                    }
                    if (response.code == '200') {
                        swal("Deleted!", "Your record has been deleted.", "success");
                        dataTable.draw();
                    }
                }, "json");
            }
        });
    },
    events: function() {
        $('#button_add_automated_assignment').click(function() {
            if ($formAddValidate.valid()) {
                var status = 1,
                    idRelated = '';
                if ($('#input_status').is(':checked')) {
                    status = 1;
                } else {
                    status = 2;
                }
                if (selectUnlimited.val() == '0'){
                    $('#input_date_unlimited').val('');
                }else{
                    $('#input_total_leads').val('');
                    $('#input_leads_per_day').val('');
                }
                switch(selectTypeRelated.val()) {
                    case '1':
                        idRelated = $('#select_agent').val();
                        $('#input_id_campaign_leads_ads_destination').val('')
                        break;
                    case '2':
                        idRelated = $('#select_group').val();
                        $('#input_id_campaign_leads_ads_destination').val('')
                        break;
                    case '3':
                        idRelated = $('#select_agency').val();
                        $('#input_id_campaign_leads_ads_destination').val('')
                        break;
                    case '4':
                        idRelated = $('#select_broker').val();
                        $('#input_id_campaign_leads_ads_destination').val('')
                        break;
                    case '5':
                        idRelated = $('#input_id_client').val();
                        break;
                }
                preloader('show');
                var parametros = {
                    'method': 'automatedAssignmentUpdate',
                    'id': $("#input_id").val() == ''? 0 : $('#input_id').val(),
                    'id_related': idRelated,
                    'type_related': selectTypeRelated.val(),
                    'id_campaign_leads_ads': $('#select_id_campaign_leads_ads').val(),
                    'id_campaign_leads_ads_destination': $('#input_id_campaign_leads_ads_destination').val() == ''? 0 : $('#input_id_campaign_leads_ads_destination').val(),
                    'unlimited': selectUnlimited.val(),
                    'total_leads': $('#input_total_leads').val() == ''? 0 : $('#input_total_leads').val(),
                    'leads_per_day': $('#input_leads_per_day').val() == ''? 0 : $('#input_leads_per_day').val(),
                    'date_unlimited': $('#input_date_unlimited').val(),
                    'status': status
                };
                $.post("../model/automated_assignment_model.php", 
                        parametros, 
                    function(data) {
                        if (data.code == '440'){
                            loginTimeout(data.message);
                            return;
                        }
                        if (data.code == '200') {
                            $("#modal_add_automated_assignment").modal('hide');
                            preloader('hide', data.salida, 'success');
                            dataTable.draw(false)
                        } else {
                            preloader('hide', data.salida, 'error');
                        }
                    }, "json").fail(function(error) {
                        console.log(error.responseJSON)
                        preloader('hide');
                    });
            } else {
                $("#msg_alert_1").removeClass("m--hide").show(), mUtil.scrollTop()
            }
        });
        $('#button_search_campaign_code').click(function() {
            preloader('show');
            $.post(
                "../model/automated_assignment_model.php", 
                {
                    "method": 'findCampaignLeadsAdsByCode',
                    "code": $('#input_code').val()
                }, 
                function(response) {
                    if (response.code == '200') {
                        var data = response.data;
                        $('#input_id_client').val(data.id_client);
                        $('#input_id_campaign_leads_ads_destination').val(data.id);
                        $('#input_client').val(data.name_client);
                        $('#input_campaign').val(data.name_campaign);
                        preloader('hide',response.message, 'success');
                    } else {
                        $('#input_id_client').val('');
                        $('#input_id_campaign_leads_ads_destination').val('');
                        $('#input_client').val('');
                        $('#input_campaign').val('');
                        preloader('hide',response.message, 'error');
                    }
                }, "json").fail(function(error) {
                    console.log(error.responseJSON)
                });
        });

        $('#button_crete_report').click(function() {
            // preloader('show');
            var autoLead = $('#select_type_report').val();
            var initDate = $('#init_date').val();            
            var endDate = $('#end_date').val();

            console.log('at:'+autoLead+"IDate:"+initDate+"eDate:"+endDate);

            if (autoLead=="" || initDate=="" || endDate=="") {
                preloader('hide',"Complete Fields", 'error');
            }
            else{   
                window.open("../../ireport/reports.php?autoLead="+autoLead+"&initDate="+initDate+"&endDate="+endDate);    
            }
        });        

        selectTypeRelated.change(function() {
            $('.agent').hide();
            $('.agency').hide();
            $('.broker').hide();
            $('.group').hide();
            $('.another').hide();
            switch(selectTypeRelated.val()) {
                case '1':
                    $('.agent').show();
                    break;
                case '2':
                    $('.group').show();
                    break;
                case '3':
                    $('.agency').show();
                    break;
                case '4':
                    $('.broker').show();
                    break;
                case '5':
                    $('.another').show();
                    break;
            }
        });
        selectUnlimited.change(function() {
            $('.Limited').hide();
            $('.unlimited').hide();
            if(selectUnlimited.val() == '0'){
                $('.Limited').show();
            }else if(selectUnlimited.val() == '1'){
                $('.unlimited').show();
            }
        });
    },
    clear: function() {
        console.log('clear');
        $("#msg_alert_1").addClass("m--hide").show(), mUtil.scrollTop();
        $("#input_id").val('');
        $('#select_type_related').val('');
        $('#select_agency').val('');
        $('#select_broker').val('');
        $('#select_group').val('');
        $('#select_agent').val('');
        $('#select_id_campaign_leads_ads').val('');
        selectUnlimited.val('');
        $('#input_total_leads').val('');
        $('#input_leads_per_day').val('');
        $('#input_date_unlimited').val('');
        $('.Limited').hide();
        $('.unlimited').hide();
        $('.agent').hide();
        $('.agency').hide();
        $('.broker').hide();
        $('.group').hide();
        $('.another').hide();
        $formAddValidate.validate().resetForm();
        $('#select_type_report').val('');
        $('#init_date').val('');
        $('#end_date').val('');
    }

};