var dataTable = "";
var dataTableNotification = "";

$.fn.select2.defaults.set("width", "100%");
$.fn.modal.Constructor.prototype.enforceFocus = function () {};

let Applications = {
  event: () => {

    $("#search_date_from").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#search_date_to").datepicker({
      rtl: mUtil.isRTL(),
      todayHighlight: !0,
      orientation: "bottom left",
      dateFormat: "mm/dd/yy",
    });

    $("#search_date_from").change(function (e) {
      e.preventDefault();
      $("#search_date_to").val("");
    });

    $("#search_date_to").change(function (e) {
      e.preventDefault();
      let payments_date_from = $("#search_date_from").val();
      if (payments_date_from == "") {
        swal("Error", "must indicate date from!", "error");
        return;
      }

      var buscar = $("#search_date_from").val() + ";" + $("#search_date_to").val();
      dataTable.columns([6]).search(buscar).draw();
    });

    $("#btn_clear_date_range").click(function () {
      $("#payments_date_from").val("");
      $("#payments_date_to").val("");
      dataTable.columns([6]).search("").draw();
    });
    
  },
  table: () => {
    dataTable = $("#dtApplicationList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      ajax: {
        url: "../model/application_updated_cancelled.php", // json dataholder
        data: {
          action: "list",
          lang: localStorage.getItem("settingLang"),
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0],
          visible: true,
        },
        {
          targets: [7],
          orderable: false,
        },
      ],
      order: [[0, "desc"]],
      drawCallback: function (response) {
        console.log(response)
        if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        }
      },
    });
  },
  dataTableNotification: function (id_contacts_services) {
    event.preventDefault();
    preloader("show");

    if ($.fn.DataTable.isDataTable("#dtNotificationList")) {
      $("#dtNotificationList").DataTable().destroy();
    }

    $("#dtNotificationList tbody").empty();

    dataTableNotification = $("#dtNotificationList").DataTable({
      processing: true,
      serverSide: true,
      responsive: !0,
      ajax: {
        url: "../model/application_updated_cancelled.php", // json dataholder
        data: {
          action: "listNotifications",
          lang: localStorage.getItem("settingLang"),
          id_contacts_services: id_contacts_services,
        },
        type: "post",
        error: function () {},
      },
      columnDefs: [
        {
          targets: [0],
          visible: true,
        },
        {
          targets: [4],
          orderable: false,
        },
      ],
      order: [[0, "asc"]],
      drawCallback: function (response) {
        if (response.json.code == 200) {
          
        } else if (response.json.code == "440") {
          loginTimeout(response.json.message);
          return;
        } else {
          preloader("hide", "Error", "error");
        }
      },
    });

    preloader("hide");
    $("#modalNotificationList").modal("show");
  },
  sendNotification: function (id) {
    event.preventDefault();
    var lang = localStorage.getItem("settingLang");
    swal({
      title: lang == "es" ? "¿Estas seguro?" : "Are you sure?",
      text:
      lang == "es"
          ? "¡Usted desea enviar la notificación!"
          : "You want to send the notification!",
      type: "info",
      showCancelButton: !0,
      confirmButtonText: lang == "es" ? "Si, hazlo" : "Yes, do it!",
      cancelButtonText: lang == "es" ? "No, cancelar" : "No, cancel!",
      reverseButtons: !0,
    }).then(function (e) {
      if (e.value) {
        var parametros = {
          action: "sendNotification",
          id: id
        };
        preloader("show");
        $.post("../model/application_updated_cancelled.php",parametros,
          function (response) {
            if (response.code == 440) {
              loginTimeout(response.message);
              return;
            }
            if (response.code == 200) {
              console.log("SISA")
              dataTableNotification.draw();
              Swal.fire({
                title: response.message,
                showDenyButton: false,
                showCancelButton: false,
                confirmButtonText: "Ok",
                allowOutsideClick: true,
              });              
            }
          },
          "json"
        );
      }
    });
  }
};

$(function () {
  Applications.event();
  Applications.table();
});