var dataTable = $('#table_services');

$(function() {
    contacts_export_services.init();
});

contacts_export_services = {
    init: function() {
        var dt_buttons = dataTable.prev('.div_services_buttons');

        dataTable = $('#table_services').DataTable({
            "paging":   false,
            "ordering": false,
            "info":     false,
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/ctContacts.php", // json datasource
                data: {
                    method: "dtApplicationListAgents",
                    lang: localStorage.getItem('settingLang')
                },
                type: "post", // method  , by default get
                error: function() { // error handling
                }
            },
            "order": [
                [1, "asc"]
            ],
            buttons: [{
                extend: 'copyHtml5',
                footer: true,
                text: '<i class="la la-files-o"></i> Copy',
                titleAttr: 'Copy'
            }, {
                extend: 'print',
                footer: true,
                text: '<i class="la la-print"></i> Print',
                titleAttr: 'Print'
            }, {
                extend: 'excelHtml5',
                footer: true,
                text: '<i class="la la-file-excel-o"></i> XLSX',
                titleAttr: ''
            }, {
                extend: 'csvHtml5',
                footer: true,
                text: '<i class="la la-file-text-o"></i> CSV',
                titleAttr: 'CSV'
            }, {
                extend: 'pdfHtml5',
                footer: true,
                text: '<i class="la la-file-pdf-o"></i> PDF',
                titleAttr: 'PDF',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                }
            }],
            initComplete: function() {
                dataTable.buttons().container().appendTo(dt_buttons);
            },
            drawCallback: function(response) {
                if (response.json.code == '440') {
                    loginTimeout(response.json.message);
                    return;
                }
                dataTable.columns([0]).visible(false, false);
            }
        });
    }
}