"use strict";
var lang = localStorage.getItem("settingLang");
var stripe, elements, paymentElement, clientSecret;
var URLdomain = window.location.host.split(".");
var message_loading = "";

$(function () {
  application_firm.events();
});

var application_firm = {
  getPaymentInfo: function (id) {
    preloader("show");
    var data = {
      method: "getPaymentInfo",
      id_contacts_services: id,
    };
    $.post("../model/application_firm_model.php", data,
      function (data) {
        if (data.code == 200) {
          preloader("hide");
          sessionStorage.setItem("payment_date", data.payment_date);
          sessionStorage.setItem("data_type_payment", data.data_type_payment);

          var type_method_payment = 
          data.data_type_payment == "0" ? "Stripe" : 
          data.data_type_payment == "1" ? "Zelle" :
          "Other";

          $("#full_name_data").val(data.name+' '+data.last_name);
          $("#name_plan_data").val(data.name_plan);
          $("#date_payment_data").val(data.payment_date);
          $("#method_payment_data").val(type_method_payment);
          $("#type_payment_data").val(data.pay_type);

          $("#url_firm").attr("src", data.url_firm);


          $("#modalProcessPayment").modal("show");
        }
        else {
          Swal.fire({
            title: "Error",
            showDenyButton: false,
            showCancelButton: false,
            confirmButtonText: "Ok",
            allowOutsideClick: false,
          });
        }
      },
      "json"
    );
  },
  events: function(){

    $("#btn_save_process_payment").click(function () {
      Swal.fire({
        title: lang == "es" ? "¿Quiere procesar la solicitud?" : "Do you want to process the application?",
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: lang == "es" ? "Si, continuar" : "Yes, continue",
        denyButtonText: lang == "es" ? "Cancelar" : "Cancel",
        allowOutsideClick: false,
      }).then((result) => {        
        if (result.value) {
          preloader("show");

          var payment_date = sessionStorage.getItem("payment_date");
          payment_date = moment(payment_date).format("YYYY/MM/DD");
          var today = new Date();
          var today_format = moment(today).format("YYYY/MM/DD");

          //0 stripe, 1 zelle, 2 other
          var data_type_payment = parseInt(sessionStorage.getItem("data_type_payment"));
          if (data_type_payment == 1 || data_type_payment == 2) {
            let first_payment = payment_date <= today_format ? 1 : 0;
            var data = {
              method: "savePaymentOthers",
              payment_date: payment_date,
              lang: lang,
              first_payment: first_payment,
            };
            $.post("../model/application_firm_model.php", data,
              function (data) {
                if (data.code == 200) {
                  Swal.fire({
                    title: data.message,
                    showDenyButton: false,
                    showCancelButton: false,
                    confirmButtonText: "Ok",
                    allowOutsideClick: false,
                  }).then((result) => {
                    if (result.value) {
                      $("#modalProcessPayment").modal("hide");
                      dataTable.draw();
                    }
                  });
                }
                else {
                  //
                  Swal.fire({
                    title: "Ups!!!",
                    text: "error...",
                    showDenyButton: false,
                    showCancelButton: false,
                    confirmButtonText: "Ok",
                    allowOutsideClick: false,
                  });
                }
              },
              "json"
            );
          }
          else if (data_type_payment == 0) {
            if (payment_date > today_format) {
              //no paga aun
              var data = {
                method: "savePP",
                payment_date: payment_date,
                lang: lang,
              };
              $.post("../model/application_firm_model.php", data,
                function (data) {
                  if (data.code == 200) {
                    Swal.fire({
                      title: data.message,
                      showDenyButton: false,
                      showCancelButton: false,
                      confirmButtonText: "Ok",
                      allowOutsideClick: false,
                    }).then((result) => {
                      if (result.value) {
                        $("#modalProcessPayment").modal("hide");
                        dataTable.draw();
                      }
                    });
                  }
                  else if (data.code == 204 || data.code == 205) {
                    //
                    $("#modal_stripe").modal("show");
                    InitStripe();                    

                    $("#method_principal1").prop("checked", false);
                    $("#method_principal2").prop("checked", false);
                    $("#method_principal1").removeClass("is-invalid");
                    $("#method_principal2").removeClass("is-invalid");
                    
                    Swal.fire({
                      title: data.message,
                      text: lang == "es" ? "Para continuar con el proceso debes ingresar un nuevo método de pago." : "To continue with the process you must enter a new payment method.",
                      showDenyButton: false,
                      showCancelButton: false,
                      confirmButtonText: "Ok",
                      allowOutsideClick: false,
                    });
                  }
                },
                "json"
              );
            }
            else {
              //debe pagar ahora mismo
              var payment_date = sessionStorage.getItem("payment_date");
              payment_date = moment(payment_date).format("YYYY/MM/DD");
              var today = new Date();
              var today_format = moment(today).format("YYYY/MM/DD");

              var data = {
                method: "pay",
                payment_date: payment_date,
                lang: lang,
              };
              $.post("../model/application_firm_model.php", data,
                function (data) {
                  if (data.code == 200) {
                    Swal.fire({
                      title: data.message,
                      showDenyButton: false,
                      showCancelButton: false,
                      confirmButtonText: "Ok",
                      allowOutsideClick: false,
                    }).then((result) => {
                      if (result.value) {
                        $("#modalProcessPayment").modal("hide");
                        dataTable.draw();
                      }
                    });
                  }
                  else if (data.code == 204 || data.code == 205 || data.code == 206) {
                    //contacto sin metodo de pago registrado ó con el metodo de pago aun sin validar
                    
                    $("#modal_stripe").modal("show");
                    InitStripe();

                    $("#method_principal1").prop("checked", false);
                    $("#method_principal2").prop("checked", false);
                    $("#method_principal1").removeClass("is-invalid");
                    $("#method_principal2").removeClass("is-invalid");

                    Swal.fire({
                      title: data.message,
                      text: lang == "es" ? "Para continuar con el proceso debes ingresar un nuevo método de pago." : "To continue with the process you must enter a new payment method.",
                      showDenyButton: false,
                      showCancelButton: false,
                      confirmButtonText: "Ok",
                      allowOutsideClick: false,
                    });
                  }
                },
                "json"
              );
            } //en else
          }
          else {
            Swal.fire({
              text: 
                lang == "es" 
                  ? "Se ha producido un error, póngase en contacto con el administrador"
                  : "An error has occurred, contact the administrator",
              showDenyButton: false,
              showCancelButton: false,
              showConfirmButton: true,
              confirmButtonText: "Ok",
              allowOutsideClick: false,
            });
          }
        }
      });
    });

    $("#btnRegisterAndPay").click(function () {
      if ($("input[name='method_principal']:checked").val()) {
        preloader("show");
        stripe
          .confirmSetup({
            elements,
            redirect: "if_required",
            confirmParams: {
              // Return URL where the customer should be redirected after the SetupIntent is confirmed.
              return_url: "",
            },
          })
          .then(function (result) {
            if (result.error) {
              //console.log("confirmSetupIntent Error");
              var message = result.error.message;
              //console.log(result.error);
              Swal.fire({
                text: lang == "es" ? "Prueba con otro metodo de pago" : "Please try again with another payment method",
                title: message,
                showDenyButton: false,
                showCancelButton: false,
                confirmButtonText: "Ok",
                allowOutsideClick: false,
              });
            }
            else {
              console.log("confirmSetupIntent Success");
              var setupIntent = {
                payment_method: result.setupIntent.payment_method,
                status: result.setupIntent.status,
              };
              var payment_date = sessionStorage.getItem("payment_date");
              payment_date = moment(payment_date).format("YYYY/MM/DD");
              var today = new Date();
              var today_format = moment(today).format("YYYY/MM/DD");

              if (payment_date > today_format) {
                //no paga aun
                var method = "savePMandSavePP";
                if (setupIntent.status != "succeeded") {
                  //si no paga aun, y el estado del metodo de pago es diferente de succeeded
                  //entonces se debe comprobar cuantos dias faltan para su pago
                  var date_payment = moment(sessionStorage.getItem("payment_date"));
                  var format_today = moment(new Date());
                  var diff = date_payment.diff(format_today, "days");
                  if (diff < 5) {
                    //si la fecha a pagar es menor a 5 dias, entonces se debe prolongar un poco mas la fecha de pago
                    //ya que el estado del metodo no está disponible aun y debe estar disponible para poder hacer el pago
                    payment_date = moment(payment_date)
                      .add(5, "d")
                      .format("YYYY-MM-DD");
                  }
                }
              }
              else {
                //debe pagar ahora mismo
                if (setupIntent.status == "succeeded") {
                  //si el estado del metodo de pago es succeeded, entonces se guardara el metodo de pago y se cobra inmediatamente
                  var method = "savePMAndPay";
                }
                else {
                  //si el estado del metodo de pago es diferente a succeeded, entonces se guardará el metodo de pago pero
                  //el pago se programará para dentro de 5 dias a partir de la fecha actual
                  //para dar chance a que el estado del metodo de pago cambie a succeeded
                  var method = "savePMandSavePP";
                  payment_date = moment(today_format)
                    .add(5, "d")
                    .format("YYYY-MM-DD");
                }
              }
              var lang = sessionStorage.getItem("lang");
              var data = {
                method: method,
                description: $("#description_method_payment").val(),
                method_principal: $("input[name='method_principal']:checked").attr(
                  "data-principal"
                ),
                payment_date: payment_date,
                setupIntent: JSON.stringify(setupIntent, null, 2),
                lang: lang,
              };
              $.post(
                "../model/application_firm_model.php",
                data,
                function (data) {
                  if (data.code == 200) {
                    if (method == "savePMAndPay") {
                      //finalizado con pago
                      Swal.fire({
                        title: data.message,
                        showDenyButton: false,
                        showCancelButton: false,
                        confirmButtonText: "Ok",
                        allowOutsideClick: false,
                      }).then((result) => {                        
                        if (result.value) {
                          $("#modal_stripe").modal("hide");
                          $("#modalProcessPayment").modal("hide");
                          dataTable.draw();
                        }
                      });
                    }
                    else {
                      //finalizado sin pago
                      Swal.fire({
                        title: data.message,
                        showDenyButton: false,
                        showCancelButton: false,
                        confirmButtonText: "Ok",
                        allowOutsideClick: false,
                      }).then((result) => {                        
                        if (result.value) {
                          $("#modal_stripe").modal("hide");
                          $("#modalProcessPayment").modal("hide");
                          dataTable.draw();
                        }
                      });
                    }
                  }
                  else if (data.code == 204) {
                    if (method == "savePMAndPay") {
                      Swal.fire({
                        title: data.message,
                        showDenyButton: false,
                        showCancelButton: false,
                        confirmButtonText: "Ok",
                        allowOutsideClick: false,
                      });
                    }
                    else {
                      Swal.fire({
                        title: data.message,
                        showDenyButton: false,
                        showCancelButton: false,
                        confirmButtonText: "Ok",
                        allowOutsideClick: false,
                      });
                    }
                  }
                  else {
                    Swal.fire({
                      title: data.message,
                      showDenyButton: false,
                      showCancelButton: false,
                      confirmButtonText: "Ok",
                      allowOutsideClick: false,
                    });
                  }
                },
                "json"
              );
            }
          });
      }
      else {
        $("#method_principal1").addClass("is-invalid");
        $("#method_principal2").addClass("is-invalid");
      }
    }); //on click

    $("input[name='method_principal']").change(function (e) {
      $("#method_principal1").removeClass("is-invalid");
      $("#method_principal2").removeClass("is-invalid");
    });
  }
}

function InitStripe(){
  $.post("../model/application_firm_model.php", { method: "getPk" },
    function (data) {
      var lang = localStorage.getItem("settingLang");
      stripe = Stripe(data.pk, { locale: lang }); // clave publica stripe
      const appearance = {
        theme: "stripe",
        variables: {
          colorText: "#32325d",
          fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
        },
      };
      clientSecret = data.setupIntents.client_secret;
      const options = {
        clientSecret: data.setupIntents.client_secret,
        appearance: appearance,
      };
      elements = stripe.elements(options);
      paymentElement = elements.create("payment");
      paymentElement.mount("#payment-element");

      paymentElement.on("change", function (event) {
        if (event.complete) {
          //$("#validate_payment_method").val("1");
        }
        else {
          //$("#validate_payment_method").val("");
        }
      });
    },
    "json"
  );
}