$(function() {
    // dynamic grid
    agents_list.init();
    agents_list.dt_agents_list_export();
});


agents_list = {

    init: function() {
        $("#agents_list_check_all").on("change", ".m-group-checkable", function() {
            $('input:checkbox').not(this).prop('checked', this.checked);
        });


    },
    dt_agents_list_export: function() {      
        var i = 0;
        $('#dtAgentsListExport tfoot th').each(function() {
            if ( i != 0 && i != 1 && i != 2 && i != 3 && i != 15) {
                var title = $(this).text();
                $(this).html('<input type="text" placeholder="' + title + '" style="width:100%;" />');
            }
            i++;
        });
        var $dt_tableExport = $('#dtAgentsListExport'),
            $dt_buttons = $dt_tableExport.prev('.dt_colVis_buttons');
        $('#title_report').val('Agents Exports');
        //console.log($('#title_report').val())
            var dataTable = $('#dtAgentsListExport').DataTable({
            "processing": true,
            "serverSide": true,
            "lengthMenu": [[10, 100, 1000, 10000], [10, 100, 1000, 10000]],
            "responsive": true,
            "deferRender": true,
            // "sDom": "Rlfrtip",
            "scrollX": 200,
            "bInfo": true,
            "searching": true,
                "ajax": {
                    url: "../model/agents_model.php", // json datasource
                    data: {
                        method: "dtAgentsListExport"
                    },
                    type: "post", // method  , by default get
                    error: function() { // error handling
                    }
                },
                "order": [
                    [1, "asc"]
                ],
                "columnDefs": [{
                        targets: [0],
                        orderable: false
                    }],
                buttons: [{
                    extend: 'copyHtml5',
                    footer: true,
                    text: '<i class="la la-files-o"></i> Copy',
                    titleAttr: 'Copy',
                    exportOptions: {
                        columns: [ 4, 5, 6, 7 ]
                    }
                }, {
                    extend: 'print',
                    footer: true,
                    text: '<i class="la la-print"></i> Print',
                    titleAttr: 'Print',
                    exportOptions: {
                        columns: [ 4, 5, 6, 7 ]
                    },
                    title: function() {
                        return $('#title_report').val();
                    },
                }, {
                    extend: 'excelHtml5',
                    footer: true,
                    text: '<i class="la la-file-excel-o"></i> XLSX',
                    titleAttr: '',
                    exportOptions: {
                        columns: [ 4, 5, 6, 7 ]
                    },
                    title: function() {
                        return $('#title_report').val();
                    },
                }, {
                    extend: 'csvHtml5',
                    footer: true,
                    text: '<i class="la la-file-text-o"></i> CSV',
                    titleAttr: 'CSV',
                    exportOptions: {
                        columns: [ 4, 5, 6, 7 ]
                    },
                    title: function() {
                        return $('#title_report').val();
                    },
                }, {
                   text: 'Export Tab',
                    action: function () {
                        var agents = '';
                        $("input[name=agents_list_checks]").each(function(index) {
                            if ($(this).is(':checked')) {
                                    agents += $(this).val() + ',';
                            }
                        });
                        agents = agents.slice(0, -1);
                        window.open("../pdf/agent_detail.php?agents="+agents, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=500,left=500,width=400,height=400");
                    },
                    title: function() {
                        return $('#title_report').val();
                    },
                }],
                initComplete: function() {
                    dataTable.buttons().container().appendTo($dt_buttons);
                },
                drawCallback: function(response) {
                    if (response.json.code == '440') {
                        loginTimeout(response.json.message);
                        return;
                    }
                    dataTable.columns([1, 2]).visible(false, false);
                    var id_client = response.json.id_client;
                    var whiteLabel = response.json.whiteLabel;
                    if (id_client == '13' || whiteLabel == 1) {
                        dataTable.columns([6, 7, 8, 9]).visible(false, false);
                    } else {
                        dataTable.columns([10, 11]).visible(false, false);
                    }
                }
            });
            dataTable.columns().every(function() {
                var that = this;
                $('input', this.footer()).on('keyup change', function() {
                    if (that.search() !== this.value) {
                        that.search(this.value).draw();
                    }
                });
            });
    },
    export: function() {
        $.post("../pdf/agent_detail.php", {
            "agents": agents.slice(0, -1)
        }, function(data) {
            
            //console.log(data.mss);
            // if (data.mss == '1') {
            //     dtLeadsAdsList.draw();
            //     $("#assign_group_leads").modal('hide');
            //     preloader('hide', data.salida, 'success');
            // } else {
            //     preloader('hide', data.salida, 'error');
            //     console.log(data.salida);
            // }
        }, "json").fail(function(error) {
            console.log(error.responseJSON);
            preloader('hide');
        });
    },

};
