var dataTable = '';

$(function () {
    // dynamic grid
    agent_landing_pages.init();
    agent_landing_pages.events();
});

agent_landing_pages = {
    init: function () {
        dataTable = $('#dtLandignPageList').DataTable({            
            "searching": false,
            "processing": true,
            "serverSide": true,
            "responsive": !0,
            "ajax": {
                url: "../model/ctLeadsAds.php", // json datasource
                data: {method: "dtAgentsLandignPageList"},
                type: "post", // method  , by default get
                error: function () {  // error handling
                }
            },
            'columnDefs': [
                {"sClass": "dpass",
                    "aTargets": [0]
                }
            ],
            "order": [[1, "asc"]]
        });
         
    },
    events: function(){
         
        let count = 0;
        $('#dtLandignPageList tbody').on('click', '.btnClickLink', function () {
            var $tr = $(this).closest("tr");
            var data = dataTable.row($(this).parents($tr)).data();
            var id = data[0];
            var count_click = data[5];
            count = parseInt(count_click) + 1;
            // console.log(count); 
            preloader('show');
            $.post("../model/ctLeadsAds.php", {method: "countClickLandingPagesAgent", id: id, quantity: count},
                function (data) {
                    if(data.code == 200){
                        dataTable.draw();
                        preloader('hide');
                    }
                },
                "json"
            );
        });

        
    }

};

function getIdCampaignLeadsAds(id_landing_page) {
    var method = "findImageLandingPage";
    preloader("show");
    $.post(
      "../model/ctLeadsAds.php",
      {
        method: method,
        id: id_landing_page,
      },
      function (data) {
       
        preloader("hide");
        if (data.mss == "1") {
            $('#modal_lightbox').modal("show");
          $("#landing_page_image").attr("src", data.image);
        }
         else {
          console.log(data.mss);
        }
      },
      "json"
    ).fail(function (error) {
      console.log(error.responseJSON);
    });
  }