/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.OcspClient;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;

public class OcspClientBouncyCastle
implements OcspClient {
    private X509Certificate rootCert;
    private X509Certificate checkCert;
    private String url;

    public OcspClientBouncyCastle(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) {
        this.checkCert = x509Certificate;
        this.rootCert = x509Certificate2;
        this.url = string;
    }

    private static OCSPReq generateOCSPRequest(X509Certificate x509Certificate, BigInteger bigInteger) throws OCSPException, IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] getEncoded() {
        try {
            SingleResp[] singleRespArray;
            OCSPReq oCSPReq = OcspClientBouncyCastle.generateOCSPRequest(this.rootCert, this.checkCert.getSerialNumber());
            byte[] byArray = oCSPReq.getEncoded();
            URL uRL = new URL(this.url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                throw new IOException("Invalid HTTP response");
            }
            InputStream inputStream = (InputStream)httpURLConnection.getContent();
            OCSPResp oCSPResp = new OCSPResp(inputStream);
            if (oCSPResp.getStatus() != 0) {
                throw new IOException("Invalid status: " + oCSPResp.getStatus());
            }
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
            if (basicOCSPResp != null && (singleRespArray = basicOCSPResp.getResponses()).length == 1) {
                SingleResp singleResp = singleRespArray[0];
                CertificateStatus certificateStatus = singleResp.getCertStatus();
                if (certificateStatus == CertificateStatus.GOOD) {
                    return basicOCSPResp.getEncoded();
                }
                if (certificateStatus instanceof RevokedStatus) {
                    throw new IOException("OCSP Status is revoked!");
                }
                throw new IOException("OCSP Status is unknown!");
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return null;
    }
}

