/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import net.sf.jasperreports.engine.virtualization.DefaultSerializerRegistry;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.SerializationUtils;
import net.sf.jasperreports.engine.virtualization.SerializerRegistry;

public class VirtualizationOutput
extends ObjectOutputStream {
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REFERENCE_TYPE = "engine.virtualization.output.unsupported.reference.type";
    private final VirtualizationSerializer virtualizationSerializer;
    private final JRVirtualizationContext virtualizationContext;
    private final SerializerRegistry serializerRegistry = DefaultSerializerRegistry.getInstance();
    private final Map<Object, Integer>[] writtenObjects = new Map[48];

    public VirtualizationOutput(OutputStream out, VirtualizationSerializer serializer, JRVirtualizationContext virtualizationContext) throws IOException {
        super(out);
        this.virtualizationSerializer = serializer;
        this.virtualizationContext = virtualizationContext;
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    @Override
    protected void annotateClass(Class<?> clazz) throws IOException {
        super.annotateClass(clazz);
        int loaderIdx = this.virtualizationSerializer.getClassloaderIdx(clazz);
        this.writeShort(loaderIdx);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        Class<?> clazz = desc.forClass();
        if (clazz == null) {
            throw new RuntimeException();
        }
        int classIdx = this.virtualizationSerializer.getClassDescriptorIdx(clazz);
        this.writeIntCompressed(classIdx);
    }

    public void writeIntCompressed(int value) throws IOException {
        SerializationUtils.writeIntCompressed(this, value);
    }

    public void writeJRObject(Object o) throws IOException {
        this.writeJRObject(o, null, null);
    }

    public void writeJRObject(Object o, Boolean lookupReference, Boolean storeReference) throws IOException {
        Integer objectIndex;
        if (o == null) {
            this.writeByte(1);
            return;
        }
        ObjectSerializer<?> serializer = this.serializerRegistry.getSerializer(o.getClass());
        if (serializer == null) {
            this.writeByte(2);
            this.writeObject(o);
            return;
        }
        int typeValue = serializer.typeValue();
        boolean typeStoreReference = serializer.defaultStoreReference();
        if ((lookupReference == null ? typeStoreReference : lookupReference != false) && (objectIndex = this.findReference(typeValue, o)) != null) {
            this.writeByte(0x80 | typeValue);
            this.writeIntCompressed(objectIndex);
            return;
        }
        if (storeReference == null ? typeStoreReference : storeReference != false) {
            ReferenceType referenceType = serializer.defaultReferenceType();
            this.putReference(typeValue, referenceType, o);
        }
        this.writeByte(typeValue);
        serializer.write(o, this);
    }

    protected Integer findReference(int typeValue, Object value) {
        Map<Object, Integer> objectsMap = this.writtenObjects[typeValue - 16];
        return objectsMap == null ? null : objectsMap.get(value);
    }

    protected void putReference(int typeValue, ReferenceType referenceType, Object value) {
        Map<Object, Integer> objectsMap = this.writtenObjects[typeValue - 16];
        if (objectsMap == null) {
            switch (referenceType) {
                case OBJECT: {
                    objectsMap = new HashMap<Object, Integer>();
                    break;
                }
                case IDENTITY: {
                    objectsMap = new IdentityHashMap<Object, Integer>();
                    break;
                }
                default: {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REFERENCE_TYPE, new Object[]{referenceType});
                }
            }
            this.writtenObjects[typeValue - 16] = objectsMap;
        }
        int objectIndex = objectsMap.size();
        objectsMap.put(value, objectIndex);
    }
}

