<?php

namespace atoum\atoum\tests\units\iterators\filters\recursives;

require __DIR__ . '/../../../../runner.php';

use atoum\atoum;
use atoum\atoum\iterators\filters\recursives;
use atoum\atoum\mock;

class dot extends atoum\test
{
    public function testClass()
    {
        $this->testedClass->extends(\recursiveFilterIterator::class);
    }

    public function test__construct()
    {
        $this
            ->mockGenerator->shunt('__construct')
            ->if($filter = new recursives\dot($recursiveIterator = new \mock\recursiveDirectoryIterator(uniqid())))
            ->then
                ->object($filter->getInnerIterator())->isIdenticalTo($recursiveIterator)
            ->and($filter = new recursives\dot(__DIR__))
            ->then
                ->object($filter->getInnerIterator())->isEqualTo(new \recursiveDirectoryIterator(__DIR__))
                ->string($filter->getInnerIterator()->getPath())->isEqualTo(__DIR__)
            ->if($filter = new recursives\dot($path = uniqid(), function ($path) use (& $innerIterator) {
                return ($innerIterator = new \mock\recursiveDirectoryIterator($path));
            }))
            ->then
                ->object($filter->getInnerIterator())->isIdenticalTo($innerIterator)
                ->mock($filter->getInnerIterator())->call('__construct')->withArguments($path, null)->once()
        ;
    }

    public function test__accept()
    {
        $this
            ->mockGenerator->shunt('__construct')
            ->if($iteratorController = new mock\controller())
            ->and($iteratorController->__construct = function () {
            })
            ->and($filter = new recursives\dot(new \mock\recursiveDirectoryIterator(uniqid())))
            ->and($iteratorController->current = new \splFileInfo(uniqid()))
            ->then
                ->boolean($filter->accept())->isTrue()
            ->if($iteratorController->current = new \splFileInfo('.' . uniqid()))
            ->then
                ->boolean($filter->accept())->isFalse()
            ->if($iteratorController->current = new \splFileInfo(uniqid() . DIRECTORY_SEPARATOR . '.' . uniqid()))
            ->then
                ->boolean($filter->accept())->isFalse()
        ;
    }
}
