const butReq = document.getElementById('butRequest');
butReq.addEventListener('click', getContacts);

const cbMultiple = true;
const cbName = true;
const cbEmail = true;
const cbTel = true;
const cbAddress = false;
const cbIcon = false;
// const ulResults = document.getElementById('results');
// const preResults = document.getElementById('rawResults');

const supported = 'contacts' in navigator && 'ContactsManager' in window;
let details = navigator.userAgent;
let regexp = /android|iphone|kindle|ipad/i;
let isMobileDevice = regexp.test(details);

if (isMobileDevice) {
    butReq.style.opacity = 1;
} else {
    butReq.style.opacity = 0;
}

if (supported) {
    const divNotSupported = document.getElementById('notSupported');
    divNotSupported.classList.toggle('hidden', true);
    checkProperties();
}

async function checkProperties() {
    const supportedProperties = await navigator.contacts.getProperties();
    if (supportedProperties.includes('name')) {
        enableProp(cbName);
    }
    if (supportedProperties.includes('email')) {
        enableProp(cbEmail);
    }
    if (supportedProperties.includes('tel')) {
        enableProp(cbTel);
    }
    if (supportedProperties.includes('address')) {
        enableProp(cbAddress);
    }
    if (supportedProperties.includes('icon')) {
        enableProp(cbIcon);
    }
}

async function getContacts() {
    const props = [];
    if (cbName == true) props.push('name');
    if (cbEmail == true) props.push('email');
    if (cbTel == true) props.push('tel');
    // if (cbAddress.checked) props.push('address');
    // if (cbIcon.checked) props.push('icon');

    const opts = { multiple: cbMultiple == true };

    try {
        const contacts = await navigator.contacts.select(props, opts);
        handleResults(contacts);
    } catch (ex) {
        ulResults.classList.toggle('error', true);
        ulResults.classList.toggle('success', false);
        ulResults.innerText = ex.toString();
    }
}

function handleResults(contacts) {
    ulResults.classList.toggle('success', true);
    ulResults.classList.toggle('error', false);
    ulResults.innerHTML = '';
    renderResults(contacts);
}

function enableProp(cbox) {
    cbox.removeAttribute('disabled');
    cbox.setAttribute('checked', 'checked');
}

function renderResults(contacts) {
    Swal.fire({
        title: 'Are you sure to perform this action?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, import contacts!',
    }).then((result) => {
        if (result.isConfirmed) {
            var jsonData = [];
            contacts.forEach((contact, index) => {
                var names = [],
                    jsonRow = {};

                names = contact.name.toString();
                names = names.split(' ');

                jsonRow['first_name'] = names[0];
                jsonRow['last_name'] = names[1];
                jsonRow['phone'] = contact.tel.toString();
                jsonRow['email'] = contact.email.toString();

                jsonData.push(jsonRow);
            });

            fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/addmultiple', {
                method: 'POST',
                body: JSON.stringify({
                    token: 'U2FsdGVkX18Z9iGwqu0TmKXilWMZ2btZnfDk0z1yYfiAGaj7votlUt0LaG8hjAiYcmtDdYmwpGIgxIw4qL+2f1ghKosDXdvgfe72dJG+7fsgBOEl/gqiBTVFWkUG8oNoF8wMKRRfrpsuu5B1DH7JculX7u/iH3Q+72tLYPs5m5KKGCm64iME2Zho1mA8+z7hkCa5DrZgDTz3iH9u4uIARd+EJ+CX4v9JGXNw2/WznRXC5O52+Dgoe1E+zekwNHQTysQOeanXKtl/4Tv/BnvP82hfaifScZkMntIDYiOhEQPjQHR/cCdXcMB/G5UYGtT9aU16Gw1kTWGRnXcjVlYIbDQVOv2ceVm5zxen9BoQEDU=',
                    list: jsonData,
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let message = responseJson.message;
                    alert(JSON.stringify(responseJson));
                    ulResults.append(JSON.stringify(responseJson));
                });
            // const strContacts = JSON.stringify(contacts);
            // alert(strContacts);
        }
    });
}
