//Removing Preloader
setTimeout(function () {
    var preloader = document.getElementById('preloader');
    if (preloader)
    {
        preloader.classList.add('preloader-hide');
    }
}, 150);

const channel = new BroadcastChannel('sw-messages');

let wsRegistration,
    recordsFiltered = 0,
    smsIds = '',
    selectedConversation = '',
    timeInterval,
    timebetween = 0;

let ulResults = '';
let preResults = '';
const cbMultiple = true;
const cbName = true;
const cbEmail = true;
const cbTel = true;
const cbAddress = false;
const cbIcon = false;

const supported = 'contacts' in navigator && 'ContactsManager' in window;
let details = navigator.userAgent;
let regexp = /android|iphone|kindle|ipad/i;
let isMobileDevice = regexp.test(details);

document.addEventListener('DOMContentLoaded', () => {
    'use strict';

    //Global Variables
    let isPWA = true; // Enables or disables the service worker and PWA
    let isAJAX = true; // AJAX transitions. Requires local server or server
    var pwaName = 'Sticky'; //Local Storage Names for PWA
    var pwaRemind = 1; //Days to re-remind to add to home
    var pwaNoCache = false; //Requires server and HTTPS/SSL. Will clear cache with each visit
    let div_preloader = document.getElementById('preloader');
    let sessionData = JSON.parse(localStorage.getItem('user'));
    let sessionToken = JSON.parse(localStorage.getItem('token'));
    let currentPage = 1;
    const limit = 10;
    let total = 0;

    //Setting Service Worker Locations scope = folder | location = service worker js location
    var pwaScope = '/';

    var pwaLocation = '../../_service-worker.js';

    var pathPage = window.location.href.split('/').slice(-1);

    //Place all your custom Javascript functions and plugin calls below this line
    function init_template () {
        //Caching Global Variables
        var i, e, el; //https://www.w3schools.com/js/js_performance.asp

        //Attaching Menu Hider
        var menuHider = document.getElementsByClassName('menu-hider');
        if (!menuHider.length)
        {
            var hider = document.createElement('div');
            hider.setAttribute('class', 'menu-hider');

            document.body.insertAdjacentElement('beforebegin', hider);
        }

        //Demo function for programtic creation of Menu
        //menu('menu-settings', 'show', 250);

        //Activating Menus
        document.querySelectorAll('.menu').forEach((el) => {
            el.style.display = 'block';
        });

        //Validator
        var inputField = document.querySelectorAll('input');
        if (inputField.length)
        {
            var mailValidator = /^[A-Z0-9._%+-]+@([A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
            var phoneValidator = /^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/;
            var nameValidator = /^[a-zA-ZàáâäãåąčćęèéêëėįìíîïłńòóôöõøùúûüųūÿýżźñçčšžÀÁÂÄÃÅĄĆČĖĘÈÉÊËÌÍÎÏĮŁŃÒÓÔÖÕØÙÚÛÜŲŪŸÝŻŹÑßÇŒÆČŠŽ∂ð ,.'-]+$/u;
            var passwordValidator = /[A-Za-z]{2}[A-Za-z]*[ ]?[A-Za-z]*/;
            var numberValidator = /^(0|[1-9]\d*)$/;
            var linkValidator = /^(http|https)?:\/\/[a-zA-Z0-9-\.]+\.[a-z]{2,4}/;
            var textValidator = /[A-Za-z]{2}[A-Za-z]*[ ]?[A-Za-z]*/;

            function valid (el) {
                el.parentElement.querySelectorAll('.valid')[ 0 ].classList.remove('disabled');
                el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.add('disabled');
            }
            function invalid (el) {
                el.parentElement.querySelectorAll('.valid')[ 0 ].classList.add('disabled');
                el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.remove('disabled');
            }
            function unfilled (el) {
                el.parentElement.querySelectorAll('em')[ 0 ].classList.remove('disabled');
                el.parentElement.querySelectorAll('.valid')[ 0 ].classList.add('disabled');
                el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.add('disabled');
            }

            var regularField = document.querySelectorAll('.input-style-validate input:not([type="date"])');
            regularField.forEach((el) =>
                el.addEventListener('keyup', (e) => {
                    if (!el.value == '')
                    {
                        el.parentElement.classList.add('input-style-active');
                        el.parentElement.querySelector('em').classList.add('disabled');
                    } else
                    {
                        el.parentElement.querySelectorAll('.valid')[ 0 ].classList.add('disabled');
                        el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.add('disabled');
                        el.parentElement.classList.remove('input-style-active');
                        el.parentElement.querySelector('em').classList.remove('disabled');
                    }
                })
            );

            var regularTextarea = document.querySelectorAll('.input-style-validate textarea');
            regularTextarea.forEach((el) =>
                el.addEventListener('keyup', (e) => {
                    if (!el.value == '')
                    {
                        el.parentElement.classList.add('input-style-active');
                        el.parentElement.querySelector('em').classList.add('disabled');
                    } else
                    {
                        el.parentElement.classList.remove('input-style-active');
                        el.parentElement.querySelector('em').classList.remove('disabled');
                    }
                })
            );

            var selectField = document.querySelectorAll('.input-style-validate select');
            selectField.forEach((el) =>
                el.addEventListener('change', (e) => {
                    if (el.value !== 'default')
                    {
                        el.parentElement.classList.add('input-style-active');
                        el.parentElement.querySelectorAll('.valid')[ 0 ].classList.remove('disabled');
                        el.parentElement.querySelectorAll('.invalid, em, span')[ 0 ].classList.add('disabled');
                    }
                    if (el.value == 'default')
                    {
                        el.parentElement.querySelectorAll('span, .valid, em')[ 0 ].classList.add('disabled');
                        el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.remove('disabled');
                        el.parentElement.classList.add('input-style-active');
                    }
                })
            );

            var dateField = document.querySelectorAll('.input-style-validate input[type="date"]');
            dateField.forEach((el) =>
                el.addEventListener('change', (e) => {
                    el.parentElement.classList.add('input-style-active');
                    el.parentElement.querySelectorAll('.valid')[ 0 ].classList.remove('disabled');
                    el.parentElement.querySelectorAll('.invalid')[ 0 ].classList.add('disabled');
                })
            );

            var validateField = document.querySelectorAll('.validate-field input, .validator-field textarea');
            if (validateField.length)
            {
                validateField.forEach((el) =>
                    el.addEventListener('keyup', (e) => {
                        var getAttribute = el.getAttribute('type');
                        switch (getAttribute)
                        {
                            case 'name':
                                nameValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'number':
                                numberValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'email':
                                mailValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'text':
                                textValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'url':
                                linkValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'tel':
                                phoneValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                            case 'password':
                                passwordValidator.test(el.value) ? valid(el) : invalid(el);
                                break;
                        }
                        if (el.value === '')
                        {
                            unfilled(el);
                        }
                    })
                );
            }
        }

        //Image Sliders
        var splide = document.getElementsByClassName('splide');
        if (splide.length)
        {
            var singleSlider = document.querySelectorAll('.single-slider');
            if (singleSlider.length)
            {
                singleSlider.forEach(function (e) {
                    var single = new Splide('#' + e.id, {
                        type: 'loop',
                        autoplay: true,
                        interval: 4000,
                        perPage: 1,
                    }).mount();
                    var sliderNext = document.querySelectorAll('.slider-next');
                    var sliderPrev = document.querySelectorAll('.slider-prev');
                    sliderNext.forEach((el) =>
                        el.addEventListener('click', (el) => {
                            single.go('>');
                        })
                    );
                    sliderPrev.forEach((el) =>
                        el.addEventListener('click', (el) => {
                            single.go('<');
                        })
                    );
                });
            }

            var doubleSlider = document.querySelectorAll('.double-slider');
            if (doubleSlider.length)
            {
                doubleSlider.forEach(function (e) {
                    var double = new Splide('#' + e.id, {
                        type: 'loop',
                        autoplay: true,
                        interval: 4000,
                        arrows: false,
                        perPage: 2,
                    }).mount();
                });
            }

            var trippleSlider = document.querySelectorAll('.tripple-slider');
            if (trippleSlider.length)
            {
                trippleSlider.forEach(function (e) {
                    var tripple = new Splide('#' + e.id, {
                        type: 'loop',
                        autoplay: true,
                        padding: {
                            left: '0px',
                            right: '80px',
                        },
                        interval: 4000,
                        arrows: false,
                        perPage: 2,
                        perMove: 1,
                    }).mount();
                });
            }
        }

        //Don't jump on Empty Links
        const emptyHref = document.querySelectorAll('a[href="#"]');
        emptyHref.forEach((el) =>
            el.addEventListener('click', (e) => {
                e.preventDefault();
                return false;
            })
        );

        //Map Page
        var fullMap = document.querySelectorAll('.map-full');
        if (fullMap.length)
        {
            var mapActivator = document.querySelectorAll('.show-map');
            var mapDisabler = document.querySelectorAll('.hide-map');
            mapActivator[ 0 ].addEventListener('click', function (e) {
                document.getElementsByClassName('card-overlay')[ 0 ].classList.add('disabled');
                document.getElementsByClassName('card-center')[ 0 ].classList.add('disabled');
                document.getElementsByClassName('hide-map')[ 0 ].classList.remove('disabled');
            });
            mapDisabler[ 0 ].addEventListener('click', function (e) {
                document.getElementsByClassName('card-overlay')[ 0 ].classList.remove('disabled');
                document.getElementsByClassName('card-center')[ 0 ].classList.remove('disabled');
                document.getElementsByClassName('hide-map')[ 0 ].classList.add('disabled');
            });
        }

        //To Do List
        var toDoList = document.querySelectorAll('.todo-list a');
        toDoList.forEach((el) =>
            el.addEventListener('click', (e) => {
                el.classList.toggle('opacity-50');
                el.querySelector('i:last-child').classList.toggle('far');
                el.querySelector('i:last-child').classList.toggle('fa');
                el.querySelector('i:last-child').classList.toggle('fa-check-square');
                el.querySelector('i:last-child').classList.toggle('fa-square');
                el.querySelector('i:last-child').classList.toggle('color-green-dark');
            })
        );

        //Setting Sidebar Widths
        var menus = document.querySelectorAll('.menu');
        if (menus.length)
        {
            var menuSidebar = document.querySelectorAll('.menu-box-left, .menu-box-right');
            menuSidebar.forEach(function (e) {
                if (e.getAttribute('data-menu-width') === 'cover')
                {
                    e.style.width = '100%';
                } else
                {
                    e.style.width = e.getAttribute('data-menu-width') + 'px';
                }
            });
            var menuSheets = document.querySelectorAll('.menu-box-bottom, .menu-box-top, .menu-box-modal');
            menuSheets.forEach(function (e) {
                if (e.getAttribute('data-menu-width') === 'cover')
                {
                    e.style.width = '100%';
                    e.style.height = '100%';
                } else
                {
                    e.style.width = e.getAttribute('data-menu-width') + 'px';
                    e.style.height = e.getAttribute('data-menu-height') + 'px';
                }
            });

            //Opening Menus
            var menuOpen = document.querySelectorAll('[data-menu]');
            var wrappers = document.querySelectorAll('.header, #footer-bar, #footer-bar-sms, .page-content');

            menuOpen.forEach((el) =>
                el.addEventListener('click', (e) => {
                    //Close Existing Opened Menus
                    const activeMenu = document.querySelectorAll('.menu-active');
                    for (let i = 0; i < activeMenu.length; i++)
                    {
                        activeMenu[ i ].classList.remove('menu-active');
                    }
                    //Open Clicked Menu
                    var menuData = el.getAttribute('data-menu');
                    document.getElementById(menuData).classList.add('menu-active');
                    document.getElementsByClassName('menu-hider')[ 0 ].classList.add('menu-active');
                    //Check and Apply Effects
                    var menu = document.getElementById(menuData);
                    var menuEffect = menu.getAttribute('data-menu-effect');
                    var menuLeft = menu.classList.contains('menu-box-left');
                    var menuRight = menu.classList.contains('menu-box-right');
                    var menuTop = menu.classList.contains('menu-box-top');
                    var menuBottom = menu.classList.contains('menu-box-bottom');
                    var menuWidth = menu.offsetWidth;
                    var menuHeight = menu.offsetHeight;

                    if (menuEffect === 'menu-push')
                    {
                        var menuWidth = document.getElementById(menuData).getAttribute('data-menu-width');
                        if (menuLeft)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateX(' + menuWidth + 'px)';
                            }
                        }
                        if (menuRight)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateX(-' + menuWidth + 'px)';
                            }
                        }
                        if (menuBottom)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateY(-' + menuHeight + 'px)';
                            }
                        }
                        if (menuTop)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateY(' + menuHeight + 'px)';
                            }
                        }
                    }
                    if (menuEffect === 'menu-parallax')
                    {
                        var menuWidth = document.getElementById(menuData).getAttribute('data-menu-width');
                        if (menuLeft)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateX(' + menuWidth / 10 + 'px)';
                            }
                        }
                        if (menuRight)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateX(-' + menuWidth / 10 + 'px)';
                            }
                        }
                        if (menuBottom)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateY(-' + menuHeight / 5 + 'px)';
                            }
                        }
                        if (menuTop)
                        {
                            for (let i = 0; i < wrappers.length; i++)
                            {
                                wrappers[ i ].style.transform = 'translateY(' + menuHeight / 5 + 'px)';
                            }
                        }
                    }
                })
            );

            //Closing Menus
            const menuClose = document.querySelectorAll('.close-menu, .menu-hider');
            menuClose.forEach((el) =>
                el.addEventListener('click', (e) => {
                    const activeMenu = document.querySelectorAll('.menu-active');
                    for (let i = 0; i < activeMenu.length; i++)
                    {
                        activeMenu[ i ].classList.remove('menu-active');
                    }
                    for (let i = 0; i < wrappers.length; i++)
                    {
                        wrappers[ i ].style.transform = 'translateX(-' + 0 + 'px)';
                    }
                    var iframes = document.querySelectorAll('iframe');
                    iframes.forEach((el) => {
                        var hrefer = el.getAttribute('src');
                        el.setAttribute('newSrc', hrefer);
                        el.setAttribute('src', '');
                        var newSrc = el.getAttribute('newSrc');
                        el.setAttribute('src', newSrc);
                    });
                })
            );
        }

        //Back Button
        const backButton = document.querySelectorAll('[data-back-button]');
        if (backButton.length)
        {
            backButton.forEach((el) =>
                el.addEventListener('click', (e) => {
                    e.stopPropagation;
                    e.preventDefault;
                    window.history.go(-1);
                })
            );
        }

        //Back to Top
        const backToTop = document.querySelectorAll('.back-to-top-icon, .back-to-top-badge, .back-to-top');
        if (backToTop.length)
        {
            backToTop.forEach((el) =>
                el.addEventListener('click', (e) => {
                    window.scrollTo({ top: 0, behavior: `smooth` });
                })
            );
        }

        //Check iOS Version and add min-ios15 class if higher or equal to iOS15
        function iOSversion () {
            let d, v;
            if (/iP(hone|od|ad)/.test(navigator.platform))
            {
                v = navigator.appVersion.match(/OS (\d+)_(\d+)_?(\d+)?/);
                d = {
                    status: true,
                    version: parseInt(v[ 1 ], 10),
                    info: parseInt(v[ 1 ], 10) + '.' + parseInt(v[ 2 ], 10) + '.' + parseInt(v[ 3 ] || 0, 10),
                };
            } else
            {
                d = { status: false, version: false, info: '' };
            }
            return d;
        }
        let iosVer = iOSversion();
        if (iosVer.version > 14)
        {
            document.querySelectorAll('#page')[ 0 ].classList.add('min-ios15');
        }

        //Card Extender
        const cards = document.getElementsByClassName('card');
        function card_extender () {
            var headerHeight, footerHeight, headerOnPage;
            var headerOnPage = document.querySelectorAll('.header:not(.header-transparent)')[ 0 ];
            var footerOnPage = document.querySelectorAll('#footer-bar')[ 0 ];

            headerOnPage ? (headerHeight = document.querySelectorAll('.header')[ 0 ].offsetHeight) : (headerHeight = 0);
            footerOnPage ? (footerHeight = document.querySelectorAll('#footer-bar')[ 0 ].offsetHeight) : (footerHeight = 0);

            for (let i = 0; i < cards.length; i++)
            {
                if (cards[ i ].getAttribute('data-card-height') === 'cover')
                {
                    if (window.matchMedia('(display-mode: fullscreen)').matches)
                    {
                        var windowHeight = window.outerHeight;
                    }
                    if (!window.matchMedia('(display-mode: fullscreen)').matches)
                    {
                        var windowHeight = window.innerHeight;
                    }
                    //Fix for iOS 15 pages with data-height="cover"
                    var coverHeight = windowHeight + 'px';
                    // - Remove this for iOS 14 issues - var coverHeight = windowHeight - headerHeight - footerHeight + 'px';
                }
                if (cards[ i ].hasAttribute('data-card-height'))
                {
                    var getHeight = cards[ i ].getAttribute('data-card-height');
                    cards[ i ].style.height = getHeight + 'px';
                    if (getHeight === 'cover')
                    {
                        var totalHeight = getHeight;
                        cards[ i ].style.height = coverHeight;
                    }
                }
            }
        }

        if (cards.length)
        {
            card_extender();
            window.addEventListener('resize', card_extender);
        }

        //Page Highlights
        var highlightData = document.querySelectorAll('[data-change-highlight]');
        highlightData.forEach((el) =>
            el.addEventListener('click', (e) => {
                var highlight = el.getAttribute('data-change-highlight');
                var pageHighlight = document.querySelectorAll('.page-highlight');
                if (pageHighlight.length)
                {
                    pageHighlight.forEach(function (e) {
                        e.remove();
                    });
                }
                var loadHighlight = document.createElement('link');
                loadHighlight.rel = 'stylesheet';
                loadHighlight.className = 'page-highlight';
                loadHighlight.type = 'text/css';
                loadHighlight.href = 'styles/highlights/highlight_' + highlight + '.css';
                document.getElementsByTagName('head')[ 0 ].appendChild(loadHighlight);
                document.body.setAttribute('data-highlight', 'highlight-' + highlight);
                localStorage.setItem(pwaName + '-Highlight', highlight);
            })
        );
        var rememberHighlight = localStorage.getItem(pwaName + '-Highlight');
        if (rememberHighlight)
        {
            document.body.setAttribute('data-highlight', rememberHighlight);
            var loadHighlight = document.createElement('link');
            loadHighlight.rel = 'stylesheet';
            loadHighlight.className = 'page-highlight';
            loadHighlight.type = 'text/css';
            loadHighlight.href = '../../assets/styles/highlights/highlight_' + rememberHighlight + '.css';
            if (!document.querySelectorAll('.page-highlight').length)
            {
                document.getElementsByTagName('head')[ 0 ].appendChild(loadHighlight);
                document.body.setAttribute('data-highlight', 'highlight-' + rememberHighlight);
            }
        } else
        {
            var bodyHighlight = document.body.getAttribute('data-highlight');
            var defaultHighlight = bodyHighlight.split('highlight-');
            document.body.setAttribute('data-highlight', defaultHighlight[ 1 ]);
            var loadHighlight = document.createElement('link');
            loadHighlight.rel = 'stylesheet';
            loadHighlight.className = 'page-highlight';
            loadHighlight.type = 'text/css';
            loadHighlight.href = '../../assets/styles/highlights/highlight_' + defaultHighlight[ 1 ] + '.css';
            if (!document.querySelectorAll('.page-highlight').length)
            {
                document.getElementsByTagName('head')[ 0 ].appendChild(loadHighlight);
                document.body.setAttribute('data-highlight', 'highlight-' + defaultHighlight[ 1 ]);
                localStorage.setItem(pwaName + '-Highlight', defaultHighlight[ 1 ]);
            }
        }

        //Background Gradient Color
        var gradientData = document.querySelectorAll('[data-change-background]');
        gradientData.forEach((el) =>
            el.addEventListener('click', (e) => {
                var gradient = el.getAttribute('data-change-background');
                document.body.setAttribute('data-gradient', 'body-' + gradient + '');
                localStorage.setItem(pwaName + '-Gradient', gradient);
            })
        );

        //Set Background and Highlight
        var pageBackground = localStorage.getItem(pwaName + '-Gradient');
        if (pageBackground)
        {
            document.body.setAttribute('data-gradient', 'body-' + pageBackground + '');
        }

        //Dark Mode
        const toggleDark = document.querySelectorAll('[data-toggle-theme]');
        function activateDarkMode () {
            document.body.classList.add('theme-dark');
            document.body.classList.remove('theme-light', 'detect-theme');
            for (let i = 0; i < toggleDark.length; i++)
            {
                toggleDark[ i ].checked = 'checked';
            }
            localStorage.setItem(pwaName + '-Theme', 'dark-mode');
        }
        function activateLightMode () {
            document.body.classList.add('theme-light');
            document.body.classList.remove('theme-dark', 'detect-theme');
            for (let i = 0; i < toggleDark.length; i++)
            {
                toggleDark[ i ].checked = false;
            }
            localStorage.setItem(pwaName + '-Theme', 'light-mode');
        }
        function removeTransitions () {
            var falseTransitions = document.querySelectorAll('.btn, .header, #footer-bar, #footer-bar-sms, .menu-box, .menu-active');
            for (let i = 0; i < falseTransitions.length; i++)
            {
                falseTransitions[ i ].style.transition = 'all 0s ease';
            }
        }
        function addTransitions () {
            var trueTransitions = document.querySelectorAll('.btn, .header, #footer-bar, #footer-bar-sms, .menu-box, .menu-active');
            for (let i = 0; i < trueTransitions.length; i++)
            {
                trueTransitions[ i ].style.transition = '';
            }
        }

        function setColorScheme () {
            const isDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const isLightMode = window.matchMedia('(prefers-color-scheme: light)').matches;
            const isNoPreference = window.matchMedia('(prefers-color-scheme: no-preference)').matches;
            window.matchMedia('(prefers-color-scheme: dark)').addListener((e) => e.matches && activateDarkMode());
            window.matchMedia('(prefers-color-scheme: light)').addListener((e) => e.matches && activateLightMode());
            if (isDarkMode) activateDarkMode();
            if (isLightMode) activateLightMode();
        }

        //Activating Dark Mode
        const darkModeSwitch = document.querySelectorAll('[data-toggle-theme]');
        darkModeSwitch.forEach((el) =>
            el.addEventListener('click', (e) => {
                if (document.body.className == 'theme-light')
                {
                    removeTransitions();
                    activateDarkMode();
                } else if (document.body.className == 'theme-dark')
                {
                    removeTransitions();
                    activateLightMode();
                }
                setTimeout(function () {
                    addTransitions();
                }, 350);
            })
        );

        //Set Color Based on Remembered Preference.
        if (localStorage.getItem(pwaName + '-Theme') == 'dark-mode')
        {
            for (let i = 0; i < toggleDark.length; i++)
            {
                toggleDark[ i ].checked = 'checked';
            }
            document.body.className = 'theme-dark';
        }
        if (localStorage.getItem(pwaName + '-Theme') == 'light-mode')
        {
            document.body.className = 'theme-light';
        }
        if (document.body.className == 'detect-theme')
        {
            setColorScheme();
        }

        //Detect Dark/Light Mode
        const darkModeDetect = document.querySelectorAll('.detect-dark-mode');
        darkModeDetect.forEach((el) =>
            el.addEventListener('click', (e) => {
                document.body.classList.remove('theme-light', 'theme-dark');
                document.body.classList.add('detect-theme');
                setTimeout(function () {
                    setColorScheme();
                }, 50);
            })
        );

        // activating Notification.
        const notificationDetect = document.querySelectorAll('[data-toggle-notification]');
        if (notificationDetect.length)
        {
            var switchNotification = document.getElementById('switch-notification');
            notificationDetect.forEach((el) =>
                el.addEventListener('click', (e) => {
                    if (!switchNotification.checked)
                    {
                        Notification.requestPermission((permission) => {
                            if (permission === 'granted')
                            {
                                if (localStorage.getItem('publicKey') == null)
                                {
                                    getPublicKey(() => {
                                        subscribe(wsRegistration);
                                        $('#toast-8').toast('show');
                                        $('#toast-9').toast('hide');
                                    });
                                } else if (localStorage.getItem('subscription') == null)
                                {
                                    subscribe(wsRegistration);
                                    $('#toast-8').toast('show');
                                    $('#toast-9').toast('hide');
                                }
                            }
                        });
                    } else
                    {
                        unsubscribe();
                        $('#toast-9').toast('show');
                        $('#toast-8').toast('hide');
                    }
                    localStorage.setItem(pwaName + '-notification', !switchNotification.checked);
                })
            );

            //Set Notification on Remembered Preference.
            if (localStorage.getItem(pwaName + '-notification') == 'true')
            {
                switchNotification.checked = true;
            }
        }

        // Notification log
        var documentNotificationLog = document.getElementById('div_notifications_log');

        if (documentNotificationLog != null)
        {
            showNotificationLog();
        }

        //Accordion Rotate
        const accordionBtn = document.querySelectorAll('.accordion-btn');
        if (accordionBtn.length)
        {
            accordionBtn.forEach((el) =>
                el.addEventListener('click', (event) => {
                    el.querySelector('i:last-child').classList.toggle('fa-rotate-180');
                })
            );
        }

        //File Upload
        const inputArray = document.getElementsByClassName('upload-file');
        if (inputArray.length)
        {
            inputArray[ 0 ].addEventListener('change', previewFiles, false);

            function previewFiles () {
                var preview = document.querySelector('#image-data');
                var files = document.querySelector('input[type=file]').files;

                function readAndPreview (file) {
                    // Asegurate que `file.name` coincida con el criterio de extensiones

                    if (/\.(jpe?g|png|gif)$/i.test(file.name))
                    {
                        var reader = new FileReader();

                        reader.addEventListener(
                            'load',
                            function () {
                                preview.src = this.result;
                            },
                            false
                        );

                        reader.readAsDataURL(file);
                        document.getElementsByClassName('file-data')[ 0 ].classList.add('disabled');
                        $('.upload-file-data').removeClass('disabled');
                    }
                }

                if (files)
                {
                    [].forEach.call(files, readAndPreview);
                }
            }
        }

        var locationBut = document.querySelectorAll('.get-location');
        if (locationBut.length)
        {
            var locationSupport = document.getElementsByClassName('location-support')[ 0 ];
            if (typeof locationSupport != 'undefined' && locationSupport != null)
            {
                //Geo Location
                if ('geolocation' in navigator)
                {
                    locationSupport.innerHTML = 'Your browser and device <strong class="color-green2-dark">support</strong> Geolocation.';
                } else
                {
                    locationSupport.innerHTML = 'Your browser and device <strong class="color-red2-dark">support</strong> Geolocation.';
                }
            }
            function geoLocate () {
                const locationCoordinates = document.querySelector('.location-coordinates');
                function success (position) {
                    const latitude = position.coords.latitude;
                    const longitude = position.coords.longitude;
                    locationCoordinates.innerHTML = '<strong>Longitude:</strong> ' + longitude + '<br><strong>Latitude:</strong> ' + latitude;
                    var mapL1 = 'https://www.google.com/maps/embed/v1/view?key=AIzaSyAM3nxDVrkjyKwdIZp8QOplmBKLRVI5S_Y&center=';
                    var mapL2 = latitude + ',';
                    var mapL3 = longitude;
                    var mapL4 = '&zoom=16&maptype=satellite';
                    var mapL5 = '';
                    var mapLinkEmbed = mapL1 + mapL2 + mapL3 + mapL4;
                    var mapLinkAddress = mapL1 + mapL2 + mapL3 + mapL5;
                    var mapLinkNewAPI = 'https://www.google.com/maps/@' + latitude + ',' + longitude + ',15z';
                    document.getElementsByClassName('location-map')[ 0 ].setAttribute('src', mapLinkEmbed);
                    document.getElementsByClassName('location-button')[ 0 ].setAttribute('href', mapLinkNewAPI);
                    document.getElementsByClassName('location-button')[ 0 ].classList.remove('disabled');
                }
                function error () {
                    locationCoordinates.textContent = 'Unable to retrieve your location';
                }
                if (!navigator.geolocation)
                {
                    locationCoordinates.textContent = 'Geolocation is not supported by your browser';
                } else
                {
                    locationCoordinates.textContent = 'Locating';
                    navigator.geolocation.getCurrentPosition(success, error);
                }
            }
            var getLocation = document.getElementsByClassName('get-location')[ 0 ];
            if (typeof getLocation != 'undefined' && getLocation != null)
            {
                getLocation.addEventListener('click', function () {
                    this.classList.add('disabled');
                    geoLocate();
                });
            }
        }

        //Card Effects
        const cardScale = document.querySelectorAll('.card-scale');
        if (cardScale.length)
        {
            cardScale.forEach((el) =>
                el.addEventListener('mouseenter', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.add('card-scale-image');
                })
            );
            cardScale.forEach((el) =>
                el.addEventListener('mouseleave', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.remove('card-scale-image');
                })
            );
        }

        const cardHide = document.querySelectorAll('.card-hide');
        if (cardHide.length)
        {
            cardHide.forEach((el) =>
                el.addEventListener('mouseenter', (event) => {
                    el.querySelectorAll('.card-center, .card-bottom, .card-top, .card-overlay')[ 0 ].classList.add('card-hide-image');
                })
            );
            cardHide.forEach((el) =>
                el.addEventListener('mouseleave', (event) => {
                    el.querySelectorAll('.card-center, .card-bottom, .card-top, .card-overlay')[ 0 ].classList.remove('card-hide-image');
                })
            );
        }

        const cardRotate = document.querySelectorAll('.card-rotate');
        if (cardRotate.length)
        {
            cardRotate.forEach((el) =>
                el.addEventListener('mouseenter', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.add('card-rotate-image');
                })
            );
            cardRotate.forEach((el) =>
                el.addEventListener('mouseleave', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.remove('card-rotate-image');
                })
            );
        }

        const cardGray = document.querySelectorAll('.card-grayscale');
        if (cardGray.length)
        {
            cardGray.forEach((el) =>
                el.addEventListener('mouseenter', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.add('card-grayscale-image');
                })
            );
            cardGray.forEach((el) =>
                el.addEventListener('mouseleave', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.remove('card-grayscale-image');
                })
            );
        }

        const cardBlur = document.querySelectorAll('.card-blur');
        if (cardBlur.length)
        {
            cardBlur.forEach((el) =>
                el.addEventListener('mouseenter', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.add('card-blur-image');
                })
            );
            cardBlur.forEach((el) =>
                el.addEventListener('mouseleave', (event) => {
                    el.querySelectorAll('img')[ 0 ].classList.remove('card-blur-image');
                })
            );
        }

        //Adding Local Storage for Visited Links
        var checkVisited = document.querySelectorAll('.check-visited');
        if (checkVisited.length)
        {
            function check_visited_links () {
                var visited_links = JSON.parse(localStorage.getItem(pwaName + '_Visited_Links')) || [];
                var links = document.querySelectorAll('.check-visited a');
                for (let i = 0; i < links.length; i++)
                {
                    var that = links[ i ];
                    that.addEventListener('click', function (e) {
                        var clicked_url = this.href;
                        if (visited_links.indexOf(clicked_url) == -1)
                        {
                            visited_links.push(clicked_url);
                            localStorage.setItem(pwaName + '_Visited_Links', JSON.stringify(visited_links));
                        }
                    });
                    if (visited_links.indexOf(that.href) !== -1)
                    {
                        that.className += ' visited-link';
                    }
                }
            }
            check_visited_links();
        }

        //Scroll Ads
        var scrollItems = document.querySelectorAll('.scroll-ad, .header-auto-show');
        if (scrollItems.length)
        {
            var scrollAd = document.querySelectorAll('.scroll-ad');
            var scrollHeader = document.querySelectorAll('.header-auto-show');
            window.addEventListener('scroll', function () {
                if (document.querySelectorAll('.scroll-ad, .header-auto-show').length)
                {
                    function showScrollAd () {
                        scrollAd[ 0 ].classList.add('scroll-ad-visible');
                    }
                    function hideScrollAd () {
                        scrollAd[ 0 ].classList.remove('scroll-ad-visible');
                    }
                    function showHeader () {
                        scrollHeader[ 0 ].classList.add('header-active');
                    }
                    function hideHeader () {
                        scrollHeader[ 0 ].classList.remove('header-active');
                    }
                    var window_height = window.outerWidth;
                    var total_scroll_height = document.documentElement.scrollTop;
                    let inside_header = total_scroll_height <= 150;
                    var passed_header = total_scroll_height >= 150;
                    let inside_footer = window_height - total_scroll_height + 1000 <= 150;
                    if (scrollAd.length)
                    {
                        inside_header ? hideScrollAd() : null;
                        passed_header ? showScrollAd() : null;
                        inside_footer ? hideScrollAd() : null;
                    }
                    if (scrollHeader.length)
                    {
                        inside_header ? hideHeader() : null;
                        passed_header ? showHeader() : null;
                    }
                }
            });
        }

        //Stepper
        var stepperAdd = document.querySelectorAll('.stepper-add');
        var stepperSub = document.querySelectorAll('.stepper-sub');
        if (stepperAdd.length)
        {
            stepperAdd.forEach((el) =>
                el.addEventListener('click', (event) => {
                    var currentValue = el.parentElement.querySelector('input').value;
                    el.parentElement.querySelector('input').value = +currentValue + 1;
                })
            );

            stepperSub.forEach((el) =>
                el.addEventListener('click', (event) => {
                    var currentValue = el.parentElement.querySelector('input').value;
                    el.parentElement.querySelector('input').value = +currentValue - 1;
                })
            );
        }

        //Link List Toggle
        var linkListToggle = document.querySelectorAll('[data-trigger-switch]:not([data-toggle-theme])');
        if (linkListToggle.length)
        {
            linkListToggle.forEach((el) =>
                el.addEventListener('click', (event) => {
                    var switchData = el.getAttribute('data-trigger-switch');
                    var getCheck = document.getElementById(switchData);
                    getCheck.checked ? (getCheck.checked = false) : (getCheck.checked = true);
                })
            );
        }

        //Classic Toggle
        var classicToggle = document.querySelectorAll('.classic-toggle');
        if (classicToggle.length)
        {
            classicToggle.forEach((el) =>
                el.addEventListener('click', (event) => {
                    el.querySelector('i:last-child').classList.toggle('fa-rotate-180');
                    el.querySelector('i:last-child').style.transition = 'all 250ms ease';
                })
            );
        }

        //Toasts
        var toastTrigger = document.querySelectorAll('[data-toast]');
        if (toastTrigger.length)
        {
            toastTrigger.forEach((el) =>
                el.addEventListener('click', (event) => {
                    var toastData = el.getAttribute('data-toast');
                    var notificationToast = document.getElementById(toastData);
                    var notificationToast = new bootstrap.Toast(notificationToast);
                    notificationToast.show();
                })
            );
        }

        //Tooltips
        /*Deprecated feature for Mobiles. Requires popper.min.js v2 to work
        var tooltips = document.querySelectorAll('[data-bs-tooltip]');
        if(tooltips.length){
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        }
        */

        //Dropdown
        var dropdownElementList = [].slice.call(document.querySelectorAll('[data-bs-toggle="dropdown"]'));

        if (dropdownElementList.length)
        {
            var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
                return new bootstrap.Dropdown(dropdownToggleEl);
            });
            if (dropdownElementList === null) return new bootstrap.Dropdown(dropdownToggleEl);
        }

        var workingHours = document.querySelectorAll('.show-business-opened, .show-business-closed, .working-hours');
        if (workingHours.length)
        {
            //Working Hours
            var d = new Date();
            var n = d.getDay();
            var now = d.getHours() + '.' + d.getMinutes();
            var weekdays = [
                [ 'Sunday' ],
                [ 'Monday', 9.0, 17.0 ],
                [ 'Tuesday', 9.0, 17.0 ],
                [ 'Wednesday', 9.0, 17.0 ],
                [ 'Thursday', 9.0, 17.0 ],
                [ 'Friday', 9.0, 17.0 ],
                [ 'Saturday', 9.0, 13.0 ], // we are closed, sorry!
            ];
            var day = weekdays[ n ];
            var openClass = document.querySelectorAll('.show-business-opened');
            var closeClass = document.querySelectorAll('.show-business-closed');

            if ((now > day[ 1 ] && now < day[ 2 ]) || (now > day[ 3 ] && now < day[ 4 ]))
            {
                openClass.forEach(function (e) {
                    e.classList.remove('disabled');
                });
                closeClass.forEach(function (e) {
                    e.classList.add('disabled');
                });
            } else
            {
                openClass.forEach(function (e) {
                    e.classList.add('disabled');
                });
                closeClass.forEach(function (e) {
                    e.classList.remove('disabled');
                });
            }

            var workingHours = document.querySelectorAll('.working-hours[data-day]');
            workingHours.forEach(function (entry) {
                var matchDay = entry.getAttribute('data-day');
                if (matchDay === day[ 0 ])
                {
                    var matchData = '[data-day="' + day[ 0 ] + '"]';
                    if ((now > day[ 1 ] && now < day[ 2 ]) || (now > day[ 3 ] && now < day[ 4 ]))
                    {
                        document.querySelectorAll(matchData)[ 0 ].classList.add('bg-green-dark');
                        document.querySelectorAll(matchData + ' p').forEach(function (whiteText) {
                            whiteText.classList.add('color-white');
                        });
                    } else
                    {
                        document.querySelectorAll(matchData)[ 0 ].classList.add('bg-red-dark');
                        document.querySelectorAll(matchData + ' p').forEach(function (whiteText) {
                            whiteText.classList.add('color-white');
                        });
                    }
                }
            });
        }

        //Vibrate API
        var vibrateButton = document.querySelectorAll('[data-vibrate]');
        if (vibrateButton.length)
        {
            var startVibrating = document.getElementsByClassName('start-vibrating')[ 0 ];
            var stopVibrating = document.getElementsByClassName('stop-vibrating')[ 0 ];

            startVibrating.addEventListener('click', function () {
                var vibrateTime = document.getElementsByClassName('vibrate-demo')[ 0 ].value;
                window.navigator.vibrate(vibrateTime);
            });
            stopVibrating.addEventListener('click', function () {
                window.navigator.vibrate(0);
            });
            vibrateButton.forEach((el) =>
                el.addEventListener('click', (e) => {
                    var vibrateTime = el.getAttribute('data-vibrate');
                    window.navigator.vibrate(vibrateTime);
                })
            );
        }

        //Time Ads
        var timedAd = document.querySelectorAll('[data-timed-ad]');
        if (timedAd.length)
        {
            timedAd.forEach((el) =>
                el.addEventListener('click', (e) => {
                    var timedAdTime = el.getAttribute('data-timed-ad');
                    var timedAdData = el.getAttribute('data-menu');
                    var timedAdTimer = timedAdTime;
                    var timerAdFunction = setInterval(function () {
                        if (timedAdTimer <= 1)
                        {
                            clearInterval(timerAdFunction);
                            document.getElementById(timedAdData).querySelectorAll('.fa-times')[ 0 ].classList.remove('disabled');
                            document.getElementById(timedAdData).querySelectorAll('.close-menu')[ 0 ].classList.remove('no-click');
                            document.getElementById(timedAdData).querySelectorAll('span')[ 0 ].style.display = 'none';
                        } else
                        {
                        }
                        document.getElementById(timedAdData).querySelectorAll('span')[ 0 ].innerHTML = timedAdTimer -= 1;
                    }, 1000);
                })
            );
        }

        //Auto Show Ads
        var autoAd = document.querySelectorAll('[data-auto-show-ad]');
        if (autoAd.length)
        {
            var autoAdTime = autoAd[ 0 ].getAttribute('data-auto-show-ad');
            var timerAdFunction = setInterval(function () {
                if (autoAdTime <= 1)
                {
                    clearInterval(timerAdFunction);
                    var autoAdId = autoAd[ 0 ].getAttribute('data-menu');
                    document.getElementById(autoAdId).classList.add('menu-active');
                    var autoAdCloseTime = autoAd[ 0 ].getAttribute('data-timed-ad');
                    var downloadTimer = setInterval(function () {
                        if (autoAdCloseTime <= 0)
                        {
                            clearInterval(downloadTimer);
                            document.getElementById(autoAdId).querySelectorAll('.fa-times')[ 0 ].classList.remove('disabled');
                            document.getElementById(autoAdId).querySelectorAll('.close-menu')[ 0 ].classList.remove('no-click');
                            document.getElementById(autoAdId).querySelectorAll('span')[ 0 ].style.display = 'none';
                        }
                        document.getElementById(autoAdId).querySelectorAll('span')[ 0 ].innerHTML = autoAdCloseTime -= 1;
                    }, 1000);
                }
                autoAdTime -= 1;
            }, 1000);
        }

        //Reading Time

        var readingTextDiv = document.querySelectorAll('.reading-progress-text');
        if (readingTextDiv.length)
        {
            var readingWords = readingTextDiv[ 0 ].innerHTML.split(' ').length;
            var readingMinutes = Math.floor(readingWords / 250);
            var readingSeconds = readingWords % 60;
            document.getElementsByClassName('reading-progress-words')[ 0 ].innerHTML = readingWords;
            document.getElementsByClassName('reading-progress-time')[ 0 ].innerHTML = readingMinutes + ':' + readingSeconds;
        }

        //Text Resizer
        var textSizeChanger = document.querySelectorAll('.text-size-changer');
        if (textSizeChanger.length)
        {
            var textSizeIncrease = document.querySelectorAll('.text-size-increase');
            var textSizeDecrease = document.querySelectorAll('.text-size-decrease');
            var textSizeDefault = document.querySelectorAll('.text-size-default');
            textSizeIncrease[ 0 ].addEventListener('click', function () {
                textSizeChanger[ 0 ].querySelectorAll('*').forEach(function (element) {
                    const getFontSize = window.getComputedStyle(element).fontSize.split('px', 2)[ 0 ];
                    element.style.fontSize = +getFontSize + 1 + 'px';
                });
            });
            textSizeDecrease[ 0 ].addEventListener('click', function () {
                textSizeChanger[ 0 ].querySelectorAll('*').forEach(function (element) {
                    const getFontSize = window.getComputedStyle(element).fontSize.split('px', 2)[ 0 ];
                    element.style.fontSize = +getFontSize - 1 + 'px';
                });
            });
            textSizeDefault[ 0 ].addEventListener('click', function () {
                textSizeChanger[ 0 ].querySelectorAll('*').forEach(function (element) {
                    const getFontSize = window.getComputedStyle(element).fontSize.split('px', 2)[ 0 ];
                    element.style.fontSize = '';
                });
            });
        }

        //QR Generator
        var qr_image = document.querySelectorAll('.qr-image');
        if (qr_image.length)
        {
            var qr_this = window.location.href;
            var qr_auto = document.getElementsByClassName('generate-qr-auto')[ 0 ];
            var qr_api_address = 'https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=';
            if (qr_auto)
            {
                qr_auto.setAttribute('src', qr_api_address + qr_this);
            }
            var qr_btn = document.getElementsByClassName('generate-qr-button')[ 0 ];
            if (qr_btn)
            {
                qr_btn.addEventListener('click', function () {
                    var get_qr_url = document.getElementsByClassName('qr-url')[ 0 ].value;
                    var qr_api_address = 'https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=';
                    var qr_img =
                        '<img class="mx-auto polaroid-effect shadow-l mt-4 delete-qr" width="200" src="' +
                        qr_api_address +
                        get_qr_url +
                        '" alt="img"><p class="font-11 text-center mb-0">' +
                        get_qr_url +
                        '</p>';
                    document.getElementsByClassName('generate-qr-result')[ 0 ].innerHTML = qr_img;
                    qr_btn.innerHTML = 'Generate New Button';
                });
            }
        }

        if (window.location.protocol === 'file:')
        {
            var linksLocal = document.querySelectorAll('a');
            linksLocal.forEach((el) => el.addEventListener('mouseover', (event) => { }));
        }

        //Search Page
        var searchField = document.querySelectorAll('[data-search]');
        if (searchField.length)
        {
            var searchResults = document.querySelectorAll('.search-results');
            var searchNoResults = document.querySelectorAll('.search-no-results');
            var searchTotal = document.querySelectorAll('.search-results div')[ 0 ].childElementCount;
            var searchTrending = document.querySelectorAll('.search-trending');
            var clearSearch = document.querySelectorAll('.clear-search')[ 0 ];
            clearSearch.addEventListener('click', function () {
                searchField[ 0 ].value = '';
                clearSearch.classList.add('disabled');
                searchNoResults[ 0 ].classList.add('disabled');
                searchResults[ 0 ].classList.add('disabled-search-list');
                if (searchTrending[ 0 ])
                {
                    searchTrending[ 0 ].classList.remove('disabled');
                }
                var searchFilterItem = document.querySelectorAll('[data-filter-item]');
                for (let i = 0; i < searchFilterItem.length; i++)
                {
                    searchFilterItem[ i ].classList.add('disabled');
                }
            });
            function searchFunction () {
                var searchStr = searchField[ 0 ].value;
                var searchVal = searchStr.toLowerCase();
                if (searchVal != '')
                {
                    clearSearch.classList.remove('disabled');
                    searchResults[ 0 ].classList.remove('disabled-search-list');
                    var searchFilterItem = document.querySelectorAll('[data-filter-item]');
                    for (let i = 0; i < searchFilterItem.length; i++)
                    {
                        var searchData = searchFilterItem[ i ].getAttribute('data-filter-name');
                        if (searchData.includes(searchVal))
                        {
                            searchFilterItem[ i ].classList.remove('disabled');
                            if (searchTrending.length)
                            {
                                searchTrending[ 0 ].classList.add('disabled');
                            }
                        } else
                        {
                            searchFilterItem[ i ].classList.add('disabled');
                            if (searchTrending.length)
                            {
                                searchTrending[ 0 ].classList.remove('disabled');
                            }
                        }
                        var disabledResults = document.querySelectorAll('.search-results div')[ 0 ].getElementsByClassName('disabled').length;
                        if (disabledResults === searchTotal)
                        {
                            searchNoResults[ 0 ].classList.remove('disabled');
                            if (searchTrending.length)
                            {
                                searchTrending[ 0 ].classList.add('disabled');
                            }
                        } else
                        {
                            searchNoResults[ 0 ].classList.add('disabled');
                            if (searchTrending.length)
                            {
                                searchTrending[ 0 ].classList.add('disabled');
                            }
                        }
                    }
                }
                if (searchVal === '')
                {
                    clearSearch.classList.add('disabled');
                    searchResults[ 0 ].classList.add('disabled-search-list');
                    searchNoResults[ 0 ].classList.add('disabled');
                    if (searchTrending.length)
                    {
                        searchTrending[ 0 ].classList.remove('disabled');
                    }
                }
            }

            searchField[ 0 ].addEventListener('keyup', function () {
                searchFunction();
            });
            searchField[ 0 ].addEventListener('click', function () {
                searchFunction();
            });

            var searchClick = document.querySelectorAll('.search-trending a');
            searchClick.forEach((el) =>
                el.addEventListener('click', (event) => {
                    var trendingResult = el.querySelectorAll('span')[ 0 ].textContent.toLowerCase();
                    searchField[ 0 ].value = trendingResult;
                    searchField[ 0 ].click();
                })
            );
        }

        //Search Header
        var searchHeader = document.querySelectorAll('[data-toggle-search]');
        if (searchHeader)
        {
            searchHeader.forEach((el) =>
                el.addEventListener('click', (event) => {
                    window.scrollTo({ top: 0, behavior: `smooth` });
                    document.querySelectorAll('.header')[ 0 ].classList.toggle('header-search-active');
                })
            );
        }

        //Sharing
        var shareTitle = document.title;
        var shareText = document.title;
        var shareLink = window.location.href;
        if (document.querySelectorAll('.shareToFacebook, .shareToTwitter, .shareToLinkedIn')[ 0 ])
        {
            document.querySelectorAll('.shareToFacebook, .shareToTwitter, .shareToLinkedIn, .shareToWhatsApp, .shareToMail').forEach((x) => {
                x.setAttribute('target', '_blank');
            });
            document.querySelectorAll('.shareToFacebook').forEach((x) => x.setAttribute('href', 'https://www.facebook.com/sharer/sharer.php?u=' + shareLink));
            document.querySelectorAll('.shareToTwitter').forEach((x) => x.setAttribute('href', 'http://twitter.com/share?text=' + shareTitle + '%20' + shareLink));
            document.querySelectorAll('.shareToPinterest').forEach((x) => x.setAttribute('href', 'https://pinterest.com/pin/create/button/?url=' + shareLink));
            document.querySelectorAll('.shareToWhatsApp').forEach((x) => x.setAttribute('href', 'whatsapp://send?text=' + shareLink));
            document.querySelectorAll('.shareToMail').forEach((x) => x.setAttribute('href', 'mailto:?body=' + shareLink));
            document
                .querySelectorAll('.shareToLinkedIn')
                .forEach((x) => x.setAttribute('href', 'https://www.linkedin.com/shareArticle?mini=true&url=' + shareLink + '&title=' + shareTitle + '&summary=&source='));
        }
        //Menu Share Web API
        if (navigator.canShare)
        {
            const shareData = { title: shareTitle, text: shareText, url: shareLink };
            var shareMenu = document.querySelectorAll('[data-menu="menu-share"], [data-show-share]');
            if (shareMenu)
            {
                shareMenu.forEach((el) => {
                    el.addEventListener('click', async () => {
                        menu('menu-share', 'hide', 0);
                        try
                        {
                            await navigator.share(shareData);
                        } catch (err) { }
                    });
                });
            }
        }

        //Contact Form
        var contactForm = document.querySelectorAll('.contact-form');
        if (contactForm.length)
        {
            var form = document.getElementById('contactForm');
            form.onsubmit = function (e) {
                // Stop the regular form submission
                e.preventDefault();

                //Validate Fields
                var nameField = document.getElementById('contactNameField');
                var mailField = document.getElementById('contactEmailField');
                var textField = document.getElementById('contactMessageTextarea');
                var validateMail = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
                if (nameField.value === '')
                {
                    form.setAttribute('data-form', 'invalid');
                    nameField.classList.add('border-red-dark');
                    document.getElementById('validator-name').classList.remove('disabled');
                } else
                {
                    form.setAttribute('data-form', 'valid');
                    document.getElementById('validator-name').classList.add('disabled');
                    nameField.classList.remove('border-red-dark');
                }
                if (mailField.value === '')
                {
                    form.setAttribute('data-form', 'invalid');
                    mailField.classList.add('border-red-dark');
                    document.getElementById('validator-mail1').classList.remove('disabled');
                } else
                {
                    document.getElementById('validator-mail1').classList.add('disabled');
                    if (!validateMail.test(mailField.value))
                    {
                        form.setAttribute('data-form', 'invalid');
                        mailField.classList.add('border-red-dark');
                        document.getElementById('validator-mail2').classList.remove('disabled');
                    } else
                    {
                        form.setAttribute('data-form', 'valid');
                        document.getElementById('validator-mail2').classList.add('disabled');
                        mailField.classList.remove('border-red-dark');
                    }
                }
                if (textField.value === '')
                {
                    form.setAttribute('data-form', 'invalid');
                    textField.classList.add('border-red-dark');
                    document.getElementById('validator-text').classList.remove('disabled');
                } else
                {
                    form.setAttribute('data-form', 'valid');
                    document.getElementById('validator-text').classList.add('disabled');
                    textField.classList.remove('border-red-dark');
                }

                if (form.getAttribute('data-form') === 'valid')
                {
                    document.querySelectorAll('.form-sent')[ 0 ].classList.remove('disabled');
                    document.querySelectorAll('.contact-form')[ 0 ].classList.add('disabled');
                    // Collect the form data while iterating over the inputs
                    var data = {};
                    for (let i = 0, ii = form.length; i < ii; ++i)
                    {
                        let input = form[ i ];
                        if (input.name)
                        {
                            data[ input.name ] = input.value;
                        }
                    }
                    // Construct an HTTP request
                    var xhr = new XMLHttpRequest();
                    xhr.open(form.method, form.action, true);
                    xhr.setRequestHeader('Accept', 'application/json; charset=utf-8');
                    xhr.setRequestHeader('Content-Type', 'application/json; charset=UTF-8');
                    // Send the collected data as JSON
                    xhr.send(JSON.stringify(data));
                    // Callback function
                    xhr.onloadend = function (response) {
                        if (response.target.status === 200)
                        {
                        }
                    };
                }
            };
        }

        //Collapse Flip Icon
        var collapseBtn = document.querySelectorAll('[data-bs-toggle="collapse"]:not(.no-effect)');
        if (collapseBtn.length)
        {
            collapseBtn.forEach((el) =>
                el.addEventListener('click', (e) => {
                    if (el.querySelectorAll('i').length)
                    {
                        el.querySelector('i').classList.toggle('fa-rotate-180');
                    }
                })
            );
        }

        //Tabs
        var tabTrigger = document.querySelectorAll('.tab-controls a');
        if (tabTrigger.length)
        {
            tabTrigger.forEach(function (e) {
                if (e.hasAttribute('data-active'))
                {
                    var highlightColor = e.parentNode.getAttribute('data-highlight');
                    e.classList.add(highlightColor);
                    e.classList.add('no-click');
                }
            });
            tabTrigger.forEach((el) =>
                el.addEventListener('click', (e) => {
                    var highlightColor = el.parentNode.getAttribute('data-highlight');
                    var tabParentGroup = el.parentNode.querySelectorAll('a');
                    tabParentGroup.forEach(function (e) {
                        e.classList.remove(highlightColor);
                        e.classList.remove('no-click');
                    });
                    el.classList.add(highlightColor);
                    el.classList.add('no-click');
                })
            );
        }

        //Extending Menu Functions
        function menu (menuName, menuFunction, menuTimeout) {
            setTimeout(function () {
                if (menuFunction === 'show')
                {
                    return document.getElementById(menuName).classList.add('menu-active'), document.querySelectorAll('.menu-hider')[ 0 ].classList.add('menu-active');
                } else
                {
                    return document.getElementById(menuName).classList.remove('menu-active'), document.querySelectorAll('.menu-hider')[ 0 ].classList.remove('menu-active');
                }
            }, menuTimeout);
        }

        var autoActivate = document.querySelectorAll('[data-auto-activate]');
        if (autoActivate.length)
        {
            setTimeout(function () {
                autoActivate[ 0 ].classList.add('menu-active');
                menuHider[ 0 ].classList.add('menu-active');
            }, 0);
        }

        //Copyright Year
        var copyrightYear = document.getElementById('copyright-year');
        if (copyrightYear)
        {
            var dteNow = new Date();
            const intYear = dteNow.getFullYear();
            copyrightYear.textContent = intYear;
        }

        //Check Age
        var checkAge = document.querySelectorAll('.check-age');
        if (checkAge.length)
        {
            checkAge[ 0 ].addEventListener('click', function () {
                var dateBirthday = document.querySelectorAll('#date-birth-day')[ 0 ].value;
                var dateBirthMonth = document.querySelectorAll('#date-birth-month')[ 0 ].value;
                var dateBirthYear = document.querySelectorAll('#date-birth-year')[ 0 ].value;
                var age = 18;
                var mydate = new Date();
                mydate.setFullYear(dateBirthYear, dateBirthMonth - 1, dateBirthday);

                var currdate = new Date();
                var setDate = new Date();
                setDate.setFullYear(mydate.getFullYear() + age, dateBirthMonth - 1, dateBirthday);

                var menuAge = document.querySelectorAll('#menu-age');
                var menuAgeFail = document.querySelectorAll('#menu-age-fail');
                var menuAgeOkay = document.querySelectorAll('#menu-age-okay');

                if (currdate - setDate > 0)
                {
                    menuAge[ 0 ].classList.remove('menu-active');
                    menuAgeOkay[ 0 ].classList.add('menu-active');
                } else
                {
                    menuAge[ 0 ].classList.remove('menu-active');
                    menuAgeFail[ 0 ].classList.add('menu-active');
                }
                return true;
            });
        }

        //Creating Offline Alert Messages
        var addOfflineClasses = document.querySelectorAll('.offline-message');
        if (!addOfflineClasses.length)
        {
            const offlineAlert = document.createElement('p');
            const onlineAlert = document.createElement('p');
            offlineAlert.className = 'offline-message bg-red-dark color-white';
            offlineAlert.textContent = 'No internet connection detected';
            onlineAlert.className = 'online-message bg-green-dark color-white';
            onlineAlert.textContent = 'You are back online';
            document.getElementsByTagName('body')[ 0 ].appendChild(offlineAlert);
            document.getElementsByTagName('body')[ 0 ].appendChild(onlineAlert);
        }

        //Online / Offline Settings
        //Activating and Deactivating Links Based on Online / Offline State
        function offlinePage () {
            //Enable the code below to disable offline mode
            //var anchorsDisabled = document.querySelectorAll('a');
            //anchorsDisabled.forEach(function(e){
            //    var hrefs = e.getAttribute('href');
            //    if(hrefs.match(/.html/)){e.classList.add('show-offline'); e.setAttribute('data-link',hrefs); e.setAttribute('href','#');}
            //});
            var showOffline = document.querySelectorAll('.show-offline');
            showOffline.forEach((el) =>
                el.addEventListener('click', (event) => {
                    document.getElementsByClassName('offline-message')[ 0 ].classList.add('offline-message-active');
                    setTimeout(function () {
                        document.getElementsByClassName('offline-message')[ 0 ].classList.remove('offline-message-active');
                    }, 1500);
                })
            );
        }
        function onlinePage () {
            var anchorsEnabled = document.querySelectorAll('[data-link]');
            anchorsEnabled.forEach(function (e) {
                var hrefs = e.getAttribute('data-link');
                if (hrefs.match(/.html/))
                {
                    e.setAttribute('href', hrefs);
                    e.removeAttribute('data-link', '');
                }
            });
        }

        //Defining Offline/Online Variables
        var offlineMessage = document.getElementsByClassName('offline-message')[ 0 ];
        var onlineMessage = document.getElementsByClassName('online-message')[ 0 ];

        //Online / Offine Status
        function isOnline () {
            onlinePage();
            onlineMessage.classList.add('online-message-active');
            setTimeout(function () {
                onlineMessage.classList.remove('online-message-active');
            }, 2000);
            console.info('Connection: Online');
        }

        function isOffline () {
            offlinePage();
            offlineMessage.classList.add('offline-message-active');
            setTimeout(function () {
                offlineMessage.classList.remove('offline-message-active');
            }, 2000);
            console.info('Connection: Offline');
        }

        var simulateOffline = document.querySelectorAll('.simulate-offline');
        var simulateOnline = document.querySelectorAll('.simulate-online');
        if (simulateOffline.length)
        {
            simulateOffline[ 0 ].addEventListener('click', function () {
                isOffline();
            });
            simulateOnline[ 0 ].addEventListener('click', function () {
                isOnline();
            });
        }

        //Check if Online / Offline
        function updateOnlineStatus (event) {
            var condition = navigator.onLine ? 'online' : 'offline';
            isOnline();
        }
        function updateOfflineStatus (event) {
            isOffline();
        }
        window.addEventListener('online', updateOnlineStatus);
        window.addEventListener('offline', updateOfflineStatus);

        //iOS Badge
        const iOSBadge = document.querySelectorAll('.simulate-iphone-badge');
        iOSBadge.forEach((el) =>
            el.addEventListener('click', (e) => {
                document.getElementsByClassName('add-to-home')[ 0 ].classList.add('add-to-home-visible', 'add-to-home-ios');
                document.getElementsByClassName('add-to-home')[ 0 ].classList.remove('add-to-home-android');
            })
        );

        //Android Badge
        const AndroidBadge = document.querySelectorAll('.simulate-android-badge');
        AndroidBadge.forEach((el) =>
            el.addEventListener('click', (e) => {
                document.getElementsByClassName('add-to-home')[ 0 ].classList.add('add-to-home-visible', 'add-to-home-android');
                document.getElementsByClassName('add-to-home')[ 0 ].classList.remove('add-to-home-ios');
            })
        );

        //Remove Add to Home Badge
        const addToHomeBadgeClose = document.querySelectorAll('.add-to-home');
        addToHomeBadgeClose.forEach((el) =>
            el.addEventListener('click', (e) => {
                document.getElementsByClassName('add-to-home')[ 0 ].classList.remove('add-to-home-visible');
            })
        );

        //Detecting Mobile OS
        let isMobile = {
            Android: function () {
                return navigator.userAgent.match(/Android/i);
            },
            iOS: function () {
                return navigator.userAgent.match(/iPhone|iPad|iPod/i);
            },
            any: function () {
                return isMobile.Android() || isMobile.iOS();
            },
        };

        const androidDev = document.getElementsByClassName('show-android');
        const iOSDev = document.getElementsByClassName('show-ios');
        const noDev = document.getElementsByClassName('show-no-device');

        if (!isMobile.any())
        {
            for (let i = 0; i < iOSDev.length; i++)
            {
                iOSDev[ i ].classList.add('disabled');
            }
            for (let i = 0; i < androidDev.length; i++)
            {
                androidDev[ i ].classList.add('disabled');
            }
        }
        if (isMobile.iOS())
        {
            document.querySelectorAll('#page')[ 0 ].classList.add('device-is-ios');
            for (let i = 0; i < noDev.length; i++)
            {
                noDev[ i ].classList.add('disabled');
            }
            for (let i = 0; i < androidDev.length; i++)
            {
                androidDev[ i ].classList.add('disabled');
            }
        }
        if (isMobile.Android())
        {
            document.querySelectorAll('#page')[ 0 ].classList.add('device-is-android');
            for (let i = 0; i < iOSDev.length; i++)
            {
                iOSDev[ i ].classList.add('disabled');
            }
            for (let i = 0; i < noDev.length; i++)
            {
                noDev[ i ].classList.add('disabled');
            }
        }

        //OTP Boxes
        var otp = document.querySelectorAll('.otp');
        if (otp[ 0 ])
        {
            otp.forEach((el) => {
                el.addEventListener('focus', (e) => {
                    el.value = '';
                });
                el.addEventListener('input', (e) => {
                    el.nextElementSibling ? el.nextElementSibling.focus() : el.blur();
                });
            });
        }

        //PWA Settings
        if (isPWA === true)
        {
            var checkPWA = document.getElementsByTagName('html')[ 0 ];

            if (!checkPWA.classList.contains('isPWA'))
            {
                if ('serviceWorker' in navigator)
                {
                    navigator.serviceWorker.register(pwaLocation).then(function (registration) {
                        registration.update();
                        wsRegistration = registration;
                        if (localStorage.getItem('user') == null && pathPage == 'index.html')
                        {
                            if (localStorage.getItem('publicKey') == null)
                            {
                                getPublicKey(() => {
                                    subscribe(wsRegistration);
                                });
                            } else if (localStorage.getItem('subscription') == null)
                            {
                                subscribe(wsRegistration);
                            }
                        }
                    });

                    channel.addEventListener('message', (event) => {
                        // borrar la conversacion vieja y colocar la nueva el principio
                        let data = event.data;
                        console.log(data);
                        let img = data.image_url == null || data.image_url == '' ? '../../assets/images/pictures/usuario-sin-foto.jpg' : data.image_url;
                        let name = data.id_contact == null ? data.external_number : data.full_name;
                        let lastMessage = data.message;
                        // Notificaction
                        let htmlNotificaction = ` <div id="notification-3" data-bs-dismiss="notification-3" data-bs-delay="2000" data-bs-autohide="true"  class="notification notification-material bg-dark-dark notch-push mt-3">
                            <span class="notification-icon">
                                <i class="fa fa-comment color-green-light"></i>
                                <em class="color-green-light">SMS Inbound</em>
                                <strong>Go Smart Chat</strong>
                            </span>
                            <img id = "img-inboud" src="${img}">
                            <h1  id="name-inbound" class="font-15 color-white">${name}</h1>
                            <p  id ="message-inbound" class="pb-1">
                                ${lastMessage}
                            </p>
                            </div>`;
                        let documentNotification = document.getElementById('page');
                        documentNotification.insertAdjacentHTML('afterbegin', htmlNotificaction);
                        if (!pwaMensaje.length)
                        {
                            $('#notification-3').addClass('fade show');
                            setTimeout(function () {
                                $('#notification-3').removeClass('fade show');
                            }, 3500);
                        }
                        // Notificaction

                        if (pwaConversations.length)
                        {
                            let localDate = new Date(data.created);
                            let timeElapsed = moment(localDate, 'YYYY-MM-DD HH:mm').fromNow();
                            console.log(localDate, timeElapsed);
                            console.log('data', data);
                            let unread =
                                data.conversation_new == 0
                                    ? ''
                                    : `<span class="float-end mt-n1 pt-1 badge rounded-pill bg-red-dark font-9 font-400 scale-switch">${data.conversation_new}</span>`;
                            let externalNumber = data.external_number;

                            let html = `
                           
                            <div class="d-flex pb-3 conversation" data-external-number="${externalNumber}">
                           
                                <div class="align-self-center">
                            
                                    <img src="${img}" class="rounded-xl me-3" alt="img" width="45" height="45">
                                </div>
                                
                                <div class="align-self-center">
                                    <p class="font-14 font-600 color-theme mb-0 line-height-s">${name}</p>
                                    <p class="font-11 mb-0 line-height-s" style="padding-right: 2.5rem !important;">${lastMessage}</p>
                                </div>
                                
                                <div class="position-absolute end-0 pe-3 ">
                                
                                    <span class="font-9 opacity-40 color-theme">${timeElapsed}</span><br>
                                    ${unread}
                                </div>
                            </div>
                            <div class="divider mb-3" data-external-number="${externalNumber}"></div>`;

                            $(`div.conversation[data-external-number="${externalNumber}"]`).remove();
                            $(`div.divider[data-external-number="${externalNumber}"]`).remove();
                            let documentConversations = document.getElementById('div-conversations');
                            documentConversations.insertAdjacentHTML('afterbegin', html);
                            selectionConversation();
                        } else if (pwaMensaje.length)
                        {
                            let html = `<div class="message-speech speech-bubble speech-right color-black" data-sms-id="${data.id_log_sms}">
                                        ${data.message}
                                    </div>
                                    <div class="clearfix"></div>`;
                            let documentConversations = document.getElementById('chat-page');
                            documentConversations.insertAdjacentHTML('beforeend', html);
                            selectionSms();
                            $('#chat-page')
                                .stop()
                                .animate({ scrollTop: $('#chat-page')[ 0 ].scrollHeight }, 500);
                            recordsFiltered = recordsFiltered++;
                        }
                    });
                }

                //Setting Timeout Before Prompt Shows Again if Dismissed
                var hours = pwaRemind * 24; // Reset when storage is more than 24hours
                var now = Date.now();
                var setupTime = localStorage.getItem(pwaName + '-PWA-Timeout-Value');
                if (setupTime == null)
                {
                    localStorage.setItem(pwaName + '-PWA-Timeout-Value', now);
                } else if (now - setupTime > hours * 60 * 60 * 1000)
                {
                    localStorage.removeItem(pwaName + '-PWA-Prompt');
                    localStorage.setItem(pwaName + '-PWA-Timeout-Value', now);
                }

                const pwaClose = document.querySelectorAll('.pwa-dismiss');
                pwaClose.forEach((el) =>
                    el.addEventListener('click', (e) => {
                        const pwaWindows = document.querySelectorAll('#menu-install-pwa-android, #menu-install-pwa-ios');
                        for (let i = 0; i < pwaWindows.length; i++)
                        {
                            pwaWindows[ i ].classList.remove('menu-active');
                        }
                        localStorage.setItem(pwaName + '-PWA-Timeout-Value', now);
                        localStorage.setItem(pwaName + '-PWA-Prompt', 'install-rejected');
                    })
                );

                //Trigger Install Prompt for Android
                const pwaWindows = document.querySelectorAll('#menu-install-pwa-android, #menu-install-pwa-ios');
                if (pwaWindows.length)
                {
                    if (isMobile.Android())
                    {
                        if (localStorage.getItem(pwaName + '-PWA-Prompt') != 'install-rejected')
                        {
                            function showInstallPrompt () {
                                setTimeout(function () {
                                    if (!window.matchMedia('(display-mode: fullscreen)').matches)
                                    {
                                        document.getElementById('menu-install-pwa-android').classList.add('menu-active');
                                        document.querySelectorAll('.menu-hider')[ 0 ].classList.add('menu-active');
                                    }
                                }, 3500);
                            }
                            var deferredPrompt;
                            window.addEventListener('beforeinstallprompt', (e) => {
                                e.preventDefault();
                                deferredPrompt = e;
                                showInstallPrompt();
                            });
                        }
                        const pwaInstall = document.querySelectorAll('.pwa-install');
                        pwaInstall.forEach((el) =>
                            el.addEventListener('click', (e) => {
                                deferredPrompt.prompt();
                                deferredPrompt.userChoice.then((choiceResult) => {
                                    if (choiceResult.outcome === 'accepted')
                                    {
                                    } else
                                    {
                                        localStorage.setItem(pwaName + '-PWA-Timeout-Value', now);
                                        localStorage.setItem(pwaName + '-PWA-Prompt', 'install-rejected');
                                        setTimeout(function () {
                                            if (!window.matchMedia('(display-mode: fullscreen)').matches)
                                            {
                                                document.getElementById('menu-install-pwa-android').classList.remove('menu-active');
                                                document.querySelectorAll('.menu-hider')[ 0 ].classList.remove('menu-active');
                                            }
                                        }, 50);
                                    }
                                    deferredPrompt = null;
                                });
                            })
                        );
                        window.addEventListener('appinstalled', (evt) => {
                            document.getElementById('menu-install-pwa-android').classList.remove('menu-active');
                            document.querySelectorAll('.menu-hider')[ 0 ].classList.remove('menu-active');
                        });
                    }
                    //Trigger Install Guide iOS                                                                                  lhhlprkh0jrbt9wuarfhANGELIcA
                    if (isMobile.iOS())
                    {
                        if (localStorage.getItem(pwaName + '-PWA-Prompt') != 'install-rejected')
                        {
                            setTimeout(function () {
                                if (!window.matchMedia('(display-mode: fullscreen)').matches)
                                {
                                    document.getElementById('menu-install-pwa-ios').classList.add('menu-active');
                                    document.querySelectorAll('.menu-hider')[ 0 ].classList.add('menu-active');
                                }
                            }, 3500);
                        }
                    }
                }
            }
            checkPWA.setAttribute('class', 'isPWA');
        }

        // Language
        let flagLang = document.querySelectorAll("input[name='flag-lang']");

        if (flagLang.length)
        {
            flagLang.forEach((el) => {
                el.addEventListener(
                    'change',
                    () => {
                        console.log(el.value);
                        sessionStorage.setItem('lang', el.value);
                        setLanguage(el.value);
                    },
                    false
                );
            });
        }

        //End of isPWA
        if (pwaNoCache === true)
        {
            sessionStorage.clear();
            caches.keys().then((cacheNames) => {
                cacheNames.forEach((cacheName) => {
                    caches.delete(cacheName);
                });
            });
        }

        //Lazy Loading
        var lazyLoad = new LazyLoad();

        // Check Documentation folder for detailed explanations on
        // Externally loading Javascript files for better performance.

        var plugIdent, plugClass, plugMain, plugCall;
        var plugLoc = 'plugins/';

        let plugins = [
            {
                id: 'uniqueID', // to detect if loaded and unload if needed
                plug: 'pluginName/plugin.js', // the main plugin javascript file
                call: 'pluginName/pluginName-call.js', // the plugin call functions
                style: 'pluginName/pluginName-style.css', // the plugin stylesheet
                trigger: '.pluginTriggerClass', // the trigger that will activate the loading and initializing of the plugin
            },
            {
                id: 'charts-js-plugin',
                plug: 'charts/charts.js',
                call: 'charts/charts-call-graphs.js',
                trigger: '.graph',
            },
            {
                id: 'count',
                plug: 'countdown/countdown.js',
                trigger: '.countdown',
            },
            {
                id: 'gallery',
                plug: 'glightbox/glightbox.js',
                call: 'glightbox/glightbox-call.js',
                style: 'glightbox/glightbox.css',
                trigger: '[data-gallery]',
            },
            {
                id: 'gallery-views',
                call: 'galleryViews/gallery-views.js',
                trigger: '.gallery-view-controls',
            },
            {
                id: 'filter',
                plug: 'filterizr/filterizr.js',
                call: 'filterizr/filterizr-call.js',
                style: 'filterizr/filterizr.css',
                trigger: '.gallery-filter',
            },
            {
                id: 'ba-slider',
                call: 'before-after/before-after.js',
                style: 'before-after/before-after.css',
                trigger: '#before-after-slider',
            },
        ];

        for (let i = 0; i < plugins.length; i++)
        {
            //Remove Previous Calls
            if (document.querySelectorAll('.' + plugins[ i ].id + '-c').length)
            {
                document.querySelectorAll('.' + plugins[ i ].id + '-c')[ 0 ].remove();
            }

            //Load Plugins
            var plugTrigger = document.querySelectorAll(plugins[ i ].trigger);
            if (plugTrigger.length)
            {
                var loadScript = document.getElementsByTagName('script')[ 1 ],
                    loadScriptJS = document.createElement('script');
                loadScriptJS.type = 'text/javascript';
                loadScriptJS.className = plugins[ i ].id + '-p';
                loadScriptJS.src = plugLoc + plugins[ i ].plug;
                loadScriptJS.addEventListener('load', function () {
                    //Once plugin is loaded, load the call.
                    if (plugins[ i ].call !== undefined)
                    {
                        var callFn = document.getElementsByTagName('script')[ 2 ],
                            callJS = document.createElement('script');
                        callJS.type = 'text/javascript';
                        callJS.className = plugins[ i ].id + '-c';
                        callJS.src = plugLoc + plugins[ i ].call;
                        callFn.parentNode.insertBefore(callJS, callFn);
                    }
                });
                //If plugin doesn't exist, load it
                if (!document.querySelectorAll('.' + plugins[ i ].id + '-p').length && plugins[ i ].plug !== undefined)
                {
                    loadScript.parentNode.insertBefore(loadScriptJS, loadScript);
                } else
                {
                    //If plugin doesn't exist, only load the call function
                    setTimeout(function () {
                        var loadScript = document.getElementsByTagName('script')[ 1 ],
                            loadScriptJS = document.createElement('script');
                        loadScriptJS.type = 'text/javascript';
                        loadScriptJS.className = plugins[ i ].id + '-c';
                        loadScriptJS.src = plugLoc + plugins[ i ].call;
                        loadScript.parentNode.insertBefore(loadScriptJS, loadScript);
                    }, 50);
                }
                //If Style doesn't exist in array, don't do anything
                if (plugins[ i ].style !== undefined)
                {
                    //if style already exists, don't re-add to page.
                    if (!document.querySelectorAll('.' + plugins[ i ].id + '-s').length)
                    {
                        var loadCSS = document.createElement('link');
                        loadCSS.className = plugins[ i ].id + '-s';
                        loadCSS.rel = 'stylesheet';
                        loadCSS.type = 'text/css';
                        loadCSS.href = plugLoc + plugins[ i ].style;
                        document.getElementsByTagName('head')[ 0 ].appendChild(loadCSS);
                    }
                }
            }
        }
    }

    /*** Common Elements Pages ***/

    //Menu App
    const menuApp = (param) => {
        let active = `class="active-nav lang"`;
        let html = `<a href="index.html" ${param === 'index' ? active : ''}><i class="fa fa-home"></i><span class="active-nav lang" key="home">Home</ span></a> 
            <a href="contacts.html" ${param === 'contacts' ? active : ''}><i class="fa-solid fa-users"></i><span class="active-nav lang" key="contacts">Contacts</span></a> 
            <a href="conversations.html" ${param === 'conversations' ? active : ''
            }><i class="fa-solid fa-envelope"></i><span class="active-nav lang" key="conversations">Conversations</span></a>            
            <a href="#" aria-label="menu-settings" data-menu="menu-settings"><i class="fa fa-cog fa-spin"></i><span span class="active-nav lang"key="settings">Settings</span></a>`;

        if (document.querySelectorAll('#footer-bar').length)
        {
            document.getElementById('footer-bar').innerHTML = html;
        }
    };

    //Settings App
    const setting = () => {
        let html = `
            <div class="menu-title mt-0 pt-0 lang"><h1 class ="lang" key="title-setting" >Settings</h1><p class="color-highlight lang" key="flexible">Flexible and Easy to Use</p><a href="#" class="close-menu" title="closeMenu"><i class="fa fa-times"></i></a></div>
            <div class="divider divider-margins mb-n2"></div>
            <div class="content">
                <div class="list-group list-custom-small">
                        <a class="pb-2 ms-n1" href="#" onClick="logout();">
                        <i class="fa-solid fa-power-off  rounded-s bg-highlight color-white me-3"></i></i>
                        <span class="lang" key="switch-user">Switch User</span>
                    </a>                    
                    <a href="#" data-toggle-notification data-trigger-switch="switch-notification" class="pb-2 ms-n1">
                        <i class="fa fa-bell font-12 rounded-s bg-highlight color-white me-3"></i>
                        <span class="lang" key="notifications">Notifications</span>                                
                        <div class="custom-control scale-switch ios-switch">
                            <input data-toggle-intro type="checkbox" class="ios-input" id="switch-notification">
                            <label class="custom-control-label" for="switch-notification"></label>
                        </div>
                    </a>
              

                    <div class="list-group list-custom-large">
                        <a href="#" data-menu="menu-select-phone-number"  class="border-0 pb-2">
                            <i class="fa-fw font-14 bg-blue-dark rounded-s select-all fas"></i>
                            <span class ="lang" key ="select-phone-menu">Select Phone Number</span>
                            <strong class ="lang" key="if-phone-number">If You Have Another Phone Number</strong>
                        </a>
                    </div>
                    <div class="list-group list-custom-large">
                        <a href="#" data-menu="menu-change-language" onClick="selectLanguage();" id="btnLanguage">
                            <i class="fa font-14 fa-language bg-green-dark rounded-s"></i>
                            <span class="lang" key="language-head">Select Language</span>
                            <strong class="lang" key="choice-lang">Choices a Language</strong>
                            <i class="fa fa-angle-right"></i>
                        </a>
                    </div>
                </div> 
             </div>
            `;
        if (document.querySelectorAll('#menu-settings').length)
        {
            document.getElementById('menu-settings').innerHTML = html;
        }
    };

    const settingsLanguage = () => {
        let html = `        
            <div class="menu-title"><h1 class="lang" key="choice-lang">Select Language</h1><p class="color-highlight lang" key="choice-lang-default">choices a default Language</p><a href="#" class="close-menu" title="closeMenu"><i class="fa fa-times"></i></a></div>
            <div class="divider divider-margins mb-n2"></div>
            <div class="content">
                <div class="cc-selector">
                    <input id="visa" type="radio" name="flag-lang" value="es" />
                    <label class="drinkcard-cc visa" for="visa"></label>
                    <input id="mastercard" type="radio" name="flag-lang" value="en" />
                    <label class="drinkcard-cc mastercard"for="mastercard"></label>
                </div>
                <a href="#" aria-label="menu-settings" data-menu="menu-settings" class="mb-3 btn btn-full btn-m rounded-sm bg-highlight shadow-xl text-uppercase font-900 mt-4 lang" key="back-to-settings">Back to Settings</a>
            </div>`;
        if (document.querySelectorAll('#menu-change-language').length)
        {
            document.getElementById('menu-change-language').innerHTML = html;
        }
    };

    const selectNumber = () => {
        if (document.querySelectorAll('#menu-select-phone-number').length)
        {
            console.log(sessionData?.phone, 'phone');
            console.log(sessionData?.selectedPhone, 'selectedPhone');
            let phones = sessionData?.phone.split(',');
            let checkPhone = '';
            let checked = '';
            phones?.forEach((phone, i) => {
                checked = '';
                if (sessionData.selectedPhone == phone)
                {
                    checked = 'checked';
                } else if ((typeof sessionData.selectedPhone == 'undefined' || sessionData.selectedPhone == '') && i == 0)
                {
                    updateObject({ selectedPhone: phone });
                    checked = 'checked';
                }
                checkPhone += `<div class="form-check icon-check id="selection-phone">
                <input class="form-check-input" type="radio" name="radio-phone" id="${phone}" value="${phone}" ${checked}>
                <label class="form-check-label" for="${phone}">${phone}</label> 
                <i class="icon-check-1 fa fa-circle color-gray-dark font-16"></i>
                <i class="icon-check-2 fa fa-check-circle font-16 color-highlight"></i>
            </div>`;
            });
            console.log(sessionData?.phone, phones, checkPhone);
            let html = `<div class="menu-title"><h1 class ="lang" key="select-phone-number" style="font-size: 20px">Select Phone Number</h1><p class="color-highlight lang" key="if-phone-number">If You Have Another Phone Number</p><a href="#" class="close-menu"><i class="fa fa-times"></i></a></div>
                <div class="divider divider-margins mb-n2"></div>
                <div class="content">
                    <div class="highlight-changer">
                        <div class="col-6">
                            ${checkPhone}
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <a href="#" data-menu="menu-settings" class="mb-3 btn btn-full btn-m rounded-sm bg-highlight shadow-xl text-uppercase font-900 mt-4 lang" key="back-to-settings">Back to Settings</a>
                </div>`;
            document.getElementById('menu-select-phone-number').innerHTML = html;

            $('input[type=radio][name=radio-phone]').change(function () {
                fetch('https://wschatsms.gosmartcrm.com:3900/ws/userphone/updateselected', {
                    method: 'POST',
                    body: JSON.stringify({
                        token: JSON.parse(localStorage.getItem('token')),
                        phone: this.value,
                    }),
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json',
                    },
                })
                    .then((response) => response.json())
                    .then((responseJson) => {
                        let code = responseJson.code;

                        if (code == 200)
                        {
                            updateObject({ selectedPhone: this.value });
                        }
                    });
            });
        }
    };

    //CopyRight App
    const copyright = () => {
        let html = `
                <a href="#" class="footer-title"><span class="color-highlight">Go Smart Send</span></a>
                <p class="footer-text font-12"><br><span class="lang" key="powered"><br>Powered by</span>Smart Group 2022</span>           
                <div class="text-center mb-3">
                    <a href="#" aria-label="facebook" class="icon icon-xs rounded-sm shadow-l me-1 bg-facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" aria-label="twitter" class="icon icon-xs rounded-sm shadow-l me-1 bg-twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" aria-label="phone" class="icon icon-xs rounded-sm shadow-l me-1 bg-phone"><i class="fa fa-phone"></i></a>
                    <a href="#" aria-label="share-alt" data-menu="menu-share" class="icon icon-xs rounded-sm me-1 shadow-l bg-red-dark"><i class="fa fa-share-alt"></i></a>
                    <a href="#" aria-label="up" class="back-to-top icon icon-xs rounded-sm shadow-l bg-dark-light"><i class="fa fa-angle-up"></i></a>
                </div>
                <p class="footer-copyright lang font-12" key="corpyright">Copyright &copy; Enabled <span id="copyright-year">2017</span>. All Rights Reserved.</p>
                <p class="footer-links font-12"><a href="#" class="color-highlight lang" key="privacy-policy">Privacy Policy</a> | <a href="#" class="color-highlight lang" key="terms-conditions">Terms and Conditions</a> | <a href="#" class="back-to-top color-highlight lang" key="back-top"> Back to Top</a></p>
                <div class="clear"></div>
            `;
        if (document.querySelectorAll('#copyright').length)
        {
            document.getElementById('copyright').innerHTML = html;
        }
    };

    //Header Logo App
    const header = () => {
        let html = `
                <a href="index.html" aria-label="indexLogo" class="header-title color-white">GO Smart Send</a>
                <a href="#" aria-label="back-page" data-back-button class="header-icon header-icon-1 color-white"><i class="fas fa-arrow-left"></i></a>
                <div class="d-flex">
  
                    <buttton type="button" data-toggle-theme class="show-on-theme-light ms-auto icon icon-m"><i
                            class="font-12 fa fa-moon color-white"></i></buttton>
                    <buttton type="button" data-toggle-theme class="show-on-theme-dark ms-auto icon icon-m"><i
                            class="font-12 fa fa-lightbulb color-white"></i></buttton>
                </div>`;
        if (document.querySelectorAll('#header-logo').length)
        {
            document.getElementById('header-logo').innerHTML = html;
        }
    };

    const headerSms = () => {
        let html = `
                <a href="index.html" aria-label="indexLogo" class="header-title color-white lang"key="welcome">Welcome</a>
                <a href="#" aria-label="back-page" data-back-button class="header-icon header-icon-1 color-white"><i class="fas fa-arrow-left"></i></a>
                <div class="d-flex">
  
                    <a href="conversations.html"  class="header-icon header-icon-1 color-white"><i class="fas fa-envelope"></i></a>
            
                </div>`;
        if (document.querySelectorAll('#header-sms').length)
        {
            document.getElementById('header-sms').innerHTML = html;
        }
    };

    const preloader = (type, origin = '') => {
        if (type == 'show')
        {
            div_preloader.classList.remove('preloader-hide');
            div_preloader.classList.add('preloader-show');
        } else
        {
            setTimeout(function () {
                div_preloader.classList.remove('preloader-show');
                div_preloader.classList.add('preloader-hide');
            }, 1000);
        }
    };

    const updateObject = (value) => {
        Object.keys(value).forEach(function (val, key) {
            sessionData[ val ] = value[ val ];
        });
        localStorage.setItem('user', JSON.stringify(sessionData));
    };

    //Login

    let button_signin = document.querySelectorAll('#button_signin');
    if (button_signin.length)
    {
        button_signin[ 0 ].addEventListener('click', () => {
            preloader('show');

            const signinController = async () => {
                try
                {
                    let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/login/signin', {
                        method: 'POST',
                        headers: {
                            Accept: 'application/json',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            // your expected POST request payload goes here
                            user: document.getElementById('input_user').value,
                            password: document.getElementById('input_password').value,
                        }),
                    });
                    let responseJson = await res.json();
                    console.log(sessionToken);

                    let data = responseJson.data;
                    let code = responseJson.code;
                    let message = responseJson.message;
                    if (code == 200)
                    {
                        localStorage.setItem('token', JSON.stringify(responseJson.token));
                        localStorage.setItem('user', JSON.stringify(data));
                        localStorage.setItem(pwaName + '-sms', data.notificationsSms == 'enabled');
                        window.location.href = 'index.html';

                        // if (localStorage.getItem(pwaName + '-info') == 'true' || localStorage.getItem(pwaName + '-info') === null) {
                        //     window.location.href = 'intro.html';
                        //     localStorage.setItem(pwaName + '-info', 'true');
                        // } else if (localStorage.getItem(pwaName + '-info') == 'false') {
                        //     window.location.href = 'index.html';
                        // }
                    } else if (code == 204)
                    {
                        preloader('hide');
                        document.getElementById('p-log').innerHTML = `<span class="color-highlight">${message}</span>`;
                        //
                    }
                } catch (error) { }
            };
            signinController();
        });
    }

    //Authentificate
    let loginAutentificate = document.querySelectorAll('#btnReauth');
    if (pathPage[ 0 ] == 'signin.html')
    {
        let demoClasses = document.querySelectorAll('.auth-finger');
        let challenge = '',
            webauthnkeys = '';
        if (localStorage.getItem('challenge') === null)
        {
            challenge = null;
        } else
        {
            challenge = localStorage.getItem('challenge');
            webauthnkeys = localStorage.getItem('webauthnkeys');
        }

        if (window.PublicKeyCredential)
        {
            PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable().then((uvpaa) => {
                // alert('uvpaa' + uvpaa + ' ' + challenge);
                if (uvpaa && challenge != null)
                {
                    document.querySelector('#withKey').classList.remove('d-none');
                    demoClasses.forEach((element) => {
                        element.classList.remove('d-none');
                    });
                } else
                {
                    document.querySelector('#withKey').classList.add('d-none');
                    document.querySelector('#iloginform').classList.remove('d-none');
                    demoClasses.forEach((element) => {
                        element.classList.add('d-none');
                    });
                }
            });
        } else
        {
            document.getElementById('iloginform').classList.remove('d-none');
            demoClasses.forEach((element) => {
                element.classList.add('d-none');
            });
        }

        if (loginAutentificate.length)
        {
            loginAutentificate[ 0 ].addEventListener('click', () => {
                // alert(challenge);
                //preloader('show', 'autentificate fingersprint');
                // console.log(JSON.parse(challenge));
                webauthnAuthenticate(challenge, function (success, info) {
                    if (success)
                    {
                        var object1 = JSON.parse(info);
                        preloader('show');
                        const loginFinger = async () => {
                            try
                            {
                                // console.log(sessionData);
                                let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/login/signinfingerprint', {
                                    method: 'POST',
                                    headers: {
                                        Accept: 'application/json',
                                        'Content-Type': 'application/json',
                                    },
                                    body: JSON.stringify({
                                        rawId: object1.rawId.join(),
                                    }),
                                });
                                let responseJson = await res.json();
                                let code = responseJson.code;
                                let data = responseJson.data;
                                let message = responseJson.message;
                                if (code == 200)
                                {
                                    preloader('hide');
                                    Swal.fire({ icon: 'success', title: message });
                                    localStorage.setItem('token', JSON.stringify(responseJson.token));
                                    localStorage.setItem('user', JSON.stringify(data));
                                    localStorage.setItem(pwaName + '-sms', data.notificationsSms == 'enabled');
                                    window.location.href = 'index.html';
                                }
                            } catch (error)
                            {
                                console.log(error);
                            }
                        };
                        loginFinger();
                    } else
                    {
                        preloader('hide');
                        Swal.fire({
                            icon: 'danger',
                            title: info,
                        });
                    }
                });
            });
        }
    }

    let button_save_contact = document.querySelectorAll('#button_save_contact');
    if (button_save_contact.length)
    {
        button_save_contact[ 0 ].addEventListener('click', () => {
            if ($('#contacts_form').valid())
            {
                let lang = sessionStorage.getItem('lang');
                lang = lang != null ? lang : 'es';
                setLanguage(lang);
                let idContact = $('#input_id').val();
                let idContactPhone = $('#input_contact_phone').val();
                let url = '';
                let ndivs = Math.random();
                preloader('show');
                idContact == 0 && idContactPhone == 0
                    ? (url = 'https://wschatsms.gosmartcrm.com:3900/ws/contact/add')
                    : (url = 'https://wschatsms.gosmartcrm.com:3900/ws/contact/update');
                const phone = $('#input_phone').val();
                const phoneSecond = $('#input_phone_second').val() != '' ? ',' + $('#input_phone_second').val() : '';
                var formData = {
                    token: sessionToken,
                    id: idContact,
                    id_contact_phone: idContactPhone,
                    id_system_user: sessionData.idUser,
                    first_name: $('#input_first_name').val(),
                    middle_name: $('#input_middle_name').val(),
                    last_name: $('#input_last_name').val(),
                    second_surname: $('#input_second_surname').val(),
                    phone: phone + phoneSecond,
                    email: $('#input_email').val(),
                    address: $('#input_address').val(),
                    state: $('#input_state').val(),
                    city: $('#input_city').val(),
                    country: $('#input_country').val(),
                    zip: $('#input_zip').val(),
                    client_crm: $('#input_client_crm').val(),
                };
                fetch(url, {
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(formData),
                })
                    .then((response) => response.json())
                    .then((responseJson) => {
                        let code = responseJson.code;
                        let data = responseJson.data;
                        let message = responseJson.message;
                        console.log(message);

                        // if (code == 403) {
                        //     loginTimeout(message);
                        // }

                        if (code == 200 && data.response != 0)
                        {
                            preloader('hide');
                            $('#contact-list-desc').html('');
                            $('#menu-user-cog').html('');
                            $('#contact-list').html('');
                            listContactDesc();
                            loadQuotes(0, limit, 2);
                            document.querySelector('#modal_add_contact').classList.remove('menu-active');
                            // location.reload();
                        }
                        if (code == 200 && data.response == 0)
                        {
                            preloader('hide');
                            swal.fire(aLangKeys[ lang ][ 'number-registered' ], aLangKeys[ lang ][ 'number-registered-title' ], 'warning');
                        } else if (code == 204)
                        {
                            swal.fire('Error', message, 'error');
                        }
                    });
            }
        });
    }

    const pwaConversations = document.querySelectorAll('#div-conversations');
    if (pwaConversations.length)
    {
        // consultar un servicio que trae las conversacione
        fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/conversationlast', {
            method: 'POST',
            body: JSON.stringify({
                token: JSON.parse(localStorage.getItem('token')),
            }),
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json',
            },
        })
            .then((response) => response.json())
            .then((responseJson) => {
                let code = responseJson.code;
                let data = responseJson.data;
                let message = responseJson.message;
                console.log(data);

                if (code == 200)
                {
                    document.getElementById('div-conversations').innerHTML = ' ';
                    data.forEach((conversation) => {
                        let img = conversation.image_url == null || conversation.image_url == '' ? '../../assets/images/pictures/usuario-sin-foto.jpg' : conversation.image_url;

                        let localDate = new Date(conversation.created);
                        let name = conversation.id_contacts == null ? conversation.external_number : conversation.full_name;
                        let lastMessage = conversation.type == 1 ? conversation.message : 'Tú: ' + conversation.message;
                        lastMessage = lastMessage.length > 36 ? lastMessage.substring(0, 35) + '...' : lastMessage;
                        // let timeElapsed = moment(conversation.created, 'YYYY-MM-DD HH:mm').subtract('seconds', 14400).fromNow();
                        let timeElapsed = moment(localDate, 'YYYY-MM-DD HH:mm').fromNow();
                        // console.log('localDate', localDate, 'timeElapsed', timeElapsed);
                        let unread =
                            conversation.conversation_new == 0
                                ? ''
                                : `<span class="float-end mt-n1 pt-1 badge rounded-pill bg-red-dark font-9 font-400 scale-switch">${conversation.conversation_new}</span>`;
                        let externalNumber = conversation.external_number;
                        console.log(externalNumber);

                        let html = `
                            <div class="d-flex pb-3 conversation" data-external-number="${externalNumber}">
                           
                                <div class="align-self-center">
                            
                                    <img src="${img}" class="rounded-xl me-3" alt="img" width="45" height="45">
                                </div>
                                
                                <div class="align-self-center">
                                    <p class="font-14 font-600 color-theme mb-0 line-height-s">${name}</p>
                                    <p class="font-11 mb-0 line-height-s" style="padding-right: 2.5rem !important;">${lastMessage}</p>
                                </div>
                                
                                <div class="position-absolute end-0 pe-3 ">
                                
                                    <span class="font-9 opacity-40 color-theme">${timeElapsed}</span><br>
                                    ${unread}
                                </div>
                            </div>
                            <div class="divider mb-3" data-external-number="${externalNumber}"></div>`;

                        let documentConversations = document.getElementById('div-conversations');
                        documentConversations.insertAdjacentHTML('beforeend', html);
                    });
                    selectionConversation();
                } else if (code == 204)
                {
                    swal.fire('Error', message, 'error');
                }
            });

        // ciclo recorre los servicios y creas el html

        $('#seeker').keyup(function () {
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/getpagecontacts', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    start: 0,
                    length: 25,
                    search: $('#seeker').val(),
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let lang = sessionStorage.getItem('lang');
                    lang = lang != null ? lang : 'es';
                    setLanguage(lang);
                    let code = responseJson.code;
                    let data = responseJson.data;
                    let message = responseJson.message;

                    let listContacts = data.listContacts;

                    if (code == 200)
                    {
                        let html = '';
                        document.getElementById('div-sekeer').innerHTML = ' ';
                        listContacts.forEach((conversation) => {
                            let img = conversation.image_url == null || conversation.image_url == '' ? '../../assets/images/pictures/usuario-sin-foto.jpg' : conversation.image_url;
                            let localDate = new Date(conversation.created);
                            let fullName = conversation.id_contacts == null ? conversation.external_number : conversation.full_name;
                            let lastMessage = conversation.type == null ? '' : conversation.type == 1 ? conversation.message : 'Tú: ' + conversation.message;
                            let timeElapsed = localDate == null ? '' : moment(localDate, 'YYYY-MM-DD HH:mm').fromNow();
                            let unread =
                                conversation.conversation_new == 0
                                    ? ''
                                    : `<span class="float-end mt-n1 pt-1 badge rounded-pill bg-red-dark font-9 font-400 scale-switch">${conversation.conversation_new}</span>`;
                            let externalNumber = conversation.external_number;

                            html += `<a href="#" class="d-flex py-2" onclick="getChatSms('${externalNumber}')">
                                    <div class="align-self-center">
                                        <img src="${img}" width="45" height="45" class="rounded-xl me-3">
                                    </div>
                                    <div class="align-self-center">
                                        <p class="font-14 font-600 color-theme mb-0 line-height-s">${fullName}</p>
                                        <p class="font-11 mb-0 line-height-s">${lastMessage}</p>
                                    </div>
                                    <div class="position-absolute end-0 pe-3">
                                        <span class="font-9 opacity-40 color-theme">${timeElapsed}</span><br>
                                       ${unread}
                                    </div>
                                </a>`;
                        });
                        let search = $('#seeker').val();

                        document.getElementById('div-sekeer').innerHTML =
                            html == ''
                                ? ` <p class="font-14 font-600 color-theme mb-0 line-height-s content text-center"  onclick="getChatSms('${search}')">${aLangKeys[ lang ][ 'send-message' ]}<i class="fa fa-commenting"></i></p> `
                                : html;
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
        });
    }

    const pwaMensaje = document.querySelectorAll('#chat-page');
    if (pwaMensaje.length)
    {
        preloader('show');
        showChatSms('afterbegin', 0, true);

        $('#submit-button').click(function () {
            let lang = sessionStorage.getItem('lang');
            lang = lang != null ? lang : 'es';
            setLanguage(lang);
            $('.speech-read').remove();
            let messageSms = $('#text-area').val();
            let html = `<div class="message-speech speech-bubble speech-left bg-green-dark sending" data-sms-id="">
                    ${messageSms}
                </div>
                <div class="clearfix"></div>
                <em class="speech-read mb-3 "><i class="fa fa-spinner fa-spin"></i><i class="fa fa-clock-o pe-2 color-green-dark"></i>${aLangKeys[ lang ][ 'sending' ]}</em>`;
            let documentConversations = document.getElementById('chat-page');
            documentConversations.insertAdjacentHTML('beforeend', html);
            $('#chat-page')
                .stop()
                .animate({ scrollTop: $('#chat-page')[ 0 ].scrollHeight }, 500);
            $('#text-area').val('');

            fetch('https://wschatsms.gosmartcrm.com:3900/ws/logsms/smsoutbount', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    localphone: sessionData.selectedPhone,
                    externalnumber: localStorage.getItem('externalNumber'),
                    message: messageSms,
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    preloader('hide');
                    let code = responseJson.code;
                    let data = responseJson.data;
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        $('div.sending').data('sms-id', data.id);
                        $('.speech-read').text(aLangKeys[ lang ][ 'sent' ]);
                        selectionSms();
                        recordsFiltered = recordsFiltered++;
                    } else if (code == 204)
                    {
                        swal.fire(aLangKeys[ lang ][ 'sms-failed' ], aLangKeys[ lang ][ 'sms-failed-info' ], 'error');
                    }
                });
        });

        $('#chat-page').scroll((event) => {
            let start = $('.message-speech').length;
            if ($('#chat-page').scrollTop() <= 0 && recordsFiltered > start)
            {
                showChatSms('afterbegin', start);
            }
        });
    }

    const pwaOutBound = document.querySelectorAll('#button_send');
    if (pwaOutBound.length)
    {
        let lang = sessionStorage.getItem('lang');
        lang = lang != null ? lang : 'es';
        // consultar un servicio que trae las conversacione
        $('#input-to').val(sessionData.selectedPhone);

        fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/getall', {
            method: 'POST',
            body: JSON.stringify({
                token: JSON.parse(localStorage.getItem('token')),
                start: 0,
                length: 1000,
                search: '',
            }),
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json',
            },
        })
            .then((response) => response.json())
            .then((responseJson) => {
                let code = responseJson.code;
                let data = responseJson.data;
                let message = responseJson.message;

                if (code == 200)
                {
                    document.getElementById('select_from').innerHTML = '';
                    let selectFrom = document.getElementById('select_from');
                    let html = `<option value="">select a contact</option>`;
                    selectFrom.insertAdjacentHTML('beforeend', html);
                    data.listContacts.forEach((contact) => {
                        html = `<option value="${contact.phone}">${contact.full_name}</option>`;
                        selectFrom.insertAdjacentHTML('beforeend', html);
                    });
                } else if (code == 204)
                {
                    swal.fire('Error', message, 'error');
                }
            });

        $('#button_send').click(function () {
            // localphone, externalnumber, message ,MessageUUID
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/logsms/smsinbound', {
                method: 'POST',
                body: JSON.stringify({
                    localphone: sessionData.selectedPhone,
                    externalnumber: $('#select_from').val() != '' ? $('#select_from').val() : $('#input-from').val(),
                    message: $('#textarea-message').val(),
                    MessageUUID: 'sms_inbound.html',
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    preloader('hide');
                    let code = responseJson.code;
                    let data = responseJson.data;
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        $('div.sending').data('sms-id', data.id);
                        $('.speech-read').text('Sent');
                        selectionSms();
                        recordsFiltered = recordsFiltered++;
                    } else if (code == 204)
                    {
                        swal.fire('sms_inbound.html', 'error inbound', 'error');
                    }
                });
        });
    }

    const clearContactForm = () => {
        $('#input_id').val(0);
        $('#input_id_contact_phone').val(0);
        $('#input_first_name').val('');
        $('#input_middle_name').val('');
        $('#input_last_name').val('');
        $('#input_second_surname').val('');
        $('#input_phone').val('');
        $('#input_email').val('');
        $('#input_address').val('');
        $('#input_state').val('');
        $('#input_city').val('');
        $('#input_country').val('');
        $('#input_zip').val('');
        $('#input_client_crm').val('');
        $('#image-data').val('');
        $('#image-data').attr('src', '');
        $('#file-upload').val('');
        $('#file-upload').attr('src', '../../assets/images/upload.webp');
        // document.getElementsByClassName('file-data')[0].classList.remove('disabled');
        $('.upload-file-data').addClass('disabled');
        $('.upload-file-data').addClass('d-none');
    };

    const findContactById = (id) => {
        let formData = {
            token: sessionToken,
            id: id,
        };
        preloader('show');
        fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/getone', {
            method: 'POST',
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(formData),
        })
            .then((response) => response.json())
            .then((responseJson) => {
                let code = responseJson.code;
                let data = responseJson.data;
                let message = responseJson.message;
                let phone = data.phone.split(',');
                console.log(phone);
                preloader('hide');
                // if (code == 403) {
                //     loginTimeout(message);
                // }
                console.log(data);
                if (code == 200)
                {
                    $('#input_id').val(data.id);
                    $('#input_contact_phone').val(data.id_contact_phone);
                    $('#input_first_name').val(data.first_name);
                    $('#input_middle_name').val(data.middle_name);
                    $('#input_last_name').val(data.last_name);
                    $('#input_second_surname').val(data.second_surname);
                    $('#input_phone').val(phone[ 0 ]);
                    $('#input_phone_second').val(phone[ 1 ]);
                    $('#input_email').val(data.email);
                    $('#input_address').val(data.address);
                    $('#input_state').val(data.state);
                    $('#input_city').val(data.city);
                    $('#input_country').val(data.country);
                    $('#input_zip').val(data.zip);
                    $('#input_client_crm').val(data.client_crm);
                    document.querySelector('#modal_add_contact').classList.add('menu-active');
                } else if (code == 204)
                {
                    swal.fire('Error', message, 'error');
                }
            });
    };

    // get the quotes from API
    const getContacts = async (start, limit) => {
        let response = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/getall', {
            method: 'POST',
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                // your expected POST request payload goes here
                token: JSON.parse(localStorage.getItem('token')),
                start: start,
                length: limit,
                search: '',
            }),
        });
        // handle 404
        if (!response.code == 200)
        {
            throw new Error(`An error occurred: ${response.status}`);
        }

        return await response.json();
    };

    // show the contacts
    const showContacts = (contacts) => {
        console.log('showContacts', contacts);

        let dataHtml = '',
            image = '',
            phone = '';
        contacts.forEach((contact, i) => {
            let lang = sessionStorage.getItem('lang');
            lang = lang != null ? lang : 'es';
            setLanguage(lang);
            image = contact.image_url === '' || contact.image_url === null ? '../../assets/images/pictures/usuario-sin-foto.jpg' : (image = contact.image_url);

            phone = contact.phone.replace(/\D/g, '');
            if ((typeof phone == 'undefined' || phone == '') && i == 0) phone = contact.phone.replace(/\D/g, '');
            phone = contact.phone.split(',');
            dataHtml = `
            <div class="d-flex div-contact" data-contact-id="${contact.id}">
                <div id="blockdiv"class="pe-3 align-self-center ">
                    <img src="${image}" class="me-3 rounded-circle shadow-l" width="50" height="50">
                </div>
                <div class="align-self-center">
                    <h5 class="mt-1 mb-0">${capitalize(contact.first_name)} ${capitalize(contact.last_name)}</h5>
                    <p class="font-10 mt-n1 color-red-dark ">${phone[ 0 ]}
                    <p class = "font-10 mt-n4 color-red-dark ${phone[ 1 ] == undefined ? 'disabled' : ''}" style="margin-bottom: - 0px; !important;">${phone[ 1 ]}</p>
                    </p>
                </div>
                <div class="align-self-center ms-auto buttons-action ">
                <div class=" ${contact.status == 0 ? 'fa fa-ban' : ''}" style="color :red">
                </div>
                    <a href="#" data-bs-toggle="dropdown" class="icon icon-m color-theme"><i class="fa fa-ellipsis-h"></i></a>
                    <div class="dropdown-menu border-0 bg-theme rounded-m shadow-xl px-2 mt-n4">
                        <div class="list-group list-custom-small mt-n2 mb-n2" data-contact-id="${contact.id}">
                            <a href="#" class="uploadAvatar  ${contact.status == 0 ? 'disabled' : ''
                }  "   ><i class="fa font-14 fa-images color-magenta-dark opacity-60 "></i><i class ="lang" key="upload-image">Upload Image</i><i class="fa"></i></a>
                            <a href="#" class="btnEditContact  ${contact.status == 0 ? 'disabled' : ''}">
                                <i class="fa font-14 fa-edit color-green-dark  opacity-60 lang" key="editar"></i><i class ="lang" key="edit">Edit</i><i class="fa"></i>
                            </a>
                            <a href="#" onclick="getChatSms('${phone.slice(0, 1)}')" class="${contact.status == 0 ? 'disabled' : ''}">
                                <i class="fa font-14 fa-comments color-blue-dark opacity-60"></i><i class ="lang" ">${phone.slice(0, 1)}</i><i class="fa"></i>
                            </a>
                            <a href="#" onclick="getChatSms('${phone.slice(1)}')" class="${contact.status == 0 ? 'disabled' : ''} ${phone.slice(1) == '' ? 'disabled' : ''}">
                                <i class="fa font-14 fa-comments color-blue-dark opacity-60"></i><i class ="lang" ">${phone.slice(1)}</i><i class="fa"></i>
                            </a>
                            </a>
                            <a href="#" onclick="deleteContact('${contact.id
                }')"><i class="fa font-14 fa-trash color-red-dark opacity-60 "></i><i class ="lang" key="delete-contact-button">Delete</i><i class="fa"></i></a>
                            <a href="#" onclick="blockContact('${contact.id}','${contact.status}')">
                                <i class="fa font-14 fa-solid fa-ban color-black-dark opacity-60"></i><i class= "lang" key="block-unlock">Block / Unlock</i><i class="fa">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="divider"></div>`;
            $('#contact-list').append(dataHtml);
        });
    };

    const hasMoreQuotes = (start, length, total) => {
        length = $('.div-contact').length;
        return total === 0 || length < total;
    };

    // load contacts
    const loadQuotes = async (page, limit, type = 1) => {
        // show the loader
        preloader('show');
        // 0.5 second later
        setTimeout(async () => {
            try
            {
                page = $('.div-contact').length;
                let lang = sessionStorage.getItem('lang');
                lang = lang != null ? lang : 'es';
                setLanguage(lang);

                // if (hasMoreQuotes(page, limit, total) && type == 1) {
                // } else if (type == 2) {
                // }

                // call the API to get quotes
                const response = await getContacts(page, limit);
                // show quotes
                showContacts(response.data.listContacts);
                // update the total
                total = response.data.recordsFiltered;

                $('.buttons-action').on('click', '.btnEditContact', function (e) {
                    e.preventDefault();
                    clearContactForm();
                    let data = $(this).parent().data('contact-id');
                    findContactById(data);
                });

                ///////////////////////////////////////////////////////////////////
                $('.buttons-action').on('click', '.uploadAvatar', function (e) {
                    e.preventDefault();
                    clearContactForm();

                    let data = $(this).parent().data('contact-id');
                    $('#id_related').val(data);

                    // $('#image-data').attr('src', '../../assets/images/upload.webp') angelica
                    document.querySelector('#modal_add_avatar').classList.add('menu-active');
                    document.querySelector('.menu-hider').classList.add('menu-active');
                });
            } catch (error)
            {
            } finally
            {
                preloader('hide');
            }
        }, 1000);
    };

    const listContactDesc = async (token) => {
        let lang = sessionStorage.getItem('lang');
        lang = lang != null ? lang : 'es';
        setLanguage(lang);
        try
        {
            preloader('show');
            let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/listcontactslimit', {
                method: 'POST',
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    // your expected POST request payload goes here
                    token: JSON.parse(localStorage.getItem('token')),
                }),
            });

            let responseJson = await res.json();
            let dataJson = responseJson.data.listContacs;
            let code = responseJson.code;

            if (code == 200)
            {
                preloader('hide');
                var dataHtml = '';
                let image = '';
                $.each(dataJson, function (index, item) {
                    if (item.image_url != null)
                    {
                        image = item.image_url;
                    } else
                    {
                        image = '../../assets/images/pictures/usuario-sin-foto.jpg';
                    }

                    dataHtml += `
                    <a href="#" data-bs-toggle="dropdown" class="col-3 text-center">
                        <img src="${image}" width="60" height="55" class="rounded-xl icon icon-m color-theme" alt="img ">
                        <p class="font-600 color-theme mb-0 line-height-s">${item.first_name}</p>
                    </a>
                    <div class="dropdown-menu border-0 bg-theme rounded-m shadow-xl px-2 mt-n4">
                        <div class="list-group list-custom-small mt-n2 mb-n2  buttons-action" data-contact-id="${item.id}">
                            <a href="#" class="uploadAvatar ${item.status == 0 ? 'disabled' : ''
                        }"><i class="fa font-14 fa-images color-magenta-dark opacity-60"></i><i class ="lang" key="upload-image">Upload Image</i><i class="fa"></i></a>
                            <a href="#" class="btnEditContact ${item.status == 0 ? 'disabled' : ''
                        }"><i class="fa font-14 fa-edit color-green-dark  opacity-60"></i><i class ="lang" key="edit">Edit</i><i class="fa"></i></a>
                            <a href="#" onclick="getChatSms('${item.external_number}') " class="${item.status == 0 ? 'disabled' : ''
                        }"><i class="fa font-14 fa-comments color-blue-dark opacity-60"></i>Chat<i class="fa"></i></a>
                            <a href="#"   onclick="deleteContact('${item.id
                        }')"><i class="fa font-14 fa-trash color-red-dark opacity-60 lang" key="delete"></i><i class="lang" key="delete-contact-button">Delete</i><i class="fa"></i></a>
                            <a href="#" onclick="blockContact('${item.id}','${item.status
                        }')"><i class="fa font-14 fa-solid fa-ban color-black-dark opacity-60"></i><i class ="lang" key="block-unlock">Block / Unlock</i><i class="fa "></i></a>
                        </div>
                    </div>
                    `;
                });

                dataHtml += `<a href="#" id="btnAddContact" class="col-3 text-center">
                    <img src="../../assets/images/icons/cruz roja.jpg" width="60" class="rounded-xl" alt="img">
            
                </a>`;

                $('#contact-list-desc').html(dataHtml);

                let button_add_contact = document.querySelectorAll('#btnAddContact');

                if (button_add_contact.length)
                {
                    button_add_contact[ 0 ].addEventListener('click', () => {
                        clearContactForm();
                        document.querySelector('#modal_add_contact').classList.add('menu-active');
                    });
                }
            }
        } catch (error) { }
    };

    //Profile
    let buttonEditProfile = document.querySelectorAll('#button_edit_profile');
    let token = sessionToken;
    if (buttonEditProfile.length)
    {
        buttonEditProfile[ 0 ].addEventListener('click', () => {
            if ($('#formInfoProfile').valid())
            {
                preloader('show');
                // let formData = new FormData();
                // formData.append('method', 'editProfileUser');
                // formData.append('name', $('#edit_name_profile').val());
                // formData.append('username', $('#edit_username_profile').val());
                // formData.append('email', $('#edit_email_profile').val());
                // console.log(sessionToken);
                const modifiedProfile = async () => {
                    // try {
                    //     let res = await fetch('../model/user_model.php', {
                    //         method: 'POST',
                    //         body: formData,
                    //         token: token,
                    //     });
                    let lang = sessionStorage.getItem('lang');
                    lang = lang != null ? lang : 'es';
                    let res = 'https://wschatsms.gosmartcrm.com:3900/ws/user/setuserprofile';

                    var formData = {
                        token: sessionToken,
                        name: $('#edit_name_profile').val(),
                        username: $('#edit_username_profile').val(),
                        email: $('#edit_email_profile').val(),
                    };
                    res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/setuserprofile', {
                        method: 'POST',
                        headers: {
                            Accept: 'application/json',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(formData),
                    });
                    console.log(sessionToken);
                    let responseJson = await res.json();
                    let code = responseJson.code;
                    console.log(code);
                    let data = responseJson.data;
                    console.log(data);
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        preloader('hide');
                        updateObject({ name: data.name });
                        updateObject({ username: data.username });
                        updateObject({ email: data.email });

                        //console.log(localStorage.getItem('user'));
                        document.getElementById('edit_name_profile').value = data.name;
                        document.getElementById('edit_username_profile').value = data.username;
                        document.getElementById('edit_email_profile').value = data.email;
                        Swal.fire({
                            icon: 'success',
                            title: aLangKeys[ lang ][ 'profile-update' ],
                        });
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }

                    // } catch (error) {
                    //     console.log(error);
                    // }
                };
                modifiedProfile();
                // location.reload();
            }
        });
    }

    //Profile Password
    let buttonEditPasswordUser = document.querySelectorAll('#button_edit_password_profile');
    // let token = JSON.parse(localStorage.getItem('token'));

    if (buttonEditPasswordUser.length)
    {
        buttonEditPasswordUser[ 0 ].addEventListener('click', () => {
            if ($('#formPasswordProfile').valid())
            {
                preloader('show');
                // let formData = new FormData();
                // formData.append('method', 'editPasswordUser');
                // formData.append('password', $('#edit_new_password_profile').val());
                // formData.append('passwordold', $('#edit_actual_password_profile').val());
                // formData.append('token', sessionToken);
                const modifiedPassword = async () => {
                    // try {
                    //     let res = await fetch('../model/user_model.php', {
                    //         method: 'POST',
                    //         body: formData,
                    //     });
                    let lang = sessionStorage.getItem('lang');
                    lang = lang != null ? lang : 'es';
                    let res = 'https://wschatsms.gosmartcrm.com:3900/ws/user/changepassword';

                    var formData = {
                        token: sessionToken,
                        password: $('#edit_new_password_profile').val(),
                        passwordold: $('#edit_actual_password_profile').val(),
                    };
                    res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/changepassword', {
                        method: 'POST',
                        headers: {
                            Accept: 'application/json',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(formData),
                    });
                    let responseJson = await res.json();
                    let code = responseJson.code;
                    let data = responseJson.jsonData;
                    let message = responseJson.message;
                    preloader('hide');
                    if (code == 200)
                    {
                        Swal.fire({
                            icon: 'success',
                            title: aLangKeys[ lang ][ 'password-update' ],
                        });
                        $('#edit_new_password_profile').val('');
                        $('#edit_actual_password_profile').val('');
                        $('#edit_confirm_password_profile').val('');
                    } else if (code == 204)
                    {
                        swal.fire('Error', aLangKeys[ lang ][ 'password-error' ], 'error');
                    }
                    // } catch (error) {
                    //     console.log(error);
                    // }
                };
                modifiedPassword();
            }
        });

        //Profile Image
        let buttonEditImageUser = document.querySelectorAll('#buttonUploadFileUser');

        if (buttonEditImageUser.length)
        {
            buttonEditImageUser[ 0 ].addEventListener('click', () => {
                preloader('show');
                let storageRef = firebase.storage().ref('profile/');
                let file = $('#image').attr('src');
                let pathname = `${sessionData.idUser}/${sessionData.idUser}.jpg`;
                console.log(pathname);
                if (file.length != 0)
                {
                    let uploadTask = storageRef.child(pathname).putString(file, 'data_url');

                    uploadTask.on(
                        'state_changed',
                        function (snapshot) {
                            let progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
                            console.log('Upload is ' + progress + '% done');
                            console.log(snapshot.state);
                            switch (snapshot.state)
                            {
                                case firebase.storage.TaskState.PAUSED: // or 'paused'
                                    console.log('Upload is paused');
                                    break;
                                case firebase.storage.TaskState.RUNNING: // or 'running'
                                    console.log('Upload is running');
                                    break;
                            }
                        },
                        function (error) {
                            console.log(error);
                        },
                        function () {
                            uploadTask.snapshot.ref.getDownloadURL().then(function (downloadURL) {
                                const modifiedImage = async () => {
                                    try
                                    {
                                        let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/setuserimage', {
                                            method: 'POST',
                                            headers: {
                                                Accept: 'application/json',
                                                'Content-Type': 'application/json',
                                            },
                                            body: JSON.stringify({
                                                // your expected POST request payload goes here
                                                token: JSON.parse(localStorage.getItem('token')),
                                                image_url: downloadURL,
                                                image_path: pathname,
                                            }),
                                        });
                                        let responseJson = await res.json();
                                        //console.log(responseJson)
                                        let code = responseJson.code;
                                        let message = responseJson.message;
                                        preloader('hide');
                                        if (code == 200)
                                        {
                                            Swal.fire({
                                                icon: 'success',
                                                title: 'uploaded image',
                                                text: 'Image Uploaded Successfully!',
                                            });
                                            updateObject({ path_image: downloadURL });
                                            updateObject({ path_name: pathname });
                                            document.getElementById('imageUser').style.backgroundImage = `url('${downloadURL}')`;
                                            document.getElementById('imageUser').setAttribute('data-src', downloadURL);
                                            document.getElementById('imageUser').setAttribute('src', downloadURL);
                                            document.getElementById('image-data').setAttribute('src', downloadURL);
                                        }
                                    } catch (error)
                                    {
                                        console.log(error);
                                    }
                                };
                                modifiedImage();
                            });
                        }
                    );
                }
                //endif file
                else
                {
                    Swal.fire({
                        icon: 'error',
                        title: 'No have a photo charged',
                    });
                }
            });
        }

        let buttonDeleteImageUser = document.querySelectorAll('#buttonDeleteFile');

        if (buttonDeleteImageUser.length)
        {
            buttonDeleteImageUser[ 0 ].addEventListener('click', () => {
                preloader('show');
                // TODO agregar path_name para eliminar de firebase la imagen de perfil
                let storageRef = firebase.storage().ref();

                // let formData = new FormData();
                // formData.append('method', 'editImageUser');
                // formData.append('token', sessionData.token);
                // formData.append('image', '');

                const modifiedImage = async () => {
                    try
                    {
                        console.log(sessionData);
                        let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/setuserimage', {
                            method: 'POST',
                            headers: {
                                Accept: 'application/json',
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                // your expected POST request payload goes here
                                token: JSON.parse(localStorage.getItem('token')),
                                image_url: '',
                                image_path: '',
                            }),
                        });
                        let responseJson = await res.json();
                        let code = responseJson.code;
                        let data = responseJson.jsonData;
                        let message = responseJson.message;
                        preloader('hide');
                        if (code == 200)
                        {
                            Swal.fire({
                                icon: 'success',
                                title: 'ok',
                            });
                            if (sessionData.path_image.length)
                            {
                                storageRef.child(sessionData.path_name).delete();
                                updateObject({ path_image: '' });
                                updateObject({ path_name: '' });
                            }

                            document.getElementById('file-upload').value = '';
                            document.getElementById('imageUser').setAttribute('data-src', '../../assets/images/pictures/usuario-sin-foto.jpg');
                            document.getElementById('imageUser').setAttribute('src', '../../assets/images/pictures/usuario-sin-foto.jpg');
                            document.getElementById('imageUser').style.backgroundImage = "url('../../assets/images/pictures/usuario-sin-foto.jpg')";
                            document.getElementsByClassName('file-data')[ 0 ].classList.remove('disabled');
                            document.getElementsByClassName('upload-file-data')[ 0 ].classList.add('disabled');
                            document.getElementsByClassName('upload-file-data')[ 0 ].classList.add('d-none');
                        }
                    } catch (error)
                    {
                        console.log(error);
                    }
                };
                modifiedImage();
            });
        }
    }

    //Profile Add Crendential (Huella)
    const btnAddCredential = document.querySelectorAll('#btnAddCredential');
    if (pathPage[ 0 ] == 'profile.html')
    {
        if (window.PublicKeyCredential)
        {
            PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable().then((uvpaa) => {
                //alert(uvpaa)
                if (uvpaa)
                {
                    document.querySelector('#iregisterform').classList.remove('d-none');
                } else
                {
                    document.getElementById('uvpa_unavailable').classList.remove('d-none');
                }
            });
        } else
        {
            document.getElementById('uvpa_unavailable').classList.remove('d-none');
        }

        let challenge = '';
        if (localStorage.getItem('challenge') === null)
        {
            challenge = null;
        } else
        {
            challenge = localStorage.getItem('challenge');
        }

        if (btnAddCredential.length)
        {
            btnAddCredential[ 0 ].addEventListener('click', () => {
                const cp = 'No';
                if (cp == '')
                {
                    Swal.fire({
                        icon: 'success',
                        title: 'Please choose cross-platform setting - see note below about what this means',
                    });
                    return;
                }

                document.getElementById('iregisterform').classList.add('d-none');
                updateObject({ webauthnkeys: '' });
                const addCredential = async () => {
                    let lang = sessionStorage.getItem('lang');
                    lang = lang != null ? lang : 'es';
                    try
                    {
                        // console.log(sessionData);
                        let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/addWebAuthnKeys', {
                            method: 'POST',
                            headers: {
                                Accept: 'application/json',
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                // your expected POST request payload goes here
                                token: JSON.parse(localStorage.getItem('token')),
                                username: sessionData.username,
                                webauthnkeys: '',
                                rawid: null,
                            }),
                        });
                        let responseJson = await res.json();

                        let code = responseJson.code;
                        let data = responseJson.data;
                        let message = responseJson.message;
                        if (code == 200)
                        {
                            let formData = new FormData();
                            formData.append('method', 'registercredential');
                            formData.append('registerusername', sessionData.username);
                            formData.append('idUser', sessionData.idUser);
                            formData.append('webauthnkeys', data.webauthnkeys);
                            formData.append('crossplatform', cp);
                            // console.log(formData)
                            fetch('../model/user_model.php', {
                                method: 'POST',
                                body: formData,
                            })
                                .then((response) => response.json())
                                .then((responseJsonTwo) => {
                                    let code = responseJsonTwo.code;
                                    let data_challenge = responseJsonTwo.challenge;
                                    let webauthnkeys = responseJsonTwo.webauthnkeys;
                                    if (code == 200)
                                    {
                                        // console.log(data);
                                        webauthnRegister(data_challenge, function (success, info) {
                                            if (success)
                                            {
                                                // console.log(info)
                                                preloader('show');
                                                let formData = new FormData();
                                                formData.append('method', 'registerfinish');
                                                formData.append('register', info);
                                                formData.append('username', sessionData.username);
                                                formData.append('webauthnkeys', webauthnkeys);

                                                fetch('../model/user_model.php', {
                                                    method: 'POST',
                                                    body: formData,
                                                })
                                                    .then((response) => response.json())
                                                    .then((responseJson3) => {
                                                        console.log(responseJson3);
                                                        let code = responseJson3.code;
                                                        let data3 = responseJson3.data;
                                                        if (code == 200)
                                                        {
                                                            console.log(data3);
                                                            fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/addWebAuthnKeys', {
                                                                method: 'POST',
                                                                headers: {
                                                                    Accept: 'application/json',
                                                                    'Content-Type': 'application/json',
                                                                },
                                                                body: JSON.stringify({
                                                                    // your expected POST request payload goes here
                                                                    token: JSON.parse(localStorage.getItem('token')),
                                                                    username: sessionData.username,
                                                                    webauthnkeys: data3.webauthnkeys,
                                                                    rawid: data3.rawid,
                                                                }),
                                                            })
                                                                .then((response) => response.json())
                                                                .then((responseJson4) => {
                                                                    let code = responseJson4.code;
                                                                    let data4 = responseJson4.data;
                                                                    if (code == 200)
                                                                    {
                                                                        localStorage.setItem('challenge', data3.challenge);
                                                                        localStorage.setItem('webauthnkeys', data4.webauthnkeys);
                                                                        preloader('hide');
                                                                        swal.fire('ok', 'Huella ok', 'success');
                                                                        document.getElementById('iregisterform').classList.add('d-none');
                                                                        //alert(t.challenge);
                                                                        // updateObject({ webauthnkeys: data.webauthnkeys });
                                                                    } else if (code == 204)
                                                                    {
                                                                        swal.fire('Error', message, 'error');
                                                                    }
                                                                })
                                                                .catch((error) => {
                                                                    console.error('Error:', error);
                                                                });
                                                        } else if (code == 204)
                                                        {
                                                            swal.fire('Error', aLangKeys[ lang ][ 'aborted-fingerprint' ], 'error');
                                                        }
                                                    })
                                                    .catch((error) => {
                                                        console.error('Error:', error);
                                                    });
                                            } else
                                            {
                                                Swal.fire({
                                                    icon: 'error',
                                                    title: aLangKeys[ lang ][ 'aborted-fingerprint' ],
                                                });
                                            }
                                        });
                                    } else if (code == 204)
                                    {
                                        swal.fire('Error', message, 'error');
                                    }
                                })
                                .catch((error) => {
                                    console.error('Error:', error);
                                });
                        }
                    } catch (error)
                    {
                        console.log(error);
                    }
                };
                addCredential();
            });
        }
    }
    // chat mms
    let UploadMedia = document.querySelectorAll('#buttonUploadMedia');

    if (UploadMedia.length)
    {
        UploadMedia[ 0 ].addEventListener('click', () => {
            let lang = sessionStorage.getItem('lang');
            lang = lang != null ? lang : 'es';
            preloader('show');
            let storageRef = firebase.storage().ref('mms/');
            let file = $('#image-data').attr('src');
            // let inputImage = $('#image');
            console.log(' file', file);
            // let pathname = `${sessionData.idUser}/${Math.random().toString(36).substr(2, 5)}.gif`;
            // console.log(pathname);
            if (file.length != 0)
            {
                const modifiedImage = async () => {
                    try
                    {
                        let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/logsms/mmsoutbount', {
                            method: 'POST',
                            headers: {
                                Accept: 'application/json',
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                //"token, localphone, externalnumber, message, url"
                                token: JSON.parse(localStorage.getItem('token')),
                                localphone: sessionData.selectedPhone,
                                externalnumber: localStorage.getItem('externalNumber'),
                                message: $('#multimedia-message').val(),
                                image: file,
                            }),
                        });
                        let responseJson = await res.json();
                        //console.log(responseJson)
                        let code = responseJson.code;
                        let data = responseJson.data;
                        preloader('hide');
                        if (code == 200 && data.url != 'undefined' && data.message == '')
                        {
                            let html = `<div>
                            <img class="message-speech speech-bubble speech-left bg-green-dark" data-sms-id="${data.id}"  src=" ${data.url}" width="200"/>
                            <div class="clearfix"></div>
                            </div>
                             
                               
                                <em class="speech-read mb-3 "><i class="fa fa-spinner fa-spin"></i><i class="fa fa-clock-o pe-2 color-green-dark"></i>${aLangKeys[ lang ][ 'sending' ]}</em>`;

                            let documentConversations = document.getElementById('chat-page');
                            documentConversations.insertAdjacentHTML('beforeend', html);
                            $('.speech-read').text(aLangKeys[ lang ][ 'sent' ]);
                            $('.menu-hider').removeClass('menu-active');
                            $('.menu-box-bottom').removeClass('menu-active');
                        }

                        if (code == 200 && data.message != '' && data.url != 'undefined')
                        {
                            let html = ` <div class="message-speech speech-bubble speech-left bg-green-dark  " data-sms-id="${data.id}">
                            <img class ="message-speech speech-bubble speech-left bg-green-dark especial "  style ="left :15px !important;"   src=" ${data.url}" width="200"/>
                            ${data.message}  
                            </div>
                            <div class="clearfix"></div>
                                <em class="speech-read mb-3 "><i class="fa fa-spinner fa-spin"></i><i class="fa fa-clock-o pe-2 color-green-dark"></i>${aLangKeys[ lang ][ 'sending' ]}</em>`;

                            let documentConversations = document.getElementById('chat-page');
                            documentConversations.insertAdjacentHTML('beforeend', html);
                            $('.speech-read').text(aLangKeys[ lang ][ 'sent' ]);
                            $('.menu-hider').removeClass('menu-active');
                            $('.menu-box-bottom').removeClass('menu-active');
                        }
                        if (code == 200 && data.url == 'undefined')
                        {
                            Swal.fire({
                                icon: 'error',
                                title: aLangKeys[ lang ][ 'file-exceeds' ],
                            });
                        }
                        if (code == 204)
                        {
                            Swal.fire({
                                icon: 'error',
                                title: aLangKeys[ lang ][ 'invalid-code-international' ],
                            });
                        }
                    } catch (error)
                    {
                        console.log(error);
                    }
                };
                modifiedImage();
                // location.reload();
            }
            //endif file
            else
            {
                Swal.fire({
                    icon: 'error',
                    title: 'No have a photo charged',
                });
            }
        });
    }

    //alert(challenge);

    //Contact Image
    let buttonEditImageUser = document.querySelectorAll('#buttonUploadFile');

    if (buttonEditImageUser.length)
    {
        buttonEditImageUser[ 0 ].addEventListener('click', () => {
            preloader('show');
            let storageRef = firebase.storage().ref('contacts/');
            let idContacts = $('#id_related').val();
            let file = $('#image').attr('src');
            let pathname = `${idContacts}/${idContacts}.jpg`;
            console.log(file);
            if (file.length != 0)
            {
                //si tiene foto cargada
                let uploadTask = storageRef.child(pathname).putString(file, 'data_url');

                uploadTask.on(
                    'state_changed',
                    function (snapshot) {
                        let progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
                        console.log('Upload is ' + progress + '% done');
                        console.log(snapshot.state);
                        switch (snapshot.state)
                        {
                            case firebase.storage.TaskState.PAUSED: // or 'paused'
                                console.log('paused', progress);
                                break;
                            case firebase.storage.TaskState.RUNNING: // or 'running'
                                console.log('running', progress);
                                break;
                        }
                    },
                    function (error) {
                        console.log(error);
                    },
                    function () {
                        uploadTask.snapshot.ref.getDownloadURL().then(function (downloadURL) {
                            const modifiedImage = async () => {
                                try
                                {
                                    let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/setimage', {
                                        method: 'POST',
                                        headers: {
                                            Accept: 'application/json',
                                            'Content-Type': 'application/json',
                                        },
                                        body: JSON.stringify({
                                            // your expected POST request payload goes here
                                            token: sessionToken,
                                            id: idContacts,
                                            image_url: downloadURL,
                                            image_path: pathname,
                                        }),
                                    });
                                    let responseJson = await res.json();
                                    //console.log(responseJson)
                                    let code = responseJson.code;
                                    let message = responseJson.message;
                                    preloader('hide');
                                    if (code == 200)
                                    {
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'ok',
                                        });
                                        document.querySelector('#modal_add_avatar').classList.remove('menu-active');
                                        $('#contact-list').html('');
                                        loadQuotes(0, limit);
                                    }
                                } catch (error)
                                {
                                    console.log(error);
                                }
                            };
                            modifiedImage();
                            location.reload();
                        });
                    }
                );
            }
            //endif file
            else
            {
                Swal.fire({
                    icon: 'error',
                    title: 'No have a photo charged',
                });
            }
        });
    }

    //Importar Contacos desde el tlf
    if (supported)
    {
        // const divNotSupported = document.getElementById('notSupported');
        // divNotSupported.classList.toggle('hidden', true);
        checkProperties();
    }

    let butReq = document.querySelectorAll('#butRequest');
    if (butReq.length)
    {
        ulResults = document.getElementById('results');
        preResults = document.getElementById('rawResults');
        butReq[ 0 ].addEventListener('click', getContactsImports);

        if (isMobileDevice)
        {
            butReq[ 0 ].style.opacity = 1;
        } else
        {
            butReq[ 0 ].style.opacity = 0;
        }
    }

    //Import Contacts
    async function checkProperties () {
        const supportedProperties = await navigator.contacts.getProperties();
        if (supportedProperties.includes('name'))
        {
            enableProp(cbName);
        }
        if (supportedProperties.includes('email'))
        {
            enableProp(cbEmail);
        }
        if (supportedProperties.includes('tel'))
        {
            enableProp(cbTel);
        }
        if (supportedProperties.includes('address'))
        {
            enableProp(cbAddress);
        }
        if (supportedProperties.includes('icon'))
        {
            enableProp(cbIcon);
        }
    }

    async function getContactsImports () {
        // alert('getContactsImports');
        const props = [];
        if (cbName == true) props.push('name');
        if (cbEmail == true) props.push('email');
        if (cbTel == true) props.push('tel');
        // if (cbAddress.checked) props.push('address');
        // if (cbIcon.checked) props.push('icon');

        // const opts = { multiple: cbMultiple == true };
        const opts = { multiple: true };
        // console.log(opts)
        try
        {
            const contacts = await navigator.contacts.select(props, opts);
            handleResults(contacts);
        } catch (ex)
        {
            ulResults.classList.toggle('error', true);
            ulResults.classList.toggle('success', false);
            ulResults.innerText = ex.toString();
        }
    }

    function handleResults (contacts) {
        ulResults.classList.toggle('success', true);
        ulResults.classList.toggle('error', false);
        ulResults.innerHTML = '';
        renderResults(contacts);
    }

    function enableProp (cbox) {
        cbox.removeAttribute('disabled');
        cbox.setAttribute('checked', 'checked');
    }

    function renderResults (contacts) {
        if (contacts.length)
        {
            let texto = 'contactos a importar: ';
            contacts.forEach((contact, index) => {
                if (index < 3) texto += '<strong>' + contact.name.toString() + '</strong>, ';
            });
            ulResults.innerHTML = contacts.length;
            if (contacts.length > 3)
            {
                texto += '<strong>' + (contacts.length - 3).toString() + '</strong> contactos mas.';
            }

            Swal.fire({
                title: 'Are you sure to perform this action?',
                html: texto,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, import contacts!',
            }).then((result) => {
                if (result.isConfirmed)
                {
                    preloader('show');
                    var jsonData = [];
                    contacts.forEach((contact, index) => {
                        var names = [],
                            jsonRow = {};

                        names = contact.name.toString();
                        names = names.split(' ');

                        jsonRow[ 'first_name' ] = names[ 0 ];
                        jsonRow[ 'last_name' ] = names[ 1 ];
                        jsonRow[ 'phone' ] = contact.tel.toString();
                        jsonRow[ 'email' ] = contact.email.toString();

                        jsonData.push(jsonRow);
                    });
                    fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/addmultiple', {
                        method: 'POST',
                        body: JSON.stringify({
                            token: sessionToken,
                            list: jsonData,
                        }),
                        headers: {
                            Accept: 'application/json',
                            'Content-Type': 'application/json',
                        },
                    })
                        .then((response) => response.json())
                        .then((responseJson) => {
                            preloader('hide');
                            let code = responseJson.code;
                            let message = responseJson.message;
                            // alert(JSON.stringify(responseJson))
                            if (code == 200)
                            {
                                // ulResults.append(JSON.stringify(responseJson))
                                listContactDesc();
                                loadQuotes(0, limit, 2);
                                swal.fire('Ok', message, 'success');
                            }
                            location.reload();
                        });
                    const strContacts = JSON.stringify(contacts);
                    // alert(strContacts);
                }
            });
        }
    }

    //Fix Scroll for AJAX pages.
    if ('scrollRestoration' in window.history) window.history.scrollRestoration = 'manual';

    //End of Init Template
    if (isAJAX === true)
    {
        if (window.location.protocol !== 'file:')
        {
            const options = {
                containers: [ '#page' ],
                cache: false,
                animateHistoryBrowsing: false,
                plugins: [ new SwupPreloadPlugin() ],
                linkSelector:
                    'a[class^="external-link"]:not([data-no-swup]),a[class^="default-link"]:not([data-no-swup]), a[href^="https"]:not([data-no-swup]), a[href^="http"]:not([data-no-swup]),a[data-gallery]:not([data-no-swup]) ',
            };
            const swup = new Swup(options);
            document.addEventListener('swup:pageView', (e) => {
                init_template();
            });

            domReady(() => {
                let param = pathPage[ 0 ].split('.').slice(0, -1);
                menuApp(param[ 0 ]);
                setting();
                settingsLanguage();
                copyright();
                header();
                headerSms();
                selectNumber();

                switch (param[ 0 ])
                {
                    case 'signin':
                        break;
                    case 'index':
                        if (sessionToken == null) logout();
                        console.log(sessionData);
                        const imageUser = document.getElementById('imageUser');

                        if (sessionData.imageUrl != null)
                        {
                            console.log(sessionData);
                            imageUser.setAttribute('src', sessionData.imageUrl);
                        } else
                        {
                            imageUser.setAttribute('src', '../../assets/images/pictures/usuario-sin-foto.jpg');
                        }
                        dom('nameUser', sessionData?.name.toUpperCase());

                        if (sessionData.email == null)
                        {
                            sessionData.email = sessionData.email;
                        } else
                        {
                            dom('clientEmail', sessionData?.email.toUpperCase());
                        }

                        dom('localPhone', sessionData?.selectedPhone);

                        break;
                    case 'contacts':
                        if (sessionToken == null) logout();
                        firebaseInit();
                        //Lista de Contactos
                        let contactEl = document.querySelector('#contact-list');

                        $('#contact-list').scroll(function (event) {
                            //TODO
                            $('#p-log').html(
                                $('#contact-list').prop('scrollTop') +
                                $('#contact-list').prop('clientHeight') +
                                ' == ' +
                                $('#contact-list').prop('scrollHeight') +
                                ' && ' +
                                hasMoreQuotes(currentPage, limit, total)
                            );
                            //TODO
                            if (
                                $('#contact-list').prop('scrollTop') + $('#contact-list').prop('clientHeight') >= $('#contact-list').prop('scrollHeight') - 0.9 &&
                                hasMoreQuotes(currentPage, limit, total)
                            )
                            {
                                currentPage += 10;
                                loadQuotes(currentPage, limit);
                            }
                        });
                        loadQuotes(0, limit);

                        listContactDesc();
                        //VALIDATIONS
                        $('#contacts_form').validate({
                            ignore: [],
                            debug: false,
                            rules: {
                                input_first_name: {
                                    required: true,
                                },
                                input_phone: {
                                    required: true,
                                },
                            },
                            errorElement: 'span',
                            errorPlacement: (error, element) => {
                                error.addClass('.color-highlight');
                                element.closest('.form-control validate-text').append(error);
                            },
                            highlight: (element, errorClass, validClass) => {
                                $(element).addClass('is-invalid').removeClass('is-valid');
                            },
                            unhighlight: (element, errorClass, validClass) => {
                                $(element).addClass('is-valid').removeClass('is-invalid');
                            },
                            submitHandler: (form) => { },
                            invalidHandler: () => { },
                        });

                        break;
                    case 'conversations':
                        if (sessionToken == null) logout();

                        break;
                    case 'chat':
                        if (sessionToken == null) logout();
                        firebaseInit();
                        break;
                    case 'profile':
                        if (sessionToken == null)
                        {
                            logout();
                        }
                        firebaseInit();
                        console.log(sessionData);

                        if (window.PublicKeyCredential)
                        {
                            PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable().then((uvpaa) => {
                                //alert(uvpaa)
                                if (uvpaa)
                                {
                                    document.querySelector('#iregisterform').classList.remove('d-none');
                                } else
                                {
                                    document.getElementById('uvpa_unavailable').classList.remove('d-none');
                                }
                            });
                        } else
                        {
                            document.getElementById('uvpa_unavailable').classList.remove('d-none');
                        }

                        if (sessionData.imagePath != null)
                        {
                            console.log(sessionData);
                            document.getElementById('imageUser').setAttribute('data-src', sessionData.imageUrl);
                            document.getElementById('imageUser').setAttribute('src', sessionData.imageUrl);
                            // document.getElementById('image-data').setAttribute('src', sessionData.imageUrl);
                            // document.getElementsByClassName('file-data')[0].classList.add('disabled');
                            document.getElementsByClassName('upload-file-data')[ 0 ].classList.remove('disabled');
                        } else
                        {
                            document.getElementById('imageUser').setAttribute('data-src', '../../assets/images/pictures/usuario-sin-foto.jpg');
                            document.getElementById('imageUser').setAttribute('src', '../../assets/images/pictures/usuario-sin-foto.jpg');
                            // document.getElementById('image-data').setAttribute('src', '../../assets/images/upload.webp');
                            // document.getElementsByClassName('file-data')[0].classList.remove('disabled');
                            // document.getElementsByClassName('upload-file-data')[0].classList.add('disabled');
                        }

                        dom('nameUserProfile', sessionData.name);
                        dom('localPhoneProfile', sessionData.selectedPhone);

                        //Form

                        // document.getElementById('edit_name_profile').value = sessionData.name;
                        document.getElementById('edit_username_profile').value = sessionData.username;
                        document.getElementById('edit_name_profile').value = sessionData.name;
                        document.getElementById('edit_email_profile').value = sessionData.email;

                        //Profile Password Validation
                        $('#formPasswordProfile').validate({
                            rules: {
                                edit_actual_password_profile: {
                                    required: true,
                                },
                                edit_new_password_profile: {
                                    required: true,
                                    minlength: 6,
                                },
                                edit_confirm_password_profile: {
                                    required: true,
                                    minlength: 6,
                                    equalTo: '#edit_new_password_profile',
                                },
                            },
                            messages: {
                                edit_confirm_password_profile: {
                                    equalTo: 'Passwords do not match',
                                },
                            },
                            errorElement: 'p',
                            errorPlacement: function (error, element) {
                                console.log(error);
                                error.addClass('invalid-feedback');
                                element.closest('.input-style').append(error);
                            },
                            highlight: function (element, errorClass, validClass) {
                                $(element).addClass('is-invalid');
                            },
                            unhighlight: function (element, errorClass, validClass) {
                                $(element).removeClass('is-invalid');
                            },
                        });

                        let challenge = '';
                        if (localStorage.getItem('challenge') === null)
                        {
                            challenge = null;
                        } else
                        {
                            challenge = localStorage.getItem('challenge');
                        }
                        //alert(challenge);

                        break;
                }
            });
        }
    }

    //FIReBASE

    function firebaseInit () {
        let config = {
            apiKey: 'AIzaSyAKX9p-T6SaAS_pc9gmVlUPcAU_9ETGyEg',
            authDomain: 'chatsms-d6874.firebaseapp.com',
            projectId: 'chatsms-d6874',
            storageBucket: 'chatsms-d6874.appspot.com',
            messagingSenderId: '999124995148',
            appId: '1:999124995148:web:7e3453e89fa8c264b6b8e9',
            measurementId: 'G-R01S2D7VE5',
        };

        if (!firebase.apps.length)
        {
            //verifica si ya esta cargada app para evitar error por duplicacion
            console.log('JC >>> firebase.initializeApp');
            firebase.initializeApp(config);
        }
        let email = 'gosmartcrm@gmail.com';
        //let formData = new FormData();
        //formData.append('method', 'getTokenFirebase');
        //formData.append('email', email);

        const getToken = async () => {
            try
            {
                let res = await fetch('https://wschatsms.gosmartcrm.com:3900/ws/user/setTokenFirebase', {
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        // your expected POST request payload goes here
                        token: sessionToken,
                        email: email,
                    }),
                });
                let responseJson = await res.json();
                let code = responseJson.code;
                let data = responseJson.data;
                let message = responseJson.message;

                if (code == 200)
                {
                    firebase
                        .auth()
                        .signInWithEmailAndPassword(email, data)
                        .catch(function (error) {
                            var errorCode = error.code;
                            var errorMessage = error.message;
                        });
                }
            } catch (error) { }
        };
        getToken();
    }

    init_template();
});

function domReady (callback) {
    document.readyState === 'interactive' || document.readyState === 'complete' ? callback() : document.addEventListener('DOMContentLoaded', callback);
}
/*
 * logout
 */
const logout = () => {
    localStorage.removeItem('user');
    localStorage.removeItem('token');
    window.location.href = 'signin.html';
};

const getChatSms = (externalNumber) => {
    localStorage.setItem('externalNumber', externalNumber);
    window.location.href = 'chat.html';
};

const capitalize = (s) => {
    if (typeof s !== 'string') return '';
    return s.charAt(0).toUpperCase() + s.slice(1);
};

const deleteConvertation = () => {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    externalNumber = selectedConversation;
    Swal.fire({
        title: aLangKeys[ lang ][ 'delete-conversation' ],
        text: aLangKeys[ lang ][ 'revert' ],
        icon: 'warning',
        showCancelButton: aLangKeys[ lang ][ 'cancel' ],
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: aLangKeys[ lang ][ 'confirm' ],
    }).then((result) => {
        if (result.isConfirmed)
        {
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/logsms/deleteconversation', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    externalnumber: externalNumber,
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        $(`div.conversation[data-external-number="${externalNumber}"]`).remove();
                        $(`div.divider[data-external-number="${externalNumber}"]`).remove();
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
            // Swal.fire('Deleted!', 'Your file has been deleted.', 'success');
        }
    });
};

function transformChat (listSms) {
    listSms.forEach((sms, index) => {
        let localDate = new Date(sms.created);
        // console.log('localDate >>', localDate);
        let diff = moment().diff(moment(localDate).format('ll'), 'days');
        if (diff == 0)
        {
            let calendar = moment(localDate).subtract('days').calendar();
            // console.log('calendar', diff, calendar, calendar.indexOf('Yesterday'));
            if (calendar.indexOf('Yesterday') >= 0)
            {
                diff = 1;
            }
        }
        // diff = moment().subtract(diff, 'days').calendar()
        // console.log(diff);
        switch (diff)
        {
            case 0:
                sms.group = 'Hoy';
                break;
            case 1:
                sms.group = 'Ayer';
                break;
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
                sms.group = moment(localDate).format('dddd D');
                break;
            default:
                sms.group = moment(localDate).format('ddd D MMM YYYY');
                break;
        }
        listSms[ index ] = sms;
    });

    // console.log('transformChat > forEach', listSms);
    return listSms;
}

const showChatSms = (position, start, animate = false) => {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    setLanguage(lang);

    fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/getpagesms', {
        method: 'POST',
        body: JSON.stringify({
            token: JSON.parse(localStorage.getItem('token')),
            start: start,
            length: 20,
            search: localStorage.getItem('externalNumber'),
        }),
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json',
        },
    })
        .then((response) => response.json())
        .then((responseJson) => {
            // preloader('hide');
            let code = responseJson.code;
            let data = responseJson.data;
            let message = responseJson.message;
            recordsFiltered = data.recordsTotal;
            let listSms = data.listSms;
            let contact = data.contact;
            console.log(data);

            if (code == 200)
            {
                let lang = sessionStorage.getItem('lang');
                lang = lang != null ? lang : 'es';
                setLanguage(lang);
                let fullName = '';
                let externalnumber = '';
                let externalnumber2 = '';
                let imageUrl = '';

                fullName = contact.full_name == '' ? contact.external_number : contact.full_name;
                externalnumber = contact.full_name == '' ? '' : contact.external_number.split(',')[ 0 ];
                externalnumber2 = contact.full_name == '' ? '' : contact.external_number.split(',')[ 1 ];
                imageUrl = contact.image_url == null || contact.image_url == '' ? '../../assets/images/pictures/usuario-sin-foto.jpg' : contact.image_url;

                if (contact.full_name == '')
                {
                    $('#span-full-name').attr('style', 'display: inherit !important;');
                }

                if (contact.id_contacts != '')
                {
                    $('#btnAddContact').attr('style', 'display: none;');
                }

                var objects = $('.message-speech');
                console.log(objects);
                listSms = transformChat(listSms);
                let smsGroup = '';
                let smsCount = 1;
                listSms.forEach((sms) => {
                    let localDate = new Date(sms.created);
                    let created = moment(localDate).format('ddd D MMM YYYY');
                    let hora = moment(localDate).format('LT');
                    // console.log(sms);
                    let html = '';

                    if (listSms.length == smsCount)
                    {
                        html += ` <span class="boxed-text-l">${smsGroup}</span> `;
                        smsGroup = sms.group;
                    }

                    if (sms.type_message == 1 && sms.type == 1)
                    {
                        html += `
                        <div class="message-speech speech-bubble speech-right color-black" data-sms-id="${sms.id}">
                           ${sms.message}
                           <div class="clearfix"></div>
                           <p class="line-height-s accordion-icon" style="font-size: 9px; margin: 0 0 0 1.5rem !important;"> ${hora} </p>
                            </div>
                            <div class="clearfix"></div>
                            <em id ="line" class=" message-speech speech-read-left mb-3 line-${sms.id}" data-sms-id="${sms.id}" style="display:none;"> Linea  ${sms.line} </em>
                            <div class="clearfix"></div>
                           `;
                    }
                    if (sms.type_message == 1 && sms.type == 2)
                    {
                        html += `
                        <div class="message-speech speech-bubble speech-left bg-green-dark"  data-sms-id="${sms.id}">
                            ${sms.message}  
                            <div class="clearfix"></div>
                            <p class="line-height-s accordion-icon" style="font-size: 9px; margin: 0 0 0 1.5rem !important;"> ${hora} </p>
                            </div>
                            <div class="clearfix"></div>
                            <em id ="line" class=" message-speech  speech-read-right mb-3 line-${sms.id}" data-sms-id="${sms.id}" style="display:none;"> Linea  ${sms.line}</em>
                            <div class="clearfix"></div>
                           `;
                    }

                    if (sms.type_message == 2 && sms.type == 1 && sms.message != '' && sms.url != 'undefined')
                    {
                        html += `
                         <div class="message-speech speech-bubble speech-right color-black  " data-sms-id="${sms.id}">
                        <img class ="message-speech speech-bubble speech-right color-black especial-right "  style ="right :15px !important;"   src=" ${sms.url}" width="200"/>
                        ${sms.message} 
                        <div class="clearfix"></div>
                        <p class="line-height-s accordion-icon" style="font-size: 9px; margin: 0 0 0 1.5rem !important;"> ${hora} </p> 
                        </div>
                        <div class="clearfix"></div>
                        <em id ="line" class=" message-speech speech-read-left mb-3 line-${sms.id}" data-sms-id="${sms.id}"  style="display:none;"> Linea  ${sms.line}</em>
                         `;
                    }

                    if (sms.type_message == 2 && sms.type == 2 && sms.message != '' && sms.url != 'undefined')
                    {
                        html += `
                        <div class="message-speech speech-bubble speech-left bg-green-dark  " data-sms-id="${sms.id}">
                        <img class ="message-speech speech-bubble speech-left bg-green-dark especial "  style ="left :15px !important;"   src=" ${sms.url}" width="200"/>
                        ${sms.message}  
                        <div class="clearfix"></div>
                        <p class="line-height-s accordion-icon" style="font-size: 9px; margin: 0 0 0 1.5rem !important;"> ${hora} </p> 
                        </div>
                        <div class="clearfix"></div>
                        <em id ="line" class=" message-speech  speech-read-right mb-3 line-${sms.id}" data-sms-id="${sms.id}"  style="display:none;"> Linea  ${sms.line}</em>
                         `;
                    }

                    if (sms.type_message == 2 && sms.type == 1 && sms.message == '' && sms.url != 'undefined')
                    {
                        html += `
                        <img class="message-speech speech-bubble speech-right color-black"  data-sms-id="${sms.id}" src=" ${sms.url}" width="200"/>
                        <div class="clearfix"></div>
                        <em id ="line" class="message-speech  speech-read-left mb-3 line-${sms.id}" data-sms-id="${sms.id}"  style="display:none;"> Linea  ${sms.line}</em>
                        </div> `;
                    }

                    if (sms.type_message == 2 && sms.type == 2 && sms.message == '' && sms.url != 'undefined')
                    {
                        html += `
                        <div>
                        <img class="message-speech speech-bubble speech-left bg-green-dark" data-sms-id="${sms.id}"  src=" ${sms.url}" width="200"/>
                        <div class="clearfix"></div>
                        <em id ="line" class=" message-speech  speech-read-right mb-3 line-${sms.id}"  data-sms-id="${sms.id}"  style="display:none;"> Linea  ${sms.line}</em>
                        </div>
                        `;
                    }
                    if (smsGroup != sms.group)
                    {
                        html += ` <span class="boxed-text-l">${smsGroup}</span> `;
                        smsGroup = sms.group;
                    }
                    html += `<div class="clearfix"></div>`;

                    let elementChatPage = document.getElementById('chat-page');
                    elementChatPage.insertAdjacentHTML(position, html);
                    if (animate)
                    {
                        $('#chat-page')
                            .stop()
                            .animate({ scrollTop: $('#chat-page')[ 0 ].scrollHeight }, 500);
                    }
                    smsCount++;
                });

                $('.image-url').attr('src', imageUrl);
                $('.full-name').text(fullName);
                $('.external-number').text(externalnumber);
                $('.external-number2').text(externalnumber2);
            } else if (code == 204)
            {
                swal.fire('Error', message, 'error');
            }

            selectionSms();
        });
};

function selectionSms () {
    $('.message-speech').unbind();
    addEventListenerTouch();
}

function deleteSms () {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    Swal.fire({
        title: aLangKeys[ lang ][ 'delete-messages' ],
        text: aLangKeys[ lang ][ 'revert' ],
        icon: 'warning',
        showCancelButton: aLangKeys[ lang ][ 'cancel' ],
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: aLangKeys[ lang ][ 'confirm' ],
    }).then((result) => {
        if (result.isConfirmed)
        {
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/logsms/deletesms', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    id: smsIds.slice(0, -1),
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        var listIds = smsIds.split(',');
                        listIds.forEach((id) => {
                            $(`div.message-speech[data-sms-id="${id}"]`).remove(); // aca tu codigo
                            $(`img.message-speech[data-sms-id="${id}"]`).remove(); // aca tu codigo
                            $(`em.message-speech[data-sms-id="${id}"]`).remove(); // aca tu codigo
                        });
                        smsIds = '';
                        $('#a-trash').hide();
                        recordsFiltered = recordsFiltered - listIds.length;
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
            // Swal.fire('Deleted!', 'Your file has been deleted.', 'success');
        }
    });
}

function deleteContact (id) {
    let div_preloader = document.getElementById('preloader');
    const preloader = (type, origin = '') => {
        if (type == 'show')
        {
            div_preloader.classList.remove('preloader-hide');
            div_preloader.classList.add('preloader-show');
        } else
        {
            setTimeout(function () {
                div_preloader.classList.remove('preloader-show');
                div_preloader.classList.add('preloader-hide');
            }, 1000);
        }
    };
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    Swal.fire({
        title: aLangKeys[ lang ][ 'delete-contact' ],
        text: aLangKeys[ lang ][ 'revert' ],
        icon: 'warning',
        showCancelButton: aLangKeys[ lang ][ 'cancel' ],
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: aLangKeys[ lang ][ 'confirm' ],
    }).then((result) => {
        if (result.isConfirmed)
        {
            preloader('show');
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/deletecontact', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    id: id,
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let message = responseJson.message;

                    if (code == 200)
                    {
                        var listIds = id.split(',');
                        listIds.forEach((id) => {
                            $(`div.div-contact[data-contact-id="${id}"]`).remove(); // aca tu codigo
                        });
                        swal.fire(aLangKeys[ lang ][ 'contact-deleted' ], message, 'warning');
                        preloader('hide');
                        id = '';
                        $('#a-trash').hide();
                        recordsFiltered = recordsFiltered - listIds.length;
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
        }
    });
}

// Delete image
function removeElement (ele) {
    ele.parentNode.removeChild(ele);
}

function blockContact (id, status) {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    Swal.fire({
        title: aLangKeys[ lang ][ 'question-block' ],
        icon: 'warning',
        showCancelButton: aLangKeys[ lang ][ 'cancel' ],
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: aLangKeys[ lang ][ 'confirm' ],
    }).then((result) => {
        if (result.isConfirmed)
        {
            fetch('https://wschatsms.gosmartcrm.com:3900/ws/contact/blockedcontact', {
                method: 'POST',
                body: JSON.stringify({
                    token: JSON.parse(localStorage.getItem('token')),
                    id: id,
                    status: status,
                }),
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let message = responseJson.message;

                    if (code == 200 && status == 0)
                    {
                        // $('#blockdiv').addClass(`fa fa-ban`); // aca tu codigo
                        $('#a-trash').hide();
                        swal.fire(aLangKeys[ lang ][ 'contact-unlocked' ], message, 'success');
                        setTimeout(() => {
                            location.reload();
                        }, '1000');
                    }
                    if (code == 200 && status == 1)
                    {
                        // $('#blockdiv').removeClass(`fa fa-ban`); // aca tu codigo
                        $('#a-trash').hide();
                        swal.fire(aLangKeys[ lang ][ 'contact-blocked' ], message, 'warning');
                        setTimeout(() => {
                            location.reload();
                        }, '1000');
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
        }
    });
}
function addPhone () {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    setLanguage(lang);

    $('#contacts_form');
    // agregar registro
    var html = `<br>
     <div class="form-group col-12">
        <div class="input-style input-style-always-active has-borders no-icon mb-4" id="phonecampo">
            <input type="number" name="input_phone_new[]" class="form-control m-input newphone">
                <label for="input_subject"  class="color-theme opacity-50 text-uppercase font-700 font-10 lang" key="phone">Phone</label>
                <i class="fa fa-times disabled invalid color-red-dark"></i>
                <i class="fa fa-times disabled invalid color-red-dark"></i>
        </div>
    </div> `;
    $('#phonecampo').append(html);
}

function selectionConversation () {
    $('.conversation').unbind();
    addEventListenerTouch();
}

// addEventListener conversation & message-speech
function addEventListenerTouch () {
    list = document.querySelectorAll('.conversation:not(.message-speech),.message-speech:not(.conversation)');

    for (var i = 0; i < list.length; i++)
    {
        list[ i ].addEventListener('touchstart', processTouchStart, false);
        list[ i ].addEventListener('touchend', processTouchEnd, false);
    }
}

// processTouchStart handler
function processTouchStart () {
    timebetween = 0;
    timeInterval = setInterval(() => {
        timebetween++;
    }, 1);
}
// processTouchEnd handler
function processTouchEnd (sms) {
    const pwaConversations = document.querySelectorAll('#div-conversations');
    if (pwaConversations.length)
    {
        if (timebetween >= 20)
        {
            $('#a-trash').hide();
            $('.conversation').each(function () {
                $(this).removeClass('border border-green-dark rounded-s shadow-xs');
            });
            if (selectedConversation != $(this).data('external-number'))
            {
                selectedConversation = $(this).data('external-number');
                $(this).addClass('border border-green-dark rounded-s shadow-xs');
                $('#a-trash').show();
            } else
            {
                selectedConversation = '';
            }
        } else
        {
            getChatSms($(this).data('external-number'));
        }
    } else
    {
        if (timebetween >= 10)
        {
            let sms = $(this).data('sms-id');
            if (smsIds.search($(this).data('sms-id')) != -1)
            {
                $(this).attr('style', 'background: gray;');
                $('.especial').attr('style', ' left : 15px;');
                $('.especial-right').attr('style', ' right : 15px;');
                smsIds = smsIds.replace($(this).data('sms-id') + ',', '');
                $('.line-' + sms).attr('style', 'display: none');
            } else
            {
                smsIds += $(this).data('sms-id') + ',';
                $(this).attr('style', 'background: gray !important;');
                $('.especial').attr('style', 'left : 15px;');
                $('.especial-right').attr('style', ' right : 15px;');
                $('.line-' + sms).attr('style', 'display: block; color :#adb5bd; font-size: 13px;');
            }
        }
        if (smsIds != '')
        {
            $('#a-trash').show();
        } else
        {
            $('#a-trash').hide();
        }
    }
    console.log(smsIds, 'smsIds');
    processTouchClose();
}

//

// processTouchClose handler
function processTouchClose () {
    clearInterval(timeInterval);
    timeInterval = null;
}

function showPassword () {
    var tipo = document.getElementById('input_password');
    if (tipo.type == 'password')
    {
        tipo.type = 'text';
    } else
    {
        tipo.type = 'password';
    }
}

// BEGIN Notificaciones
function enviarNotificacion () {
    const notificationOpts = {
        body: 'Este es el cuerpo de la notificacion',
        icon: 'icon-72x72.png',
    };
    new Notification('Hola mundo', notificationOpts);
}

function requestPermission () {
    if (!window.Notification)
    {
        return;
    }
    if (Notification.permission !== 'denied' || Notification.permission === 'default')
    {
        Notification.requestPermission(function (permission) {
            if (permission === 'granted')
            {
                // new Notification ('Hola Mundo!- pregunta');
                enviarNotificacion();
            }
        });
    }
}

function deleteMedia () {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    let button_delete_media = document.querySelectorAll('#buttonDeleteMedia');
    if (button_delete_media.length)
    {
        button_delete_media[ 0 ].addEventListener('click', () => {
            document.getElementById('image-data').setAttribute('src', '../../assets/images/upload.webp');
        });
    }
}

function modalAddContact () {
    let lang = sessionStorage.getItem('lang');
    lang = lang != null ? lang : 'es';
    let button_add_contact = document.querySelectorAll('#btnAddContact');
    if (button_add_contact.length)
    {
        button_add_contact[ 0 ].addEventListener('click', () => {
            // clearContactForm();
            document.querySelector('#modal_add_contact_conversation').classList.add('menu-active');
            document.querySelector('#menu-user-cog').classList.remove('menu-active');
        });
    }
}

function saveContactConversation () {
    let div_preloader = document.getElementById('preloader');
    const preloader = (type, origin = '') => {
        if (type == 'show')
        {
            div_preloader.classList.remove('preloader-hide');
            div_preloader.classList.add('preloader-show');
        } else
        {
            setTimeout(function () {
                div_preloader.classList.remove('preloader-show');
                div_preloader.classList.add('preloader-hide');
            }, 1000);
        }
    };
    let sessionToken = JSON.parse(localStorage.getItem('token'));
    let sessionData = JSON.parse(localStorage.getItem('user'));
    let externalnumber = localStorage.getItem('externalNumber');
    let token = sessionToken;
    let button_save_contact = document.querySelectorAll('#button_save_contact_conversation');
    if (button_save_contact.length)
    {
        button_save_contact[ 0 ].addEventListener('click', () => {
            // if ($('#contact_form_conversation').valid()) {
            let id_contact = $('#input_id').val();
            let id_contact_phone = $('#input_contact_phone').val();
            url = '';
            preloader('show');
            id_contact == '' ? (url = 'https://wschatsms.gosmartcrm.com:3900/ws/contact/add') : (url = 'https://wschatsms.gosmartcrm.com:3900/ws/contact/update');
            console.log(externalnumber);
            var formData = {
                token: token,
                id: id_contact,
                id_contact_phone: id_contact_phone,
                id_system_user: sessionData.idUser,
                first_name: $('#input_first_name').val(),
                middle_name: $('#input_middle_name').val(),
                last_name: $('#input_last_name').val(),
                second_surname: $('#input_second_surname').val(),
                phone: externalnumber,
                email: $('#input_email').val(),
                address: $('#input_address').val(),
                state: $('#input_state').val(),
                city: $('#input_city').val(),
                country: $('#input_country').val(),
                zip: $('#input_zip').val(),
                client_crm: $('#input_client_crm').val(),
            };
            fetch(url, {
                method: 'POST',
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(formData),
            })
                .then((response) => response.json())
                .then((responseJson) => {
                    let code = responseJson.code;
                    let data = responseJson.data;
                    let message = responseJson.message;

                    // if (code == 403) {
                    //     loginTimeout(message);
                    // }

                    if (code == 200)
                    {
                        preloader('hide');
                        $('#contact-list-desc').html('');
                        $('#menu-user-cog').html('');
                        $('#contact-list').html('');

                        // loadQuotes(0, limit, 2);
                        document.querySelector('#modal_add_contact_conversation').classList.remove('menu-active');
                        setTimeout;
                        swal.fire('Success', message, 'success');
                        setTimeout(() => {
                            location.reload();
                        }, '2000');
                    } else if (code == 204)
                    {
                        swal.fire('Error', message, 'error');
                    }
                });
            // }
        });
    }
}

function urlBase64ToUint8Array (base64String) {
    const padding = '='.repeat((4 - (base64String.length % 4)) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');

    const rawData = window.atob(base64);
    const outputArray = new Uint8Array(rawData.length);

    for (let i = 0; i < rawData.length; ++i)
    {
        outputArray[ i ] = rawData.charCodeAt(i);
    }
    return outputArray;
}
function fileValidation () {
    var fileInput = document.getElementById('file');
    var filePath = fileInput.value;
    var allowedExtensions = /(.jpg|.jpeg|.png|.gif)$/i;
    if (!allowedExtensions.exec(filePath))
    {
        alert('Please upload file having extensions .jpeg/.jpg/.png/.gif only.');
        fileInput.value = '';
        return false;
    } else
    {
        //Image preview
        if (fileInput.files && fileInput.files[ 0 ])
        {
            var reader = new FileReader();
            reader.onload = function (e) {
                document.getElementById('imagePreview').innerHTML = '<img src="' + e.target.result + '"/>';
            };
            reader.readAsDataURL(fileInput.files[ 0 ]);
        }
    }
}

var getPublicKey = function (callback) {
    let token = JSON.parse(localStorage.getItem('token'));
    let body = {
        token: token,
    };
    fetch('https://wschatsms.gosmartcrm.com:3900/ws/webpush/getkey', {
        method: 'POST',
        body: JSON.stringify(body),
        headers: {
            'Content-Type': 'application/json',
        },
    })
        .then((response) => response.json())
        .then((response) => response.data)
        .then((data) => {
            localStorage.setItem('publicKey', data.publicKey);
            callback();
        });
};

var subscribe = function (registration) {
    registration.pushManager
        .subscribe({
            userVisibleOnly: true,
            applicationServerKey: urlBase64ToUint8Array(localStorage.getItem('publicKey')),
        })
        .then((subscription) => {
            let token = JSON.parse(localStorage.getItem('token'));
            let data = {
                token: token,
                endpoint: JSON.stringify(subscription),
            };

            fetch('https://wschatsms.gosmartcrm.com:3900/ws/webpush/subscription', {
                method: 'POST',
                body: JSON.stringify(data),
                headers: {
                    'Content-Type': 'application/json',
                },
            }).then(localStorage.setItem('subscription', true));
        });
};

var unsubscribe = function () {
    let token = JSON.parse(localStorage.getItem('token'));
    let data = {
        token: token,
    };
    fetch('https://wschatsms.gosmartcrm.com:3900/ws/webpush/unsubscription', {
        method: 'POST',
        body: JSON.stringify(data),
        headers: {
            'Content-Type': 'application/json',
        },
    }).then(() => {
        localStorage.removeItem('subscription');
    });
    // TODO espera servicio
    localStorage.removeItem('subscription');
};

// END Notificaciones

var console = window.console || { log: function () { } };
var $image = $('#image');
var options = {
    aspectRatio: 1 / 1,
    preview: '.img-preview',
};
var originalImageURL = $image.attr('src');
var uploadedImageName = 'cropped.jpg';
var uploadedImageType = 'image/jpeg';
var uploadedImageURL;

// Cropper
let button_save_contact = document.querySelectorAll('#button_save_contact');
let buttonEditProfile = document.querySelectorAll('#button_edit_profile');
let pwaMensaje = document.querySelectorAll('#chat-page');
if (button_save_contact.length || buttonEditProfile.length || pwaMensaje.length)
{
    $image
        .on({
            ready: function (e) {
                console.log(e.type);
            },
            cropstart: function (e) {
                console.log(e.type, e.detail.action);
            },
            cropmove: function (e) {
                console.log(e.type, e.detail.action);
            },
            cropend: function (e) {
                console.log(e.type, e.detail.action);
            },
            crop: function (e) {
                console.log(e.type);
            },
            zoom: function (e) {
                console.log(e.type, e.detail.ratio);
            },
        })
        .cropper(options);

    // Import image
    var $inputImage = $('#inputImage');

    if (URL)
    {
        $inputImage.change(function () {
            var files = this.files;
            var file;

            console.log('ln:242', files);

            if (!$image.data('cropper'))
            {
                return;
            }

            if (files && files.length)
            {
                file = files[ 0 ];

                if (/^image\/\w+$/.test(file.type))
                {
                    uploadedImageName = file.name;
                    uploadedImageType = file.type;

                    if (uploadedImageURL)
                    {
                        URL.revokeObjectURL(uploadedImageURL);
                    }

                    uploadedImageURL = URL.createObjectURL(file);
                    $image.cropper('destroy').attr('src', uploadedImageURL).cropper(options);
                    $inputImage.val('');
                    $('.docs-buttons').removeClass('d-none');
                    $('.upload-file-data').removeClass('disabled');
                } else
                {
                    window.alert('Please choose an image file.');
                }
            }
        });
    } else
    {
        $inputImage.prop('disabled', true).parent().addClass('disabled');
    }

    $('.docs-buttons').on('click', '[data-method]', function () {
        var $this = $(this);
        var data = $this.data();
        var cropper = $image.data('cropper');
        var cropped;
        var $target;
        var result;
        console.log(data, cropper);
        // console.log(cropper, data.method);

        if (cropper && data.method)
        {
            data = $.extend({}, data); // Clone a new one

            if (typeof data.target !== 'undefined')
            {
                $target = $(data.target);

                if (typeof data.option === 'undefined')
                {
                    try
                    {
                        data.option = JSON.parse($target.val());
                    } catch (e)
                    {
                        console.log(e.message);
                    }
                }
            }

            cropped = cropper.cropped;

            result = $image.cropper(data.method, data.option, data.secondOption);
            $('.upload-file-data').removeClass('d-none');
            console.log('data.option >>> ', data.secondOption);

            switch (data.method)
            {
                case 'rotate':
                    if (cropped && options.viewMode > 0)
                    {
                        $image.cropper('crop');
                    }

                    break;

                case 'scaleX':
                case 'scaleY':
                    $(this).data('option', -data.option);
                    break;

                case 'getCroppedCanvas':
                    if (result)
                    {
                        // Bootstrap's Modal
                        $image.attr('src', result.toDataURL(uploadedImageType));
                    }

                    break;

                case 'destroy':
                    if (uploadedImageURL)
                    {
                        URL.revokeObjectURL(uploadedImageURL);
                        uploadedImageURL = '';
                        $image.attr('src', originalImageURL);
                    }

                    break;
            }

            if ($.isPlainObject(result) && $target)
            {
                try
                {
                    $target.val(JSON.stringify(result));
                } catch (e)
                {
                    console.log(e.message);
                }
            }
        }
    });
}
$('.close-menu').click(() => {
    $('[data-toggle="popover"]').not(this).popover('hide');
});

let toggle_vis = document.querySelectorAll('input.toggle-vis');
if (toggle_vis.length)
{
    toggle_vis.forEach((el) => {
        el.addEventListener('click', () => {
            // e.preventDefault();
            var column = dataTableHistory.column(el.setAttribute('data-column', column));
            column.visible(!column.visible());
        });
    });
}

function dom (elementId, txt) {
    document.getElementById(elementId).innerHTML = txt;
}
